/*+*******************************************************************

 File:		Relay.h

 Project:	Device Servers for Personnel Safety System relays

 Description:	Public include file for the Relay Class

 Author(s):	Petri Makijarvi

 Original:	September 1991

 Copyright (c) 1991 by European Synchrotron Radiation Facility, 
                       Grenoble, France

********************************************************************-*/
 /*
  $Log:	Relay.h,v $
   Revision 3.3  95/09/04  16:23:57  16:23:57  petri (Petri Makijarvi)
   Ultra-C'fied
   
   Revision 3.2  94/04/11  17:15:38  17:15:38  epaud
   Add MAX_NO_OF_DEVICES (96*4 for 4 icv196)
   
   Revision 3.1  93/02/02  12:30:58  12:30:58  petri (Petri Makijarvi)
   Migrating fro mars to libra
   
   Revision 3.0  92/03/31  15:29:57  15:29:57  meyer (Jens Meyer)
   New major library release (3.x).
   
   Revision 2.1  92/02/06  16:32:22  16:32:22  petri ()
   Ready for installation
   
   Revision 1.9  92/02/06  16:23:13  16:23:13  petri ()
   Moved from the development
   
  Revision 1.3  91/12/10  18:57:45  18:57:45  petri ()
  Tested with AlarmRelay Class
  
  Revision 1.2  91/10/09  13:07:39  13:07:39  petri ()
  Heading to add changes from DSUG.037.2
  
  Revision 1.1  91/09/03  11:30:19  11:30:19  petri ()
  Initial revision
  */

#ifndef _Relay_h
#define _Relay_h

/*
  Definition of the number of devices which can be managed
*/
#define MAX_NO_OF_DEVICES   96*4    /* For 4 icv196 */

/*
 Definition of the Relay Types enumerated
 */
#define RE_TYPE_UNKNOWN  0
#define RE_TYPE_RELAY    1
#define RE_TYPE_PULSED   2
#define RE_TYPE_ALARM    3

/*
  Definition of Relay Class as a pointer to the class record
 */
typedef struct _RelayClassRec *RelayClass;

/*
  Definition of Relay Object as a pointer to the object record
 */
typedef struct _RelayRec *Relay;

/*
  Introduction of the public Relay Class
 */
extern RelayClass relayClass;

#endif /* _Relay_h */

 /* end of $Source: /libra/users/d/dserver/classes/interlock/relay/include/RCS/Relay.h,v $ */







