//static char RcsId[] = "$Header: /segfs/dserver/classes++/motor/oregon/include/RCS/OregonMaxe.h,v 1.3 2000/03/16 23:05:45 goetz Exp $";

//+**********************************************************************
//
// File:	OregonMaxe.h
//
// Project:	Fast stepping stepper motors in VME and/or PC/104
//
// Description:	public include file containing definitions and declarations 
//		for implementing the OregonMaxe class in C++ (OregonMaxeClass).
//
// Author(s):	Andy Gotz
//
// Original:	March 1999
//
// $Revision: 1.3 $
//
// $Date: 2000/03/16 23:05:45 $
//
// $Author: goetz $
//
// $Log: OregonMaxe.h,v $
// Revision 1.3  2000/03/16 23:05:45  goetz
// added message prototypes for StepMode and channels[] array
//
// Revision 1.2  1999/05/19 15:13:39  goetz
// added state or pos change event and moved data to public from private
// so that event thread (a C function) can access it
//
// Revision 1.1  1999/04/13 19:28:07  goetz
// Initial revision
//
//
//+**********************************************************************

#ifndef _OREGONMAXE_H
#define _OREGONMAXE_H
		

// user event to signal state change of one of the axes on an oms card

#define D_EVENT_OMS_STATE_POS_CHANGE DevOmsBase+1

class OregonMaxe : public Device {

typedef struct {
   long 	channel;
   long		state;
   long		units;
   long		position;
   long		position_ok;
   long		direction;
   long		velocity;
   long		firststeprate;
   long 	acceleration;
   long		accelslope;
   long		backlash;
   long		powerauto;
   char		*enc_type;
   double	enc_steps_mm;
   double	enc_factor;
   long		enc_position;
   long		stepmode;
	} Axe;

//
// private members
// 

private :

   long ClassInitialise (long *error );
   long GetResources (char *res_name, long *error);

   static short         class_inited;
   static short		class_destroyed;

   long InitialiseMotors (long *error);
   long CommandAllowedOnMotor (DevCommand cmd, long i_axe, long *error);
   long UpdateDirection (long i_axe, long movement, long position, long *error);
//
// protected members
//

protected:

   long StateMachine (long cmd, long *error);

//
// public members
//

public:

//
// data
//

   long			nb_axes; 		/* no. of axes */
   char 		*descriptor;		/* oms device descriptor */
   long			events;			/* events support flag */
   Oms			*oms;			/* oms card object */
   Axe			axes[8];		/* maximum of 8 axes */
   long			channels[8];		/* list of channels used */
   
//
// commands
//

   long ReadState (void *argin, void *argout, long *error);
   long ReadSwitches (void *argin, void *argout, long *error);
   long ReadPosition (void *argin, void *argout, long *error);
   long ReadMultiplePositions (void *argin, void *argout, long *error);
   long LoadPosition (void *argin, void *argout, long *error);
   long Reset (void *argin, void *argout, long *error);
   long AbortCommand (void *argin, void *argout, long *error);
   long MoveRelative (void *argin, void *argout, long *error);
   long MoveAbsolute (void *argin, void *argout, long *error);
   long MoveMultiple (void *argin, void *argout, long *error);
   long MoveReference (void *argin, void *argout, long *error);
   long SetContinuous (void *argin, void *argout, long *error);
   long SetVelocity (void *argin, void *argout, long *error);
   long SetAcceleration (void *argin, void *argout, long *error);
   long SetFirstStepRate (void *argin, void *argout, long *error);
   long SetBacklash (void *argin, void *argout, long *error);
   long ReadVelocity (void *argin, void *argout, long *error);
   long ReadAcceleration (void *argin, void *argout, long *error);
   long ReadFirstStepRate (void *argin, void *argout, long *error);
   long ReadBacklash (void *argin, void *argout, long *error);
   long ReadEncoderPosition (void *argin, void *argout, long *error);
   long ReadMultipleEncoderPositions (void *argin, void *argout, long *error);
   long LoadEncoderPosition (void *argin, void *argout, long *error);
   long ReadUnits (void *argin, void *argout, long *error);
   long ReadStepMode (void *argin, void *argout, long *error);
   long SetStepMode (void *argin, void *argout, long *error);



   OregonMaxe (char *name, long *error);
// ~OregonMaxe ();

//
// Some very simple member functions to get object private data
//

// inline short get_nada(void) {return(nada);}
};

#endif /* _OREGONMAXE_H */
