/*static char RcsId[] = "$Header: McaAIMP.h,v 5.2 2000/03/23 11:02:29 beteva Rel $";*/

/*********************************************************************
 *
 * File:	McaAIMP.h
 * Project:	Multichannel Analyser device server
 *
 * Description:	This is the Multichannel Analyser device server for the
 *		Acquisition Interface Module of Canberra (AIM). This
 *		module is directly connected oto ethernet. The Device
 *		Server host is an unix machine and the server uses its
 *		Link Level Connection to serve the AIM.
 * Author(s):	L.Claustre/A.Beteva
 * Original:	January 28th 1994	
 * $Log:	McaAIMP.h,v $
 * Revision 5.2  2000/03/23  11:02:29  11:02:29  beteva (A.Beteva)
 * Added net_devfile resource. NOCOMMAND and SIMULATION possibilities
 * 
 * Revision 5.1  1999/02/04  15:05:04  beteva
 * Send slow down. Reset before each send.
 *
 * Revision 5.0  98/11/13  17:02:52  17:02:52  beteva (A.Beteva)
 * switch from LLA to DLPI
 * 
 * Revision 4.7  98/07/02  17:40:27  17:40:27  beteva (A.Beteva)
 * final LLA version (before switching to DLPI)
 * 
 * Revision 4.5  98/07/02  17:35:31  17:35:31  beteva (A.Beteva)
 * final LLA version (before switching to DLPI)
 * 
 * Revision 4.4  96/04/16  14:24:56  14:24:56  beteva (Antonia Beteva)
 * memory allocation in class_init instead of object_ini..
 * 
 * Revision 4.3  96/04/15  17:55:35  17:55:35  beteva (Antonia Beteva)
 * fixed reading other groups in DevMcaReadData
 * 
 * Revision 4.2  96/04/15  17:32:03  17:32:03  beteva (Antonia Beteva)
 * work with independent ADC
 * 
 * Revision 4.1  96/04/12  09:19:52  09:19:52  beteva (Antonia Beteva)
 * works wit independent ADC except for McaReadData
 * 
 * Revision 4.0  95/08/17  11:35:04  11:35:04  beteva (Antonia Beteva)
 * ICB start
 * 
 * Revision 2.12  95/08/17  11:33:35  11:33:35  beteva (Antonia Beteva)
 * *** empty log message ***
 * 
 * Revision 2.11  95/08/17  11:26:14  11:26:14  beteva (Antonia Beteva)
 * *** empty log message ***
 * 
 * Revision 2.10  95/08/16  18:12:42  18:12:42  beteva (Antonia Beteva)
 * fixed version 3
 * 
 * Revision 2.9  94/10/28  11:21:42  11:21:42  claustre (Laurent Claustre)
 * no changes - used only to unlock locked from Laurent files (AB)
 * 
 * Revision 1.4  94/03/15  15:08:55  15:08:55  claustre (Laurent Claustre)
 * Allow DevMcaClearMemory command when the machine state is DEVRUN
 * 
 * Revision 1.3  94/03/07  17:19:49  17:19:49  claustre (Laurent Claustre)
 * Like 1.2
 * 
 * Revision 1.2  94/03/07  16:59:07  16:59:07  claustre (Laurent Claustre)
 * Modified DevReadData argout type to D_VAR_ULONGARR, added the init_module method (mainly opens the ethernet device driver connection)
 * 
 * Revision 1.1  94/02/21  14:29:55  14:29:55  claustre (Laurent Claustre)
 * Initial revision
 *
 * Copyright (c) 1994 by European Synchrotron Radiation Facility, 
 *                     Grenoble, France
 *********************************************************************/

#ifndef _MCAAIMP_H
#define _MCAAIMP_H
#include <crackers.h>

typedef struct _McaAIMClassPart
{
  int	nada;
} McaAIMClassPart;

typedef struct _McaAIMPart
{
  DevShort aim_address;
  DevString aim_file;        /* CAM file name */
  HMEM hDSC;                 /* handle to a DSC */
  unsigned char	*acq_mem;    /* memory for acquisition */
  DevLong	channel_num;     /* Number of channel to be used */
  DevUShort	curr_mem_gr;     /* Current memory group */
  DevShort	adc_num;         /* ADC number (1 or 2) */
  DevShort	curr_adc;        /* current ADC */
  DevShort	mode;            /* Acquisition mode of the mca device,
				                0 - real, 1 - life time, 2 - counts*/
  DevDouble	live_time;       /* Live time value in second */
  DevDouble	real_time;       /* Real time value in second */
  DevDouble	pres_live_time;  /* preset live time value in second */
  DevDouble	pres_real_time;  /* preset real time value in second */
  DevULong	total_counts;
  DevLong	first_channel;
  DevLong	last_channel;
  DevLong	ch_per_group;    /* number of channels per memory group */
  DevShort	nb_groups;       /* number of groups to divide the memory */
  DevFloat  horz_scale;      /* used by the machine only */
  DevShort  zb_offset;       /* used by the machine only */
  DevShort  icb_flag;        /* icb present (1) or not (0) */
  DevShort  icb_address;     /* icb_address */
  DevShort conf_nb_groups;   /* configured in the VDM groups */
} McaAIMPart;

typedef struct _McaAIMClassRec
{
  DevServerClassPart  devserver_class;		
  McaAIMClassPart     mcaAIM_class;
}  McaAIMClassRec;

extern McaAIMClassRec mcaAIMClassRec;

typedef struct _McaAIMRec
{
  DevServerPart devserver;				
  McaAIMPart 	mcaAIM;
}  McaAIMRec;


/* structure used to make the MCA/DS corresponding table */
typedef struct _nmc_ds_err
{
  long	nmc_err;
  long	ds_err;
} nmc_ds_err;

#define MCAAIM_TIMEOUT  4000	/* timeout value for read(2) and write(2)
				   in microsecond */
#define TIME_COEF       100    /* convert from centiseconds to seconds */
/* DLPI part */
#define AREA_SIZE       5000 /* bytes; big enough */
#define ULONG_AREA_SIZE  (AREA_SIZE / sizeof(unsigned long)) 
#define GOT_CTRL        1    /* message has only a control part */
#define GOT_DATA        2    /* message has only a data part */
#define GOT_BOTH        3    /* message has control and data parts */

/* define counting mode */
#define TOT_COUNTS 0
#define LIVE_TIME 1
#define REAL_TIME 2
#define ANY_MODE 3

#endif
