/* static char RcsId[] = "$Header: startup.c,v 1.2 2000/07/26 11:30:33 beteva Rel $"; */
/*********************************************************************
 *
 * File:	startup.c
 * Project:	Multichannel Analyser device server
 * Description:	Startup procedure for McaAIMClass. The
 *		startup procedure is the first procedure called
 *		from main() when the device server starts up.
 *		All toplevel devices to be created for the device 
 *		server should be done in startup(). The startup 
 *		should make use of the database to determine which 
 *		devices it should create. Initialisation of devices
 *		is normally done from startup().
 * Original:	April 1998
 * $Log:	startup.c,v $
 * Revision 1.2  2000/07/26  11:30:33  11:30:33  beteva (A.Beteva)
 * added giDebugLevel initialisation at startup
 * 
 * European Synchrotron Radiation Facility, Grenoble, France
 *********************************************************************/

#include <Admin.h>
#include <API.h>
#include <DevServer.h>
#include <DevErrors.h>
#include <DevServerP.h>
#include <McaAIM.h>
#include <McaAIMP.h>

/* Here is the place to define what to put
 *  into the main window's backdrop */
static char* info[]= {
  {"MCA Canberra AIM 556(A)"},
  {"July 2000"},
};

/***************************/
/* McaAIM startup */
/***************************/
long startup (char *svr_name, long *error)
{
  McaAIM *ds_list;
  unsigned int n_dev, u_i;
  long n_created;
  char msg[512];
  char **dev_list; /* pointer to list of devices returned by database  */

  /* init the giDebugLevel to use dprintf1, dprintf2 ... */
  giDebugLevel = GetDebugLevel();

  if (db_getdevlist (svr_name, &dev_list, &n_dev, error)) {
	  sprintf(msg, "startup: db_getdevlist() failed, error %d",*error);
	  dprintf1(msg);
      return(-1);
  } else {
      sprintf(msg,"following devices found in static database");
      dprintf(msg);
      for (u_i=0; u_i<n_dev; u_i++) {
		  sprintf(msg,"%s",dev_list[u_i]);
		  dprintf(msg);
	  }
  }
  if ((ds_list = (McaAIM *)malloc(n_dev * sizeof(McaAIM))) == 0) {
	  sprintf(msg, "startup: Cannot allocate memory for ds_list[]");
      dprintf1(msg);
      return(-1);
    }

  /* create, initialise and export all devices served by this server */
  for (u_i=0, n_created = 0; u_i<n_dev; u_i++, n_created++) {
      /* create */
      if (ds__create(dev_list[u_i], mcaAIMClass, &(ds_list[u_i]), error) != 0) {
		  dprintf1("create failed: %s\n", dev_error_str(*error));
		  n_created--;
	  }
      /* initialise */
      if (ds__method_finder(ds_list[u_i], DevMethodInitialise)
		  (ds_list[u_i], error) != 0) {
	  dprintf1("initialise failed: %s\n", dev_error_str(*error));
	  n_created--;
	}
	  /* export*/
      if (dev_export(dev_list[u_i], ds_list[u_i], error) != 0) {
		  dprintf1("export failed: %s\n", dev_error_str(*error));
		  n_created--;
	  }
  }

  if (n_created == 0)
    return (-1);
  else {
      sprintf(msg, "left startup with %d device(s)", n_created);
      dprintf(msg);
	  /* Here is the place to assign what to put
	  into the main window's backdrop. */
	  gMWndTxtDisplay.lines= 2;
	  gMWndTxtDisplay.text= info;
      return(0);
  }
}
