/*static char RcsId[] = "$Header: $";*/
/*********************************************************************
 * File:	McaAIMP.h
 * Project:	Multichannel Analyser device server
 * Description:	This is the Multichannel Analyser device server for the
 *		Acquisition Interface Module of Canberra (AIM). The module is
 *		directly connected to the ethernet (Data Communication Level). 
 * Author(s): A.Beteva
 * Original: April 1998	
 * $Log:$
 * European Synchrotron Radiation Facility, Grenoble, France
 *********************************************************************/

#ifndef _MCAAIMP_H
#define _MCAAIMP_H
#include <crackers.h>

typedef struct _McaAIMClassPart
{
  int	nada;
} McaAIMClassPart;

typedef struct _McaAIMPart
{
  DevShort aim_address;
  DevString aim_file;        /* CAM file name */
  HMEM hDSC;                 /* handle to a DSC */
  unsigned char	*acq_mem;    /* memory for acquisition */
  DevLong channel_num;       /* Number of channel to be used */
  DevUShort curr_mem_gr;     /* Current memory group */
  DevShort adc_num;          /* ADC number (1 or 2) */
  DevShort curr_adc;         /* current ADC */
  DevShort mode;             /* Acquisition mode of the mca device,
				0 - counts, 1 - life time, 2 - real, 3 - any*/
  DevDouble live_time;       /* Live time value in second */
  DevDouble real_time;       /* Real time value in second */
  DevDouble pres_live_time;  /* preset live time value in second */
  DevDouble pres_real_time;  /* preset real time value in second */
  DevULong total_counts;
  DevLong first_channel;
  DevLong last_channel;
  DevLong ch_per_group;      /* number of channels per memory group */
  DevShort nb_groups;        /* number of groups to divide the memory */
  DevFloat horz_scale;       /* used by the machine only */
  DevShort zb_offset;        /* used by the machine only */
  DevShort icb_flag;         /* icb present (1) or not (0) */
  DevShort icb_address;      /* icb_address */
  DevShort conf_nb_groups;   /* configured in the VDM groups */
} McaAIMPart;

typedef struct _McaAIMClassRec
{
  DevServerClassPart  devserver_class;		
  McaAIMClassPart     mcaAIM_class;
}  McaAIMClassRec;

extern McaAIMClassRec mcaAIMClassRec;

typedef struct _McaAIMRec
{
  DevServerPart devserver;				
  McaAIMPart 	mcaAIM;
}  McaAIMRec;

/* define counting mode */
#define TOT_COUNTS 0
#define LIVE_TIME 1
#define REAL_TIME 2
#define ANY_MODE 3

#endif
