/* Source Code Example2 - GENIE-PC Programming Library */


/* Windows includes */

#include <windows.h>
#include "crackers.h"

/* C run time library includes */

#include <tchar.h>
#include <stdio.h>


/* GENIE-PC User Library includes */

#include <citypes.h>

#include <spasst.h>
#include <sad.h>
#include <get_put.h>
#include <driver.h>
#include <ci_files.h>
#include <campdef.h>
#include <cam_n.h>


/* GENIE-PC Utility Library includes */

#include <utility.h>


/* User's includes */


/* Application source code */


main(int argc, char *argv[], char *envp[])
{
       HMEM         hDSC;
       INT          iRC;
       SHORT        sRC, sRet, sDum1;
       ULONG        ulRC;
       USHORT       usDum2;


/* Set Environment from the registry */

       vG2KEnv(); 


/* Establish a connection to the local VDM */

       iRC = iUtlCreateFileDSC2(&hDSC, 0, 0);
       if (iRC) {
            printf("Error creating a VDM connection: %u", iRC);
            return(1);
       }


/* Open the detector DET01 datasource */

       sRC = SadOpenDataSource(hDSC, "DET01",
                               CIF_Detector,
                               ACC_Exclusive|ACC_SysWrite|ACC_ReadWrite,
                               TRUE, "");
       if (sRC == CSI_Verify) {
            printf("Error failed to verify DET01 parameter settings.");
            return(1);
       }
       else if (sRC) {
            sRet = SadGetStatus(hDSC, &ulRC, &sDum1, &usDum2);
            printf("Error opening DET01: %lx", ulRC);
            return(1);
       }


/* Set acquisition preset to 30 seconds livetime. */

       {
           Preset_T stPSet;
           FillMemory (&stPSet, sizeof(Preset_T), '\0');
           stPSet.flPsetMode = CAM_M_PMOD_LIVE;
           stPSet.unTime.dPsetTime = 30.0;
           sRC = SadPutStruct(hDSC, WST_SetPreset, 1, 1, &stPSet, sizeof(Preset_T));
           if (sRC) {
                printf("Error failed to set livetime preset.");
                return(1);
           }
       }


/* Clear the acquisition memory. */

       sRC = SadControlDSC(hDSC, MCA, CTL_ClearData);
       if (sRC) {
            printf("Error failed to clear acquisition memory.");
            return(1);
       }


/* Start the acquisition. */

       sRC = SadControlDSC(hDSC, MCA, CTL_StartAcq);
       if (sRC) {
            printf("Error failed to start acquisition.");
            return(1);
       }


/* Wait for acquisition to complete. */

       {
           DSQuery_T stQData;
           double dLive;
           sRC = SadQueryDataSource(hDSC, DSQ_Status, &stQData);
           if (sRC) {
                printf("Error hardware query failed.");
                return(1);
           }
           while (stQData.stDS.fsStatus & DSS_Busy) // while acquiring
           {
               Sleep(1000);  // Sleep for 1 second
               sRC = SadGetParam(hDSC, CAM_X_ELIVE, 0, 0, &dLive, sizeof(double));
               if (!sRC) {
                    printf("\rLivetime seconds: %f", dLive);
               }
               sRC = SadQueryDataSource(hDSC, DSQ_Status, &stQData);
               if (sRC) {
                    printf("Error hardware query failed.");
                    return(1);
               }
           }
       }

/* Cleanup and exit */

       sRC = SadCloseDataSource(hDSC);
       sRC = SadDeleteDSC(hDSC);
       return(0);
}

/**** End Of File ****/

