Attribute VB_Name = "MUtility"
'-------------------------------------------------------
'MUtility - Utility.bas
'
'Purpose:
'   Utility Routines
'
'Revision History:
'   May-27-1999      MAS     Modified from old release
'-------------------------------------------------------
Option Explicit

Public Const sEmpty = ""

Private aPower2(0 To 31) As Long

'-------------------------------------------------------
'FixedStr - returns a string of Fixed length
'
'Arguments :
'   strText     a string
'
'Returns :
'   The strText but padded with spaces to match width
'-------------------------------------------------------
Public Function FixedStr(strText As String, sLen As Integer) As String
    Dim strTemp As String
    Dim sTextLen As Integer
    
    sTextLen = Len(strText)
    If (sTextLen < sLen) Then
        strTemp = strText & Space(sLen - sTextLen)
    ElseIf (sTextLen > sLen) Then
        strTemp = Left(strText, sLen)
    Else
        strTemp = strText
    End If
    
    FixedStr = strTemp
End Function

'-------------------------------------------------------
'StrLen - returns the position of the first ASCII zero
'
'Arguments :
'   strText     a C style string buffer (zero terminated)
'
'Returns :
'   The position of the last char before the null terminator
'-------------------------------------------------------
Public Function StrLen(strText As String) As Integer
    Dim sLen As Integer
    
    sLen = InStr(strText, Chr$(0))
    If (sLen = 0 Or sLen = Null) Then
        StrLen = 0
    Else
        StrLen = sLen - 1
    End If
End Function
'-------------------------------------------------------
'SzFromStr - Returns a string extracted from a C style string
'            Useful for fixed length strings which are padded
'            with garbage and therefore do not concatenate well
'
'Arguments :
'   strText     a C style string buffer (zero terminated)
'
'Returns :
'   String
'-------------------------------------------------------
Public Function SzFromStr(strText As String) As String
    Dim sLen As Integer
    sLen = StrLen(strText)
    If (sLen = 0) Then
        If (Left(strText, 1) = Chr$(0)) Then
            SzFromStr = sEmpty
        Else
            SzFromStr = strText
        End If
    Else
        SzFromStr = Left(strText, sLen)
    End If
End Function
'-------------------------------------------------------
'Power2 - Returns a given power of 2
'
'Arguments :
'   i   Power to raise
'
'Returns :
'   long
'-------------------------------------------------------
Public Function Power2(ByVal i As Integer) As Long
    If aPower2(0) = 0 Then
        aPower2(0) = &H1&
        aPower2(1) = &H2&
        aPower2(2) = &H4&
        aPower2(3) = &H8&
        aPower2(4) = &H10&
        aPower2(5) = &H20&
        aPower2(6) = &H40&
        aPower2(7) = &H80&
        aPower2(8) = &H100&
        aPower2(9) = &H200&
        aPower2(10) = &H400&
        aPower2(11) = &H800&
        aPower2(12) = &H1000&
        aPower2(13) = &H2000&
        aPower2(14) = &H4000&
        aPower2(15) = &H8000&
        aPower2(16) = &H10000
        aPower2(17) = &H20000
        aPower2(18) = &H40000
        aPower2(19) = &H80000
        aPower2(20) = &H100000
        aPower2(21) = &H200000
        aPower2(22) = &H400000
        aPower2(23) = &H800000
        aPower2(24) = &H1000000
        aPower2(25) = &H2000000
        aPower2(26) = &H4000000
        aPower2(27) = &H8000000
        aPower2(28) = &H10000000
        aPower2(29) = &H20000000
        aPower2(30) = &H40000000
        aPower2(31) = &H80000000
    End If
    Power2 = aPower2(i)
End Function
'-------------------------------------------------------
'LShiftWord - Left Shift from MCkinney, modified to output a DWORD
'
'Arguments :
'   w       Word to shift
'   c       bits to shift
'
'Returns :
'   Long
'-------------------------------------------------------
Public Function LShiftWord(ByVal w As Integer, ByVal c As Integer) As Long
    Dim dw As Long
    dw = w * Power2(c)
    If (dw And &H80000000) Then
        LShiftWord = CInt(dw And &H7FFFFFFF) Or &H80000000
    Else
        LShiftWord = dw And &HFFFFFFFF
    End If
End Function
'-------------------------------------------------------
'MakeDWord - Make a DWORD (be careful, VB doesnt have unsigned data
'            types)
'
'Arguments :
'   l       LOWORD
'   h       HIWORD
'
'Returns :
'   Long
'-------------------------------------------------------
Public Function MakeDWord(ByVal l As Integer, ByVal h As Integer) As Long
    Dim dw As Long
    dw = l + LShiftWord(h, 16)
    MakeDWord = dw
End Function
'-------------------------------------------------------
'Reverse Find - find a string within in a string starting at the end
'
'Arguments :
'   Str1    String to search
'   Str2    String to search for
'
'Returns :
'   Position of occurence, 0 if not found
'-------------------------------------------------------
Public Function ReverseFind(Str1 As String, Str2 As String) As Integer
    Dim Pos As Integer
    Dim LastPos As Integer
    
    LastPos = 0
    If (Str1 <> sEmpty) And (Str2 <> sEmpty) Then
        Pos = 1
        Do
            Pos = InStr(Pos, Str1, Str2, vbTextCompare)
            If (Pos > 0) Then
                LastPos = Pos
                Pos = Pos + 1
            End If
        Loop While (Pos <> 0)
    End If
    
    ReverseFind = LastPos
End Function



