Attribute VB_Name = "MShell"
'-------------------------------------------------------
'MShell - Shell.bas
'
'Purpose:
'   Routines to spawn and kill other applications
'
'Revision History:
'   May-27-1999      MAS     Modified from Peter Van Dyck original
'-------------------------------------------------------
Option Explicit
Option Compare Text

Global Const NORMAL_PRIORITY_CLASS      As Long = &H20&
Global Const INFINITE                   As Long = -1&

Global Const STATUS_WAIT_0              As Long = &H0
Global Const STATUS_ABANDONED_WAIT_0    As Long = &H80
Global Const STATUS_USER_APC            As Long = &HC0
Global Const STATUS_TIMEOUT             As Long = &H102
Global Const STATUS_PENDING             As Long = &H103

Global Const WAIT_FAILED                As Long = &HFFFFFFFF
Global Const WAIT_OBJECT_0              As Long = STATUS_WAIT_0
Global Const WAIT_TIMEOUT               As Long = STATUS_TIMEOUT

Global Const WAIT_ABANDONED             As Long = STATUS_ABANDONED_WAIT_0
Global Const WAIT_ABANDONED_0           As Long = STATUS_ABANDONED_WAIT_0

Global Const WAIT_IO_COMPLETION         As Long = STATUS_USER_APC
Global Const STILL_ACTIVE               As Long = STATUS_PENDING

Public Type STARTUPINFO
    cb              As Long
    lpReserved      As Long
    lpDesktop       As Long
    lpTitle         As Long
    dwX             As Long
    dwY             As Long
    dwXSize         As Long
    dwYSize         As Long
    dwXCountChars   As Long
    dwYCountChars   As Long
    dwFillAttribute As Long
    dwFlags         As Long
    wShowWindow     As Integer
    cbReserved2     As Integer
    lpReserved2     As Long
    hStdInput       As Long
    hStdOutput      As Long
    hStdError       As Long
End Type

Public Type PROCESS_INFORMATION
    hProcess    As Long
    hThread     As Long
    dwProcessID As Long
    dwThreadID  As Long
End Type

Declare Function WaitForSingleObject Lib "kernel32" (ByVal hProcess As Long, ByVal dwMilliseconds As Long) As Long
Declare Function WaitForInputIdle Lib "user32" (ByVal hProcess As Long, ByVal dwMilliseconds As Long) As Long
Declare Function CreateProcessA Lib "kernel32" (ByVal lpApplicationName As Long, ByVal lpCommandLine As String, ByVal lpProcessAttributes As Long, ByVal lpThreadAttributes As Long, ByVal bInheritHandles As Long, ByVal dwCreationFlags As Long, ByVal lpEnvironment As Long, ByVal lpCurrentDirectory As Long, lpStartupInfo As STARTUPINFO, lpProcessInformation As PROCESS_INFORMATION) As Long
Declare Function GetExitCodeProcess Lib "kernel32" (ByVal hProcess As Long, lpExitCode As Long) As Long
Declare Function CloseHandle Lib "kernel32" (ByVal hObject As Long) As Long
Declare Function TerminateProcess Lib "kernel32" (ByVal hProcess As Long, ByVal uExitCode As Long) As Long
'-------------------------------------------------------
'AsyncShell - Start a process and dont return until its idle.
'
'Arguments :
'   CommandLine     String specifying command line
'   Timeout         Time to wait for completion (0 = INFINITE)
'   Hide            if True will hide the spawned app
'   WaitLoop        If true, do the wait during a DoEvents loop
'
'Returns :
'   The process handle, NULL if error.
'-------------------------------------------------------
Public Function AsyncShell(CommandLine As String, _
                            Optional Timeout As Long = 0, _
                            Optional Hide As Boolean = False, _
                            Optional WaitLoop As Boolean = True) As Long
    Dim hProcess As Long
    Dim lRet As Long
    Dim ret As Long
    Dim nMilliseconds As Long
    Dim nMillisecwait As Long
    Dim nMillisecadd As Long
    Dim nMillisectotal As Long

    If WaitLoop Then                                ' use polling wait loop
        nMillisectotal = 0                          ' reset total wait time
        nMillisecwait = 200                         ' check every 200 milliseconds
        If Timeout > 0 Then
            nMilliseconds = Timeout                 ' real time out and increment
            nMillisecadd = nMillisecwait
        Else
            nMilliseconds = 100                     ' dummy time out and increment
            nMillisecadd = 0
        End If
    Else                                            ' wait until time out or infinite
        If Timeout > 0 Then
            nMilliseconds = Timeout                 ' specified time out
        Else
            nMilliseconds = INFINITE                ' infinite time out
        End If
    End If

    hProcess = StartProcess(CommandLine, Hide)
    If hProcess <> 0 Then
        If WaitLoop Then                                ' use polling wait loop
            Do While nMillisectotal < nMilliseconds
                'Wait for the shelled application to finish setting up its UI:
                ret = WaitForInputIdle(hProcess, nMillisecwait)
                If ret <> WAIT_TIMEOUT Then
                    nMillisectotal = nMilliseconds
                End If
                nMillisectotal = nMillisectotal + nMillisecadd
                DoEvents
            Loop
        Else                                            ' wait until time out or infinite
            'Wait for the shelled application to finish setting up its UI:
            ret = WaitForInputIdle(hProcess, nMilliseconds)
        End If
    End If
    AsyncShell = hProcess
End Function
'-------------------------------------------------------
'SyncShell - Runs a shell sync and returns the exit code of the process
'
'Arguments :
'   CommandLine     String specifying command line
'   Timeout         Time to wait for completion (0 = INFINITE)
'   Hide            if True will hide the spawned app
'   WaitLoop        If true, do the wait during a DoEvents loop
'
'Returns :
'   The Process' Exit code or -1 if process times out or an error occurs
'-------------------------------------------------------
Public Function SyncShell(CommandLine As String, _
                            Optional Timeout As Long = 0, _
                            Optional Hide As Boolean = False, _
                            Optional WaitLoop As Boolean = True) As Long
    Dim hProcess As Long
    Dim lRet As Long

    Const STARTF_USESHOWWINDOW As Long = &H1
    Const SW_HIDE As Long = 0
    
    Dim ret As Long
    Dim nMilliseconds As Long
    Dim nMillisecwait As Long
    Dim nMillisecadd As Long
    Dim nMillisectotal As Long

    If WaitLoop Then                                ' use polling wait loop
        nMillisectotal = 0                          ' reset total wait time
        nMillisecwait = 200                         ' check every 200 milliseconds
        If Timeout > 0 Then
            nMilliseconds = Timeout                 ' real time out and increment
            nMillisecadd = nMillisecwait
        Else
            nMilliseconds = 100                     ' dummy time out and increment
            nMillisecadd = 0
        End If
    Else                                            ' wait until time out or infinite
        If Timeout > 0 Then
            nMilliseconds = Timeout                 ' specified time out
        Else
            nMilliseconds = INFINITE                ' infinite time out
        End If
    End If

    lRet = -1   'initialize as Error
    
    hProcess = StartProcess(CommandLine, Hide)
    If hProcess <> 0 Then
        If WaitLoop Then                                ' use polling wait loop
            Do While nMillisectotal < nMilliseconds
                'Wait for the shelled application to terminate:
                ret = WaitForSingleObject(hProcess, nMillisecwait)
                If ret <> WAIT_TIMEOUT Then
                    nMillisectotal = nMilliseconds 'exit loop
                End If
                nMillisectotal = nMillisectotal + nMillisecadd
                DoEvents
            Loop
        Else                                            ' wait until time out or infinite
            'Wait for the shelled application to terminate:
            ret = WaitForSingleObject(hProcess, nMilliseconds)
        End If
        
        'Get error code
        If (ret = WAIT_OBJECT_0) Then
            GetExitCodeProcess hProcess, lRet
        End If
        CloseHandle hProcess
    End If
            
    SyncShell = lRet
End Function
'-------------------------------------------------------
'StartProcess - Start a Process and return immediately
'
'Arguments :
'   CommandLine     String specifying commandline
'   Hide            If True will hide the spawned application
'
'Returns :
'   The process handle (NULL on error)
'-------------------------------------------------------
Public Function StartProcess(CommandLine As String, _
                               Optional Hide As Boolean = False) As Long
    Const STARTF_USESHOWWINDOW As Long = &H1
    Const SW_HIDE As Long = 0
    Dim ret As Long
    
    Dim proc As PROCESS_INFORMATION
    Dim Start As STARTUPINFO

    'Initialize the STARTUPINFO structure:
    Start.cb = Len(Start)
    If Hide Then
        Start.dwFlags = STARTF_USESHOWWINDOW
        Start.wShowWindow = SW_HIDE
    End If
    'Start the shelled application:
    ret = CreateProcessA(0&, CommandLine, 0&, 0&, 1&, _
                         NORMAL_PRIORITY_CLASS, 0&, 0&, Start, proc)
    If (ret <> 0) Then
        StartProcess = proc.hProcess
    Else
        StartProcess = 0
    End If
End Function
'-------------------------------------------------------
'KillProcess - Kill a process unconditionally
'
'Arguments :
'   hProcess    The handle from StartProcess or AsycnShell.
'               DO NOT PASS IN NULL!
'Returns :
'   True on success, False on Error
'-------------------------------------------------------
Public Function KillProcess(hProcess As Long) As Boolean
    Dim l As Long
    
    'Use the ultimate process killing routine
    l = TerminateProcess(hProcess, 0)
    CloseHandle hProcess
        
    'return True if success
    If (l <> 0) Then
        KillProcess = True
    Else
        KillProcess = False
    End If
End Function


