VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{D57C3B91-D2F9-11D1-84A6-00A0248C8E7B}#1.0#0"; "SeqAnlyz.dll"
Begin VB.Form FSequenceEditor 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Edit Analysis Sequence"
   ClientHeight    =   4005
   ClientLeft      =   45
   ClientTop       =   285
   ClientWidth     =   8190
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4005
   ScaleWidth      =   8190
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin MSComDlg.CommonDialog OpenDialog 
      Left            =   240
      Top             =   3480
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin CanberraSequenceAnalyzerLibCtl.AnalysisEditor AnalysisEdit 
      Height          =   3360
      Left            =   0
      OleObjectBlob   =   "SequenceEditor.frx":0000
      TabIndex        =   3
      Top             =   0
      Width           =   8175
   End
   Begin VB.CommandButton cmdLoad 
      Caption         =   "Load..."
      Height          =   375
      Left            =   4958
      TabIndex        =   2
      Top             =   3480
      Width           =   1335
   End
   Begin VB.CommandButton cndCancel 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   3398
      TabIndex        =   1
      Top             =   3480
      Width           =   1335
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "OK"
      Height          =   375
      Left            =   1838
      TabIndex        =   0
      Top             =   3480
      Width           =   1335
   End
End
Attribute VB_Name = "FSequenceEditor"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'-------------------------------------------------------
'FSequenceEditor
'
'Purpose:
'   Dialog used to edit a sequence on a datasource
'
'Public Members:
'   None
'
'Revision History:
'   May-24-1999      MAS     Created
'-------------------------------------------------------
Option Explicit
Private m_oDatasource As Object
Private m_msgClick As VbMsgBoxResult
'----------------------------------------------------------
'CreateForm
'
'Arguments:
'   I   : Parent (parent form)
'   I/O : Datasource (datasource to edit)
'
'Returns:
'   vbMsgBoxResult  vbCancel or vbOK
'
'Purpose:
'   Start the Form and run to completion, return to the caller
'   success of operation
'----------------------------------------------------------
Public Function CreateForm(Parent As Form, Datasource As Object) As Integer
    On Error GoTo ErrHdlr
    m_msgClick = vbCancel
    
    Set m_oDatasource = Datasource
    AnalysisEdit.SetSequence Datasource
    
    'Show myself and then return the users response
    Me.Show 1, Parent
    CreateForm = m_msgClick
    Exit Function
ErrHdlr:
    ProcessError
    CreateForm = m_msgClick
End Function

'Load an analysis sequence
Private Sub cmdLoad_Click()
    On Error GoTo ErrHdlr
    Dim strCurrentDir As String
    Dim strAsfFiles As String
    Dim Datasource As CanberraDataAccessLib.DataAccess
        
    'Change current drive
    strCurrentDir = CurDir
    strAsfFiles = GetEnvironmentVar("ASEQFILES")
    ChDrive Left(strAsfFiles, 1)
    ChDir strAsfFiles
    
    'Use the MS common dialog to get a filename
    OpenDialog.Filter = "Sequence Files|*.ASF"
    OpenDialog.DialogTitle = "Open Sequence File"
    OpenDialog.DefaultExt = "*.ASF"
    OpenDialog.FileName = "*.ASF"
    OpenDialog.CancelError = True
    OpenDialog.Flags = cdlOFNHideReadOnly
    OpenDialog.ShowOpen
    
    'Open the file
    Set Datasource = New CanberraDataAccessLib.DataAccess
    Datasource.Open OpenDialog.FileName
    AnalysisEdit.SetSequence Datasource
    Datasource.Close dNoUpdate
    Set Datasource = Nothing
    
    'Restore current Dir
    ChDrive Left(strCurrentDir, 1)
    ChDir strCurrentDir
    Exit Sub
ErrHdlr:
    If (Err.Number = cdlCancel) Then
        'Restore current Dir
        ChDrive Left(strCurrentDir, 1)
        ChDir strCurrentDir
        Exit Sub
    End If
    ProcessError
End Sub

'ok
Private Sub cmdOK_Click()
    On Error GoTo ErrHdlr
    AnalysisEdit.GetSequenceChanges m_oDatasource
    m_msgClick = vbOK
    Me.Hide
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'cancel
Private Sub cndCancel_Click()
    m_msgClick = vbCancel
    Me.Hide
    Exit Sub
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Set m_oDatasource = Nothing
End Sub
