VERSION 5.00
Begin VB.Form FSampleEdit 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Sample Information"
   ClientHeight    =   3840
   ClientLeft      =   45
   ClientTop       =   285
   ClientWidth     =   5520
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3840
   ScaleWidth      =   5520
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin VB.TextBox txtAcqSTime 
      BackColor       =   &H80000004&
      Enabled         =   0   'False
      Height          =   285
      Left            =   3360
      TabIndex        =   19
      Top             =   1800
      Width           =   2055
   End
   Begin VB.TextBox txtUnits 
      Height          =   285
      Left            =   1920
      TabIndex        =   17
      Top             =   2760
      Width           =   1215
   End
   Begin VB.CommandButton cmdCancel 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   3113
      TabIndex        =   16
      Top             =   3240
      Width           =   1335
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "OK"
      Height          =   375
      Left            =   1073
      TabIndex        =   15
      Top             =   3240
      Width           =   1335
   End
   Begin VB.TextBox txtUncertainty 
      Height          =   285
      Left            =   1920
      TabIndex        =   9
      Top             =   2400
      Width           =   1215
   End
   Begin VB.TextBox txtQuantity 
      Height          =   285
      Left            =   1920
      TabIndex        =   8
      Top             =   2040
      Width           =   1215
   End
   Begin VB.TextBox txtType 
      Height          =   285
      Left            =   1920
      TabIndex        =   7
      Top             =   1680
      Width           =   1215
   End
   Begin VB.TextBox txtSampID 
      Height          =   285
      Left            =   1920
      TabIndex        =   3
      Top             =   1320
      Width           =   1215
   End
   Begin VB.TextBox txtDesc 
      Height          =   285
      Left            =   1920
      TabIndex        =   2
      Top             =   960
      Width           =   3495
   End
   Begin VB.TextBox txtName 
      Height          =   285
      Left            =   1920
      TabIndex        =   1
      Top             =   600
      Width           =   3495
   End
   Begin VB.TextBox txtTitle 
      Height          =   285
      Left            =   1920
      TabIndex        =   0
      Top             =   240
      Width           =   3495
   End
   Begin VB.Label Label9 
      Caption         =   "Acquisition Start Time"
      Height          =   255
      Left            =   3600
      TabIndex        =   18
      Top             =   1560
      Width           =   1575
   End
   Begin VB.Label Label8 
      Caption         =   "Units"
      Height          =   255
      Left            =   120
      TabIndex        =   14
      Top             =   2760
      Width           =   1695
   End
   Begin VB.Label Label7 
      Caption         =   "Uncertainty"
      Height          =   255
      Left            =   120
      TabIndex        =   13
      Top             =   2400
      Width           =   1695
   End
   Begin VB.Label Label6 
      Caption         =   "Quantity"
      Height          =   255
      Left            =   120
      TabIndex        =   12
      Top             =   2040
      Width           =   1575
   End
   Begin VB.Label Label5 
      Caption         =   "Type"
      Height          =   255
      Left            =   120
      TabIndex        =   11
      Top             =   1680
      Width           =   1575
   End
   Begin VB.Label Label4 
      Caption         =   "Sample ID"
      Height          =   255
      Left            =   120
      TabIndex        =   10
      Top             =   1320
      Width           =   1455
   End
   Begin VB.Label Label3 
      Caption         =   "Sample Description"
      Height          =   255
      Left            =   120
      TabIndex        =   6
      Top             =   960
      Width           =   1695
   End
   Begin VB.Label Label2 
      Caption         =   "Collector Name"
      Height          =   255
      Left            =   120
      TabIndex        =   5
      Top             =   600
      Width           =   1815
   End
   Begin VB.Label Label1 
      Caption         =   "Sample Title"
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   240
      Width           =   1695
   End
End
Attribute VB_Name = "FSampleEdit"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'-------------------------------------------------------
'FSampleEdit
'
'Purpose:
'   Dialog used to view/edit the sample information
'
'Public Members:
'   None
'
'Revision History:
'   May-24-1999      MAS     Created
'-------------------------------------------------------
Option Explicit
Private m_oDatasource As Object
Private m_msgClick As VbMsgBoxResult

'----------------------------------------------------------
'CreateForm
'
'Arguments:
'   I   : Parent (parent form)
'   I   : Datasource to edit
'
'Returns:
'   vbMsgBoxResult  vbOK or vbCancel
'
'Purpose:
'   Start the Form and run to completion, return to the caller
'   success of operation
'----------------------------------------------------------
Public Function CreateForm(Parent As Form, Datasource As Object) As Integer
    Dim i As Integer
    
    Set m_oDatasource = Datasource
    m_msgClick = vbCancel
    If (SetDatasource) Then
        'Show myself and then return the users response
        Me.Show 1, Parent
    End If
    CreateForm = m_msgClick
End Function

Private Function SetDatasource() As Boolean
    On Error GoTo ErrHdlr
    
    txtTitle = m_oDatasource.Param(CAM_T_STITLE)
    txtName = m_oDatasource.Param(CAM_T_SCOLLNAME)
    txtDesc = m_oDatasource.Param(CAM_T_SDESC1)
    txtSampID = m_oDatasource.Param(CAM_T_SIDENT)
    txtType = m_oDatasource.Param(CAM_T_STYPE)
    txtQuantity = m_oDatasource.Param(CAM_F_SQUANT)
    txtUncertainty = m_oDatasource.Param(CAM_F_SQUANTERR)
    txtUnits = m_oDatasource.Param(CAM_T_SUNITS)
    txtAcqSTime = m_oDatasource.Param(CAM_X_ASTIME)
    
    'Alternatively you could use ParamArray:
    'Dim Params(0 To 8) As ParamCodes
    'Dim Vals As Variant
    'Params(0) = CAM_T_STITLE
    'Params(1) = CAM_T_SCOLLNAME
    'Params(2) = CAM_T_SDESC1
    'Params(3) = CAM_T_SIDENT
    'Params(4) = CAM_T_STYPE
    'Params(5) = CAM_F_SQUANT
    'Params(6) = CAM_F_SQUANTERR
    'Params(7) = CAM_T_SUNITS
    'Params(8) = CAM_X_ASTIME
    'Vals = m_oDatasource.ParamArray(Params)
    'txtTitle = Vals(0)
    'txtName = Vals(1)
    'txtDesc = Vals(2)
    'txtSampID = Vals(3)
    'txtType = Vals(4)
    'txtQuantity = Vals(5)
    'txtUncertainty = Vals(6)
    'txtUnits = Vals(7)
    'txtAcqSTime = Vals(8)
    SetDatasource = True
    Exit Function
ErrHdlr:
    If (Err.Number = &H8BE8805A) Then 'CAM__MISSING: A parameter is not on file
        Resume Next
    Else
        ProcessError
    End If
    SetDatasource = False
End Function

Private Sub cmdCancel_Click()
    m_msgClick = vbCancel
    Me.Hide
End Sub

Private Sub cmdOK_Click()
    On Error GoTo ErrHdlr
    'Its good practice convert the edits to the proper types
    '(i.e. convert CAM_F_SQUANT to a number...) and in the
    'case of these objects it is required
    m_oDatasource.Param(CAM_T_STITLE) = txtTitle.Text
    m_oDatasource.Param(CAM_T_SCOLLNAME) = txtName.Text
    m_oDatasource.Param(CAM_T_SDESC1) = txtDesc.Text
    m_oDatasource.Param(CAM_T_SIDENT) = txtSampID.Text
    m_oDatasource.Param(CAM_T_STYPE) = txtType.Text
    m_oDatasource.Param(CAM_F_SQUANT) = Val(txtQuantity.Text)
    m_oDatasource.Param(CAM_F_SQUANTERR) = Val(txtUncertainty.Text)
    m_oDatasource.Param(CAM_T_SUNITS) = txtUnits.Text
    m_msgClick = vbOK
    Me.Hide
    Exit Sub
ErrHdlr:
    ProcessError
End Sub
