VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form FPreferences 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Preferences"
   ClientHeight    =   4455
   ClientLeft      =   45
   ClientTop       =   285
   ClientWidth     =   8925
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4455
   ScaleWidth      =   8925
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin VB.CommandButton cmdDefault 
      Caption         =   "Defaults"
      Height          =   375
      Left            =   5917
      TabIndex        =   30
      Top             =   3960
      Width           =   1575
   End
   Begin VB.CommandButton cmdCancel 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   3674
      TabIndex        =   29
      Top             =   3960
      Width           =   1575
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "OK"
      Height          =   375
      Left            =   1432
      TabIndex        =   28
      Top             =   3960
      Width           =   1575
   End
   Begin MSComDlg.CommonDialog ColorDialog 
      Left            =   120
      Top             =   3840
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Frame Frame4 
      Caption         =   "Gridlines"
      Height          =   2175
      Left            =   6360
      TabIndex        =   10
      Top             =   120
      Width           =   2415
      Begin VB.CheckBox chkXAxisAsEnergy 
         Caption         =   "X Axis As Energy"
         Height          =   255
         Left            =   240
         TabIndex        =   34
         Top             =   960
         Width           =   1815
      End
      Begin VB.TextBox txtNumGridlines 
         Height          =   285
         Left            =   1680
         TabIndex        =   25
         Top             =   1680
         Width           =   615
      End
      Begin VB.CheckBox chkPlotBorders 
         Caption         =   "Show Plot Borders"
         Height          =   255
         Left            =   240
         TabIndex        =   23
         Top             =   240
         Width           =   1815
      End
      Begin VB.CheckBox chkYAxisGrid 
         Caption         =   "Show Y Axis Gridlines"
         Height          =   255
         Left            =   240
         TabIndex        =   22
         Top             =   1320
         Width           =   1935
      End
      Begin VB.CheckBox chkXAxisGrid 
         Caption         =   "Show X Axis Gridlines"
         Height          =   255
         Left            =   240
         TabIndex        =   21
         Top             =   600
         Width           =   1935
      End
      Begin VB.Label Label3 
         Caption         =   "Number of Gridlines:"
         Height          =   255
         Left            =   240
         TabIndex        =   24
         Top             =   1680
         Width           =   1455
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Information Display"
      Height          =   1335
      Left            =   2400
      TabIndex        =   5
      Top             =   2400
      Width           =   6375
      Begin VB.OptionButton radRoiCursor 
         Caption         =   "Roi/Cursor Info"
         Height          =   255
         Left            =   3360
         TabIndex        =   9
         Top             =   600
         Width           =   2775
      End
      Begin VB.OptionButton radSpectral 
         Caption         =   "Spectral Info"
         Height          =   255
         Left            =   3360
         TabIndex        =   8
         Top             =   960
         Width           =   2655
      End
      Begin VB.CheckBox chkStatusPages 
         Caption         =   "Show Status Pages"
         Height          =   195
         Left            =   3000
         TabIndex        =   7
         Top             =   240
         Width           =   1695
      End
      Begin VB.CheckBox chkStatusBar 
         Caption         =   "Show Status Bar"
         Height          =   255
         Left            =   120
         TabIndex        =   6
         Top             =   240
         Width           =   2055
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Plot Method"
      Height          =   2175
      Left            =   2400
      TabIndex        =   0
      Top             =   120
      Width           =   3855
      Begin VB.TextBox txtUpdateRate 
         Height          =   285
         Left            =   1920
         TabIndex        =   32
         Top             =   1680
         Width           =   375
      End
      Begin VB.ComboBox cmbPointSize 
         Height          =   315
         ItemData        =   "Preferences.frx":0000
         Left            =   2640
         List            =   "Preferences.frx":0013
         TabIndex        =   26
         Text            =   "Default"
         Top             =   240
         Width           =   1095
      End
      Begin VB.OptionButton radFill 
         Caption         =   "Fill Plot"
         Height          =   255
         Left            =   120
         TabIndex        =   4
         Top             =   1320
         Width           =   1935
      End
      Begin VB.OptionButton radEnvelope 
         Caption         =   "Envelope"
         Height          =   255
         Left            =   120
         TabIndex        =   3
         Top             =   960
         Width           =   1095
      End
      Begin VB.OptionButton radFull 
         Caption         =   "Full (Uncompressed)"
         Height          =   255
         Left            =   120
         TabIndex        =   2
         Top             =   600
         Width           =   1935
      End
      Begin VB.OptionButton radnormal 
         Caption         =   "Normal"
         Height          =   255
         Left            =   120
         TabIndex        =   1
         Top             =   240
         Width           =   1335
      End
      Begin VB.Label Label5 
         Caption         =   "secs"
         Height          =   255
         Left            =   2400
         TabIndex        =   33
         Top             =   1680
         Width           =   375
      End
      Begin VB.Label Label1 
         Caption         =   "Update Rate:"
         Height          =   255
         Left            =   840
         TabIndex        =   31
         Top             =   1680
         Width           =   1215
      End
      Begin VB.Label Label4 
         Caption         =   "Point Size:"
         Height          =   255
         Left            =   1680
         TabIndex        =   27
         Top             =   240
         Width           =   855
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "Colors"
      Height          =   3615
      Left            =   120
      TabIndex        =   19
      Top             =   120
      Width           =   2175
      Begin VB.Label Label2 
         Caption         =   "Double Click to Change:"
         Height          =   255
         Left            =   120
         TabIndex        =   20
         Top             =   240
         Width           =   1815
      End
      Begin VB.Label lblColors 
         Appearance      =   0  'Flat
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Nuclide Key Line"
         ForeColor       =   &H80000008&
         Height          =   255
         Index           =   7
         Left            =   120
         TabIndex        =   18
         Top             =   3120
         Width           =   1695
      End
      Begin VB.Label lblColors 
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Nuclide Lines"
         ForeColor       =   &H80000008&
         Height          =   255
         Index           =   6
         Left            =   120
         TabIndex        =   17
         Top             =   2760
         Width           =   1695
      End
      Begin VB.Label lblColors 
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Roi4"
         ForeColor       =   &H80000008&
         Height          =   255
         Index           =   5
         Left            =   120
         TabIndex        =   16
         Top             =   2400
         Width           =   1695
      End
      Begin VB.Label lblColors 
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Roi3"
         ForeColor       =   &H80000008&
         Height          =   255
         Index           =   4
         Left            =   120
         TabIndex        =   15
         Top             =   2040
         Width           =   1695
      End
      Begin VB.Label lblColors 
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Roi2"
         ForeColor       =   &H80000008&
         Height          =   255
         Index           =   3
         Left            =   120
         TabIndex        =   14
         Top             =   1680
         Width           =   1695
      End
      Begin VB.Label lblColors 
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Roi1"
         ForeColor       =   &H80000008&
         Height          =   255
         Index           =   2
         Left            =   120
         TabIndex        =   13
         Top             =   1320
         Width           =   1695
      End
      Begin VB.Label lblColors 
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Spectrum"
         ForeColor       =   &H80000008&
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   12
         Top             =   600
         Width           =   1695
      End
      Begin VB.Label lblColors 
         Appearance      =   0  'Flat
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Background"
         ForeColor       =   &H80000008&
         Height          =   255
         Index           =   1
         Left            =   120
         TabIndex        =   11
         Top             =   960
         Width           =   1695
      End
   End
End
Attribute VB_Name = "FPreferences"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'-------------------------------------------------------
'FPreferences
'
'Purpose:
'   Change Display Preferences
'
'Public Members:
'   None.
'
'Revision History:
'   May-24-1999      MAS     Created
'-------------------------------------------------------
Option Explicit
Private m_msgClick As VbMsgBoxResult
Private m_stPrefs As CPreferences

'----------------------------------------------------------
'CreateForm
'
'Arguments:
'   I   : Parent (parent form)
'   I/O : Prefs (is set to user prefs if user hits OK)
'
'Returns:
'   vbMsgBoxResult  vbCancel or vbOK
'
'Purpose:
'   Start the Form and run to completion, return to the caller
'   success of operation
'----------------------------------------------------------
Public Function CreateForm(Parent As Form, Prefs As CPreferences) As Integer
    m_msgClick = vbCancel
    Set m_stPrefs = New CPreferences
    Prefs.Copy m_stPrefs
    SetPrefs
    Me.Show 1, Parent
    If (m_msgClick = vbOK) Then
        m_stPrefs.Copy Prefs
    End If
    CreateForm = m_msgClick
End Function

'Status Page - enable radios
Private Sub chkStatusPages_Click()
    radRoiCursor.Enabled = chkStatusPages
    radSpectral.Enabled = chkStatusPages
End Sub

'YAxis - enable Text
Private Sub chkYAxisGrid_Click()
    txtNumGridlines.Enabled = chkYAxisGrid
End Sub

'Cancel
Private Sub cmdCancel_Click()
    m_msgClick = vbCancel
    Me.Hide
End Sub

'Reload Defaults
Private Sub cmdDefault_Click()
    m_stPrefs.DefaultPrefs
    SetPrefs
End Sub

'Read out results
Private Sub cmdOK_Click()
    On Error Resume Next
    
    m_stPrefs.SpecColor = lblColors(0).BackColor
    m_stPrefs.BackColor = lblColors(1).BackColor
    m_stPrefs.Roi1Color = lblColors(2).BackColor
    m_stPrefs.Roi2Color = lblColors(3).BackColor
    m_stPrefs.Roi3Color = lblColors(4).BackColor
    m_stPrefs.Roi4Color = lblColors(5).BackColor
    m_stPrefs.NuclColor = lblColors(6).BackColor
    m_stPrefs.NuclKeyColor = lblColors(7).BackColor
    
    If (radFull) Then
        m_stPrefs.PlotMethod = 2
    ElseIf (radEnvelope) Then
        m_stPrefs.PlotMethod = 3
    ElseIf (radFill) Then
        m_stPrefs.PlotMethod = 4
    Else
        m_stPrefs.PlotMethod = 1
    End If

    m_stPrefs.PointSize = cmbPointSize.ListIndex + 1
    m_stPrefs.XGrid = chkXAxisGrid
    m_stPrefs.XGridAsEnergy = chkXAxisAsEnergy
    m_stPrefs.YGrid = chkYAxisGrid
    m_stPrefs.Borders = chkPlotBorders
    m_stPrefs.Ticks = txtNumGridlines
    m_stPrefs.ShowBar = chkStatusBar
    m_stPrefs.ShowPages = chkStatusPages
    
    If (radSpectral) Then
        m_stPrefs.StatusPage = 2
    Else
        m_stPrefs.StatusPage = 1
    End If
        
    m_stPrefs.UpdateRate = txtUpdateRate
    m_msgClick = vbOK
    Me.Hide
End Sub

'Utility to set up the dialog
Private Sub SetPrefs()
    On Error Resume Next
    SetButtonColor 0, m_stPrefs.SpecColor
    SetButtonColor 1, m_stPrefs.BackColor
    SetButtonColor 2, m_stPrefs.Roi1Color
    SetButtonColor 3, m_stPrefs.Roi2Color
    SetButtonColor 4, m_stPrefs.Roi3Color
    SetButtonColor 5, m_stPrefs.Roi4Color
    SetButtonColor 6, m_stPrefs.NuclColor
    SetButtonColor 7, m_stPrefs.NuclKeyColor
    Select Case m_stPrefs.PlotMethod
    Case 2
        radFull = True
    Case 3
        radEnvelope = True
    Case 4
        radFill = True
    Case Else
        radnormal = True
    End Select
    
    cmbPointSize.ListIndex = m_stPrefs.PointSize - 1
    chkXAxisGrid = m_stPrefs.XGrid
    chkXAxisAsEnergy = m_stPrefs.XGridAsEnergy
    chkYAxisGrid = m_stPrefs.YGrid
    chkPlotBorders = m_stPrefs.Borders
    txtNumGridlines = m_stPrefs.Ticks
    chkStatusBar = m_stPrefs.ShowBar
    chkStatusPages = m_stPrefs.ShowPages
    
    Select Case m_stPrefs.StatusPage
    Case 2
        radSpectral = True
    Case Else
        radRoiCursor = True
    End Select
    
    txtUpdateRate = m_stPrefs.UpdateRate
    
    chkStatusPages_Click
    chkYAxisGrid_Click
    radEnvelope_Click
End Sub

'Utility to set the button color
Private Sub SetButtonColor(Index As Integer, Color As Long)
    lblColors(Index).BackColor = Color
    If (lblColors(Index).BackColor = vbBlack) Then
        lblColors(Index).ForeColor = vbWhite
    Else
        lblColors(Index).ForeColor = vbBlack
    End If
End Sub

'Change Colors
Private Sub lblColors_DblClick(Index As Integer)
    On Error GoTo ErrHdlr
    
    ColorDialog.Flags = cdlCCRGBInit
    ColorDialog.Color = lblColors(Index).BackColor
    ColorDialog.CancelError = True
    ColorDialog.ShowColor
    SetButtonColor Index, ColorDialog.Color
        
    Exit Sub
ErrHdlr:
    If (Err.Number = cdlCancel) Then
        Exit Sub
    Else
        ProcessError
    End If
End Sub

Private Sub radEnvelope_Click()
    cmbPointSize.Enabled = False
End Sub

Private Sub radFill_Click()
    cmbPointSize.Enabled = False
End Sub

Private Sub radFull_Click()
    cmbPointSize.Enabled = True
End Sub

Private Sub radnormal_Click()
    cmbPointSize.Enabled = True
End Sub
