VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CPreferences"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'-------------------------------------------------------
'CPreferences
'
'Purpose:
'   Utility functions for preferences
'
'Revision History:
'   Jun-01-1999      MAS     Created
'-------------------------------------------------------
Option Explicit
Private Declare Function GetPrivateProfileInt Lib "kernel32" Alias "GetPrivateProfileIntA" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal nDefault As Long, ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As String, ByVal lpFileName As String) As Long
Private Const INIFILE = "CIExample.INI"
Private Const INISECT = "DisplaySettings"

Public Linear As Integer
Public SpecColor As Long
Public BackColor As Long
Public Roi1Color As Long
Public Roi2Color As Long
Public Roi3Color As Long
Public Roi4Color As Long
Public NuclColor As Long
Public NuclKeyColor As Long
Public PlotMethod As Integer    '1=Normal, 2=Full, 3=Env, 4=Fill
Public PointSize As Integer    '1=Def, 2=Micro, 3=Small, 4=Medium, 5=Large
Public XGrid As Integer
Public XGridAsEnergy As Integer
Public YGrid As Integer
Public Borders As Integer
Public Ticks As Integer
Public ShowBar As Integer
Public ShowPages As Integer
Public StatusPage As Integer    '1=Roi/Cursor, 2=Spectral
Public UpdateRate As Integer
'----------------------------------------------------------
'Copy
'
'Arguments:
'   Target As Prefs - target to copy to
'
'Returns:
'   None.
'
'Purpose:
'   Copy prefs into the structure
'----------------------------------------------------------
Public Sub Copy(Target As CPreferences)
    Target.Linear = Linear
    Target.SpecColor = SpecColor
    Target.BackColor = BackColor
    Target.Roi1Color = Roi1Color
    Target.Roi2Color = Roi2Color
    Target.Roi3Color = Roi3Color
    Target.Roi4Color = Roi4Color
    Target.NuclColor = NuclColor
    Target.NuclKeyColor = NuclKeyColor
    Target.PlotMethod = PlotMethod
    Target.PointSize = PointSize
    Target.XGrid = XGrid
    Target.XGridAsEnergy = XGridAsEnergy
    Target.YGrid = YGrid
    Target.Borders = Borders
    Target.Ticks = Ticks
    Target.ShowBar = ShowBar
    Target.ShowPages = ShowPages
    Target.StatusPage = StatusPage
    Target.UpdateRate = UpdateRate
End Sub
'----------------------------------------------------------
'DefaultPrefs
'
'Arguments:
'   None.
'
'Returns:
'   None.
'
'Purpose:
'   Restore default prefs into the structure
'----------------------------------------------------------
Public Sub DefaultPrefs()
    Linear = True
    SpecColor = vbYellow
    BackColor = vbBlack
    Roi1Color = vbRed
    Roi2Color = vbCyan
    Roi3Color = vbGreen
    Roi4Color = vbMagenta
    NuclColor = vbGreen
    NuclKeyColor = vbCyan
    PlotMethod = 1  '1=Normal
    PointSize = 1 '1=Default
    XGrid = 0
    XGridAsEnergy = 1
    YGrid = 0
    Borders = 0
    Ticks = 3
    ShowBar = 1
    ShowPages = 1
    StatusPage = 1 '1=Roi/Cursor
    UpdateRate = 0
End Sub
'----------------------------------------------------------
'LoadPrefs
'
'Arguments:
'   None.
'
'Returns:
'   None.
'
'Purpose:
'   Load prefs into the structure
'----------------------------------------------------------
Public Sub LoadPrefs()
    Linear = GetPrivateProfileInt(INISECT, "Linear", 1, INIFILE)
    SpecColor = GetPrivateProfileInt(INISECT, "SpecColor", vbYellow, INIFILE)
    BackColor = GetPrivateProfileInt(INISECT, "BackColor", vbBlack, INIFILE)
    Roi1Color = GetPrivateProfileInt(INISECT, "Roi1Color", vbRed, INIFILE)
    Roi2Color = GetPrivateProfileInt(INISECT, "Roi2Color", vbBlue, INIFILE)
    Roi3Color = GetPrivateProfileInt(INISECT, "Roi3Color", vbCyan, INIFILE)
    Roi4Color = GetPrivateProfileInt(INISECT, "Roi4Color", vbMagenta, INIFILE)
    NuclColor = GetPrivateProfileInt(INISECT, "NuclColor", vbGreen, INIFILE)
    NuclKeyColor = GetPrivateProfileInt(INISECT, "NuclKeyColor", vbCyan, INIFILE)
    PlotMethod = GetPrivateProfileInt(INISECT, "PlotMethod", 1, INIFILE)
    PointSize = GetPrivateProfileInt(INISECT, "PointSize", 1, INIFILE)
    XGrid = GetPrivateProfileInt(INISECT, "XGrid", 0, INIFILE)
    XGridAsEnergy = GetPrivateProfileInt(INISECT, "XGridAsEnergy", 1, INIFILE)
    YGrid = GetPrivateProfileInt(INISECT, "YGrid", 0, INIFILE)
    Borders = GetPrivateProfileInt(INISECT, "Borders", 0, INIFILE)
    Ticks = GetPrivateProfileInt(INISECT, "Ticks", 3, INIFILE)
    ShowBar = GetPrivateProfileInt(INISECT, "ShowBar", 1, INIFILE)
    ShowPages = GetPrivateProfileInt(INISECT, "ShowPages", 1, INIFILE)
    StatusPage = GetPrivateProfileInt(INISECT, "Page", 1, INIFILE)
    UpdateRate = GetPrivateProfileInt(INISECT, "UpdateRate", 0, INIFILE)
End Sub
'----------------------------------------------------------
'StorePrefs
'
'Arguments:
'   None.
'
'Returns:
'   None.
'
'Purpose:
'   Store prefs into a INI file
'----------------------------------------------------------
Public Sub StorePrefs()
    WritePrivateProfileString INISECT, "Linear", Str(Linear), INIFILE
    WritePrivateProfileString INISECT, "SpecColor", Str(SpecColor), INIFILE
    WritePrivateProfileString INISECT, "BackColor", Str(BackColor), INIFILE
    WritePrivateProfileString INISECT, "Roi1Color", Str(Roi1Color), INIFILE
    WritePrivateProfileString INISECT, "Roi2Color", Str(Roi2Color), INIFILE
    WritePrivateProfileString INISECT, "Roi3Color", Str(Roi3Color), INIFILE
    WritePrivateProfileString INISECT, "Roi4Color", Str(Roi4Color), INIFILE
    WritePrivateProfileString INISECT, "NuclColor", Str(NuclColor), INIFILE
    WritePrivateProfileString INISECT, "NuclKeyColor", Str(NuclKeyColor), INIFILE
    WritePrivateProfileString INISECT, "PlotMethod", Str(PlotMethod), INIFILE
    WritePrivateProfileString INISECT, "PointSize", Str(PointSize), INIFILE
    WritePrivateProfileString INISECT, "XGrid", Str(XGrid), INIFILE
    WritePrivateProfileString INISECT, "XGridAsEnergy", Str(XGridAsEnergy), INIFILE
    WritePrivateProfileString INISECT, "YGrid", Str(YGrid), INIFILE
    WritePrivateProfileString INISECT, "Borders", Str(Borders), INIFILE
    WritePrivateProfileString INISECT, "Ticks", Str(Ticks), INIFILE
    WritePrivateProfileString INISECT, "ShowBar", Str(ShowBar), INIFILE
    WritePrivateProfileString INISECT, "ShowPages", Str(ShowPages), INIFILE
    WritePrivateProfileString INISECT, "Page", Str(StatusPage), INIFILE
    WritePrivateProfileString INISECT, "UpdateRate", Str(UpdateRate), INIFILE
End Sub

