VERSION 5.00
Begin VB.Form FMcaWait 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Acquisition Status"
   ClientHeight    =   3240
   ClientLeft      =   45
   ClientTop       =   285
   ClientWidth     =   4680
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3240
   ScaleWidth      =   4680
   StartUpPosition =   1  'CenterOwner
   Begin VB.Timer TimerUpdate 
      Interval        =   1000
      Left            =   360
      Top             =   2520
   End
   Begin VB.ListBox StatusList 
      Height          =   1425
      Left            =   1800
      TabIndex        =   3
      Top             =   600
      Width           =   2655
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop"
      Height          =   375
      Left            =   240
      TabIndex        =   2
      Top             =   1440
      Width           =   975
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start"
      Height          =   375
      Left            =   240
      TabIndex        =   1
      Top             =   840
      Width           =   975
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "OK"
      Height          =   495
      Left            =   1440
      TabIndex        =   0
      Top             =   2400
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "Status:"
      Height          =   255
      Left            =   1800
      TabIndex        =   4
      Top             =   240
      Width           =   1215
   End
End
Attribute VB_Name = "FMcaWait"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'-------------------------------------------------------
'FMcaWait
'
'Purpose:
'   Show an example of Dynamic Updates during acquisition
'   This sets up the form to trigger on a Acquire Start
'   event sent from the device. When this is received
'   a timer is started which will update the elapsed times
'   in the list box. This continues until the preset is
'   reached. Also adds status messages to the list box
'
'Public Members:
'   None.
'
'Revision History:
'   May-24-1999      MAS     Created
'-------------------------------------------------------
Option Explicit
Private WithEvents m_Dev As CanberraDeviceAccessLib.DeviceAccess
Attribute m_Dev.VB_VarHelpID = -1

'----------------------------------------------------------
'CreateForm
'
'Arguments:
'   I   : Parent (parent form)
'   I/O : DeviceAccess (is set to preset if user hits OK)
'
'Returns:
'   vbMsgBoxResult  vbCancel or vbOK
'
'Purpose:
'   Start the Form and run to completion, return to the caller
'   success of operation
'----------------------------------------------------------
Public Function CreateForm(Parent As Form, Dev As CanberraDeviceAccessLib.DeviceAccess) As Integer
    Dim mask As CanberraDeviceAccessLib.DeviceStatus
    Dim lStat As Long
    
    On Error GoTo ErrHdlr
        
    Set m_Dev = Dev
    
    'Check the device status to see if we are acquiring
    lStat = m_Dev.AnalyzerStatus
    mask = aAcquiring
    If ((lStat And mask) = mask) Then
        TimerUpdate.Enabled = True
    End If
    
    Me.Show 1, Parent
    Set m_Dev = Nothing
    CreateForm = vbOK
    Exit Function
ErrHdlr:
    ProcessError
    CreateForm = vbCancel
End Function

Private Sub cmdOK_Click()
    Me.Hide
End Sub

Private Sub cmdStart_Click()
    On Error GoTo ErrHdlr
    'Here is an alternate way to send commands to a device
    m_Dev.SendCommand aStart
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

Private Sub cmdStop_Click()
    On Error GoTo ErrHdlr
    'Here is an alternate way to send commands to a device
    m_Dev.SendCommand aStop
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

Private Sub m_Dev_DeviceMessages(ByVal Message As Long, ByVal wParam As Long, ByVal lParam As Long)
    Dim mask As CanberraDeviceAccessLib.AdviseMessageMasks
    
    On Error GoTo ErrHdlr
    
    'Here is how advises events could be handled
    If (Message = CanberraDeviceAccessLib.DeviceMessages.aAdvise) Then
        mask = amAcquireDone
        If ((lParam And mask) = mask) Then
            StatusList.AddItem "Acquire Done"
            TimerUpdate.Enabled = False
        End If
        mask = amAcquireStart
        If ((lParam And mask) = mask) Then
            StatusList.AddItem "Acquire Started"
            TimerUpdate.Enabled = True
        End If
        mask = amHardwareError
        If ((lParam And mask) = mask) Then
            StatusList.AddItem "Hardware Error"
        End If
        mask = amSampleChangeAdvance
        If ((lParam And mask) = mask) Then
            StatusList.AddItem "Sample Changer started"
        End If
        mask = amSampleChangerSet
        If ((lParam And mask) = mask) Then
            StatusList.AddItem "Sample Changer ended"
        End If
    End If
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

Private Sub TimerUpdate_Timer()
    Dim mask As CanberraDeviceAccessLib.DeviceStatus
    Dim lStat As Long
    
    On Error GoTo ErrHdlr
    
    'Dynamically check the device elapsed state
    lStat = m_Dev.AnalyzerStatus
    mask = aAcquiring
    If ((lStat And mask) = mask) Then
        Dim dElapsed As Double
        If (m_Dev.Param(CAM_L_PMLIVE) <> 0) Then
            dElapsed = Str(m_Dev.Param(CAM_X_ELIVE))
        ElseIf (m_Dev.Param(CAM_L_PMREAL) <> 0) Then
            dElapsed = Str(m_Dev.Param(CAM_X_EREAL))
        Else
            Exit Sub
        End If
        StatusList.AddItem "Acquiring " & dElapsed
    End If
    'Check for error
    mask = aError
    If ((lStat And mask) = mask) Then
        StatusList.AddItem "Error"
    End If
    
    Exit Sub
ErrHdlr:
    ProcessError
End Sub
