VERSION 5.00
Begin VB.Form FMcaSetup 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Acquire Setup"
   ClientHeight    =   4215
   ClientLeft      =   45
   ClientTop       =   285
   ClientWidth     =   4680
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4215
   ScaleWidth      =   4680
   StartUpPosition =   1  'CenterOwner
   Begin VB.CommandButton cmdHV 
      Caption         =   "Turn on High Voltage"
      Height          =   375
      Left            =   600
      TabIndex        =   19
      Top             =   3120
      Width           =   3495
   End
   Begin VB.Frame Frame2 
      Caption         =   "Computational Preset"
      Height          =   1815
      Left            =   240
      TabIndex        =   7
      Top             =   1200
      Width           =   4215
      Begin VB.TextBox txtRoiStop 
         Height          =   285
         Left            =   3000
         TabIndex        =   18
         Top             =   960
         Width           =   735
      End
      Begin VB.TextBox txtRoiStart 
         Height          =   285
         Left            =   3000
         TabIndex        =   17
         Top             =   600
         Width           =   735
      End
      Begin VB.CommandButton cmdRoi 
         Caption         =   "Use Current Roi"
         Height          =   315
         Left            =   1680
         TabIndex        =   16
         Top             =   1320
         Width           =   2055
      End
      Begin VB.TextBox txtCompValue 
         Height          =   285
         Left            =   2280
         TabIndex        =   13
         Top             =   240
         Width           =   1455
      End
      Begin VB.OptionButton radCounts 
         Caption         =   "Counts"
         Height          =   255
         Left            =   240
         TabIndex        =   11
         Top             =   1320
         Width           =   975
      End
      Begin VB.OptionButton radArea 
         Caption         =   "Area"
         Height          =   315
         Left            =   240
         TabIndex        =   10
         Top             =   960
         Width           =   1095
      End
      Begin VB.OptionButton radIntegral 
         Caption         =   "Integral"
         Height          =   315
         Left            =   240
         TabIndex        =   9
         Top             =   600
         Width           =   975
      End
      Begin VB.OptionButton radNone 
         Caption         =   "None"
         Height          =   375
         Left            =   240
         TabIndex        =   8
         Top             =   240
         Width           =   1095
      End
      Begin VB.Label Label3 
         Caption         =   "Stop Chan:"
         Height          =   255
         Left            =   1680
         TabIndex        =   15
         Top             =   960
         Width           =   975
      End
      Begin VB.Label Label2 
         Caption         =   "Start Chan:"
         Height          =   255
         Left            =   1680
         TabIndex        =   14
         Top             =   600
         Width           =   1095
      End
      Begin VB.Label s 
         Caption         =   "Value:"
         Height          =   255
         Left            =   1680
         TabIndex        =   12
         Top             =   240
         Width           =   735
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Time Preset"
      Height          =   975
      Left            =   240
      TabIndex        =   2
      Top             =   120
      Width           =   4215
      Begin VB.TextBox txtPreset 
         Height          =   285
         Left            =   1800
         TabIndex        =   5
         Top             =   480
         Width           =   975
      End
      Begin VB.OptionButton radReal 
         Caption         =   "Real Time"
         Height          =   255
         Left            =   240
         TabIndex        =   4
         Top             =   600
         Width           =   1095
      End
      Begin VB.OptionButton radLive 
         Caption         =   "Live Time"
         Height          =   375
         Left            =   240
         TabIndex        =   3
         Top             =   240
         Width           =   1455
      End
      Begin VB.Label Label1 
         Caption         =   "seconds"
         Height          =   255
         Left            =   3120
         TabIndex        =   6
         Top             =   480
         Width           =   615
      End
   End
   Begin VB.CommandButton cmdCancel 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   2880
      TabIndex        =   1
      Top             =   3720
      Width           =   1215
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "OK"
      Height          =   375
      Left            =   600
      TabIndex        =   0
      Top             =   3720
      Width           =   1215
   End
End
Attribute VB_Name = "FMcaSetup"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'-------------------------------------------------------
'FMcaSetup
'
'Purpose:
'   Acquire Setup
'
'Public Members:
'   None.
'
'Revision History:
'   May-24-1999      MAS     Created
'-------------------------------------------------------
Option Explicit
Private m_msgClick As VbMsgBoxResult
Private m_Dev As CanberraDeviceAccessLib.DeviceAccess

'----------------------------------------------------------
'CreateForm
'
'Arguments:
'   I   : Parent (parent form)
'   I/O : DeviceAccess (is set to preset if user hits OK)
'
'Returns:
'   vbMsgBoxResult  vbCancel or vbOK
'
'Purpose:
'   Start the Form and run to completion, return to the caller
'   success of operation
'----------------------------------------------------------
Public Function CreateForm(Parent As Form, Dev As CanberraDeviceAccessLib.DeviceAccess) As Integer
    m_msgClick = vbCancel
    Set m_Dev = Dev
    If (SetupDevice()) Then
        Me.Show 1, Parent
    End If
    Set m_Dev = Nothing
    CreateForm = m_msgClick
End Function

Private Function SetupDevice() As Boolean
    On Error GoTo ErrHdlr
    
    'Get Time Preset
    If (m_Dev.Param(CAM_L_PMLIVE) <> 0) Then
        txtPreset = m_Dev.Param(CAM_X_PLIVE)
        radLive = True
    ElseIf (m_Dev.Param(CAM_L_PMREAL) <> 0) Then
        txtPreset = m_Dev.Param(CAM_X_PREAL)
        radReal = True
    Else
        MsgBox "Unsupported Preset Type"
        SetupDevice = False
        Exit Function
    End If
    
    'Get Comp Preset
    radArea_Click
    txtRoiStart = m_Dev.Param(CAM_L_PTSCHAN)
    txtRoiStop = m_Dev.Param(CAM_L_PTECHAN)
    If (m_Dev.Param(CAM_L_PMTOTALS) <> 0) Then
        txtCompValue = m_Dev.Param(CAM_L_PTOTAL)
        radIntegral = True
    ElseIf (m_Dev.Param(CAM_L_PMLEVEL) <> 0) Then
        txtCompValue = m_Dev.Param(CAM_L_PLEVEL)
        radCounts = True
    ElseIf (m_Dev.Param(CAM_L_PMAREA) <> 0) Then
        txtCompValue = m_Dev.Param(CAM_F_PAREA)
        radArea = True
    Else
        txtCompValue = ""
        radNone = True
        radNone_Click
    End If
    SetupDevice = True
    Exit Function
ErrHdlr:
    ProcessError
    SetupDevice = False
End Function

Private Sub cmdCancel_Click()
    m_msgClick = vbCancel
    Me.Hide
End Sub

Private Sub cmdHV_Click()
    On Error Resume Next
    m_Dev.Param(CAM_L_HVPSFSTAT) = 1
End Sub

Private Sub cmdOK_Click()
    Dim lFlags As CanberraDeviceAccessLib.AcquisitionModes
    Dim bComp As Boolean
        
    On Error GoTo ErrHdlr
    
    'Get Time Preset
    If (radLive = True) Then
        lFlags = aCountToLiveTime
    ElseIf (radReal = True) Then
        lFlags = aCountToRealTime
    Else
        Exit Sub
    End If
        
    'Get Comp Preset
    bComp = True
    If (radIntegral = True) Then
        lFlags = lFlags Or aCountToTotal
    ElseIf (radCounts = True) Then
        lFlags = lFlags Or aCountToLevel
    ElseIf (radArea = True) Then
        lFlags = lFlags Or aCountToArea
    Else
        bComp = False
    End If
    
    'It is very important here to use Spectroscopy acquire setup
    'Setting the options as individual parameters is not suffucient to
    'set the preset in the device.
    If (bComp) Then
        m_Dev.SpectroscopyAcquireSetup lFlags, Val(txtCompValue), Val(txtRoiStart), Val(txtRoiStop), Val(txtPreset)
    Else
        m_Dev.SpectroscopyAcquireSetup lFlags, Val(txtPreset)
    End If
    m_msgClick = vbOK
    Me.Hide
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

Private Sub cmdRoi_Click()
    On Error GoTo ErrHdlr
    txtRoiStart = m_Dev.Param(CAM_L_LMARKCH)
    txtRoiStop = m_Dev.Param(CAM_L_RMARKCH)
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

Private Sub radArea_Click()
    txtCompValue.Enabled = True
    txtRoiStart.Enabled = True
    txtRoiStop.Enabled = True
End Sub

Private Sub radCounts_Click()
    txtCompValue.Enabled = True
    txtRoiStart.Enabled = True
    txtRoiStop.Enabled = True
End Sub

Private Sub radIntegral_Click()
    txtCompValue.Enabled = True
    txtRoiStart.Enabled = True
    txtRoiStop.Enabled = True
End Sub

Private Sub radNone_Click()
    txtCompValue.Enabled = False
    txtRoiStart.Enabled = False
    txtRoiStop.Enabled = False
End Sub

