VERSION 5.00
Object = "{07D2E9B4-09C1-11D2-85D3-204C4F4F5020}#1.0#0"; "Displayr.dll"
Object = "{5EC32861-BCAC-11D1-AB1E-0020AF302738}#1.0#0"; "rptview.dll"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form FMcaDisplay 
   AutoRedraw      =   -1  'True
   Caption         =   "Canberra Components Example Application"
   ClientHeight    =   7200
   ClientLeft      =   165
   ClientTop       =   360
   ClientWidth     =   9840
   LinkTopic       =   "Form1"
   ScaleHeight     =   7200
   ScaleWidth      =   9840
   StartUpPosition =   2  'CenterScreen
   Begin CanberraReporterLibCtl.ReportViewer ReportWin 
      Height          =   1695
      Left            =   1200
      TabIndex        =   1
      Top             =   5280
      Width           =   8415
      _cx             =   4209147
      _cy             =   4197294
      BackColor       =   16777215
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Courier New"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      BorderStyle     =   1
   End
   Begin CanberraDataDisplayLibCtl.Mvc McaDisplay 
      Height          =   4935
      Left            =   120
      OleObjectBlob   =   "McaDisplay.frx":0000
      TabIndex        =   0
      Top             =   120
      Width           =   9615
   End
   Begin MSComDlg.CommonDialog OpenDialog 
      Left            =   600
      Top             =   5400
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileOpenFile 
         Caption         =   "&Open File..."
      End
      Begin VB.Menu mnuFileOpenDetector 
         Caption         =   "O&pen Detector..."
      End
      Begin VB.Menu mnuFileSave 
         Caption         =   "&Save"
      End
      Begin VB.Menu mnuFileSaveAs 
         Caption         =   "Save &As..."
      End
      Begin VB.Menu mnuFileClose 
         Caption         =   "&Close"
      End
      Begin VB.Menu mnuFileCloseAll 
         Caption         =   "C&lose All"
      End
      Begin VB.Menu mnusep 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFilePrint 
         Caption         =   "&Print..."
      End
      Begin VB.Menu mnuFileCopy 
         Caption         =   "&Copy"
      End
      Begin VB.Menu mnuFileExport 
         Caption         =   "&Export..."
      End
      Begin VB.Menu mnuSep2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuMCA 
      Caption         =   "&MCA"
      Begin VB.Menu mnuMCAAcquireSetup 
         Caption         =   "&Acquire Setup..."
      End
      Begin VB.Menu mnuMCAAcquireStart 
         Caption         =   "Acquire &Start"
      End
      Begin VB.Menu mnuMCAAcquireStop 
         Caption         =   "Acquire S&top"
      End
      Begin VB.Menu mnuMCAAcquireStatus 
         Caption         =   "Acqui&re Status..."
      End
      Begin VB.Menu mnuMCAClearData 
         Caption         =   "Clear &Data"
      End
      Begin VB.Menu mnuMCAAdjust 
         Caption         =   "Ad&just..."
      End
   End
   Begin VB.Menu mnuDisplay 
      Caption         =   "&Display"
      Begin VB.Menu mnuDisplayExpand 
         Caption         =   "E&xpand"
      End
      Begin VB.Menu mnuDisplayZoomMenu 
         Caption         =   "&Zoom"
         Begin VB.Menu mnuDisplayZoom 
            Caption         =   "Zoom Mo&de"
         End
         Begin VB.Menu mnuDisplayZoomOut 
            Caption         =   "Zoo&m Out"
         End
      End
      Begin VB.Menu mnuDisplayScale 
         Caption         =   "&Scale"
         Begin VB.Menu mnuDisplayLog 
            Caption         =   "&Log Mode"
         End
         Begin VB.Menu mnuDisplayLinear 
            Caption         =   "Li&near Mode"
         End
         Begin VB.Menu mnuDisplayAutoScale 
            Caption         =   "Au&to Scale"
         End
      End
      Begin VB.Menu mnuDisplayRois 
         Caption         =   "&Rois"
         Begin VB.Menu mnuDisplayNextRoi 
            Caption         =   "&Next Roi"
         End
         Begin VB.Menu mnuDisplayPreviousRoi 
            Caption         =   "&Previous Roi"
         End
         Begin VB.Menu mnuDisplayAddRoi 
            Caption         =   "&Add Roi"
         End
         Begin VB.Menu mnuDisplayDeleteRoi 
            Caption         =   "&Delete Roi"
         End
         Begin VB.Menu mnuDisplayClearAll 
            Caption         =   "&Clear All"
         End
         Begin VB.Menu mnuDisplayLoadRois 
            Caption         =   "Load R&ois..."
         End
         Begin VB.Menu mnuDisplayStoreRois 
            Caption         =   "&Store Rois..."
         End
      End
      Begin VB.Menu mnuDisplayNuclide 
         Caption         =   "&Nuclide Lines"
         Begin VB.Menu mnuDisplayShowNuclides 
            Caption         =   "&Show Nuclides"
         End
         Begin VB.Menu mnuDisplayNextNuclide 
            Caption         =   "Ne&xt Nuclide"
         End
         Begin VB.Menu mnuDisplayPrevNuclide 
            Caption         =   "&Previous Nuclide"
         End
         Begin VB.Menu mnuDisplayNextNucline 
            Caption         =   "Next Nuclide &Line"
         End
         Begin VB.Menu mnuDisplayPrevNucline 
            Caption         =   "Previous Nu&clide Line"
         End
      End
      Begin VB.Menu mnuDisplayPreferences 
         Caption         =   "&Preferences..."
      End
   End
   Begin VB.Menu mnuAnalysis 
      Caption         =   "&Analysis and Reporting"
      Begin VB.Menu mnuAnalysisEditSequence 
         Caption         =   "&Edit Analysis Sequence..."
      End
      Begin VB.Menu mnuAnalysisExecute 
         Caption         =   "E&xecute Analysis Sequence..."
      End
      Begin VB.Menu mnuAnalysisExecuteCurrent 
         Caption         =   "Execute &Current Analysis Sequence"
      End
      Begin VB.Menu mnuSep3 
         Caption         =   "-"
      End
      Begin VB.Menu mnuAnalysisShowReport 
         Caption         =   "&Show Report Window"
      End
      Begin VB.Menu mnuAnalysisPrintReport 
         Caption         =   "&Print Report Window"
      End
      Begin VB.Menu mnuAnalysisCopyReport 
         Caption         =   "Co&py Report"
      End
      Begin VB.Menu mnuAnalysisCopySelected 
         Caption         =   "Copy Se&lected Report"
      End
      Begin VB.Menu mnuAnalysisSaveReport 
         Caption         =   "Save &Report..."
      End
   End
   Begin VB.Menu mnuDatasource 
      Caption         =   "&Datasource"
      Begin VB.Menu mnuDatasourceNext 
         Caption         =   "&Next Datasource"
      End
      Begin VB.Menu mnuDatasourcePrevious 
         Caption         =   "&Previous Datasource"
      End
   End
   Begin VB.Menu mnuOptions 
      Caption         =   "&Edit"
      Begin VB.Menu mnuOptionsCFED 
         Caption         =   "&Certificate File Editor"
      End
      Begin VB.Menu mnuOptionsCalibrations 
         Caption         =   "&Show Calibrations"
      End
      Begin VB.Menu mnuOptionsSampleEdit 
         Caption         =   "Sam&ple Editor"
      End
   End
End
Attribute VB_Name = "FMcaDisplay"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'-------------------------------------------------------
'FMcaDisplay
'
'Purpose:
'   Main Application Dialog
'
'Public Members:
'   None.
'
'Revision History:
'   May-24-1999      MAS     Created
'-------------------------------------------------------
Option Explicit
Private m_stPrefs As CPreferences
Private m_frmAdjust As FAdjust
Private m_bShowReport As Boolean
Private WithEvents m_SeqAnalyzer As CanberraSequenceAnalyzerLib.SequenceAnalyzer
Attribute m_SeqAnalyzer.VB_VarHelpID = -1

'Utility to handle displaying a source
Public Sub DisplaySource(Datasource As Object)
    On Error GoTo ErrHdlr
    McaDisplay.CurrentDataSource = Datasource
    UpdateMenus
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Utility to handle updating the menus
Private Sub UpdateMenus()
    On Error GoTo ErrHdlr
    Dim bEnabled As Boolean
    
    mnuDisplayZoom.Checked = McaDisplay.ActivateZoom
    mnuDisplayExpand.Checked = McaDisplay.ExpandMode
    mnuDisplayLog.Checked = Not McaDisplay.LinearScale
    mnuDisplayLinear.Checked = McaDisplay.LinearScale
    
    bEnabled = (McaDisplay.NumberOfSources <> 0)
    mnuFileSave = bEnabled
    mnuFileSaveAs = bEnabled
    mnuFileClose = bEnabled
    mnuFileCloseAll = bEnabled
    mnuFilePrint = bEnabled
    mnuFileCopy = bEnabled
    mnuFileExport = bEnabled
    mnuDisplayZoom = bEnabled
    mnuDisplayZoomOut = bEnabled
    mnuDisplayNextRoi = bEnabled
    mnuDisplayPreviousRoi = bEnabled
    mnuDisplayAddRoi = bEnabled
    mnuDisplayDeleteRoi = bEnabled
    mnuDisplayClearAll = bEnabled
    mnuDisplayLoadRois = bEnabled
    mnuDisplayStoreRois = bEnabled
    mnuDisplayShowNuclides = bEnabled
    mnuDisplayNextNuclide = bEnabled
    mnuDisplayPrevNuclide = bEnabled
    mnuDisplayNextNucline = bEnabled
    mnuDisplayPrevNucline = bEnabled
    mnuAnalysisCopyReport = bEnabled
    mnuAnalysisCopySelected = bEnabled
    mnuAnalysisEditSequence = bEnabled
    mnuAnalysisExecute = bEnabled
    mnuAnalysisExecuteCurrent = bEnabled
    mnuAnalysisPrintReport = bEnabled
    mnuAnalysisSaveReport = bEnabled
    mnuOptionsSampleEdit = bEnabled
    
    'Add name to title bar
    Me.Caption = gc_AppTitle
    If (bEnabled) Then
        Me.Caption = Me.Caption & "-[" & McaDisplay.CurrentDataSourceName & "]"
    End If
    
    'Allow view calibrations on a file
    If (bEnabled) Then
        mnuOptionsCalibrations = (McaDisplay.CurrentDataSourceType = SpectroscopyFile)
    Else
        mnuOptionsCalibrations = bEnabled
    End If
    
    'Allow Mca stuff only on detectors
    If (bEnabled) Then
        bEnabled = (McaDisplay.CurrentDataSourceType = SpectroscopyDetector)
    End If
    mnuMCAAcquireSetup = bEnabled
    mnuMCAAcquireStart = bEnabled
    mnuMCAAcquireStop = bEnabled
    mnuMCAAcquireStatus = bEnabled
    mnuMCAAdjust = bEnabled
    mnuMCAClearData = bEnabled
    
    'Allow datasource only if more than one open
    bEnabled = (McaDisplay.NumberOfSources > 1)
    mnuDatasourceNext = bEnabled
    mnuDatasourcePrevious = bEnabled
    
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Close up any open adjust windows
Private Sub CloseAdjust()
    On Error GoTo ErrHdlr
    
    m_frmAdjust.Hide
    Unload m_frmAdjust
    Set m_frmAdjust = Nothing
    Exit Sub
ErrHdlr:
    'If adjust not defined then skip error handler and leave
    If (Err.Number <> 91) Then
        ProcessError
    End If
End Sub

'Update the MCA display with preference settings
Private Sub SetPrefs()
    On Error GoTo ErrHdlr
    
    McaDisplay.LinearScale = m_stPrefs.Linear
    McaDisplay.SpectrumColor = m_stPrefs.SpecColor
    McaDisplay.BackColor = m_stPrefs.BackColor
    McaDisplay.RoiType1Color = m_stPrefs.Roi1Color
    McaDisplay.RoiType2Color = m_stPrefs.Roi2Color
    McaDisplay.RoiType3Color = m_stPrefs.Roi3Color
    McaDisplay.RoiType4Color = m_stPrefs.Roi4Color
    McaDisplay.NuclineColor = m_stPrefs.NuclColor
    McaDisplay.KeylineColor = m_stPrefs.NuclKeyColor
    Select Case m_stPrefs.PlotMethod
    Case 2
        McaDisplay.DisplayPoints = True
        McaDisplay.ShowCompressedData = False
        McaDisplay.FillSpectralRois = False
    Case 3
        McaDisplay.DisplayPoints = False
        McaDisplay.ShowCompressedData = True
        McaDisplay.FillSpectralRois = False
    Case 4
        McaDisplay.DisplayPoints = True
        McaDisplay.ShowCompressedData = True
        McaDisplay.FillSpectralRois = True
    Case Else
        McaDisplay.DisplayPoints = True
        McaDisplay.ShowCompressedData = True
        McaDisplay.FillSpectralRois = False
    End Select
   
    Select Case m_stPrefs.PointSize
    Case 2
        McaDisplay.PlotPointSize = Micro
    Case 3
        McaDisplay.PlotPointSize = Small
    Case 4
        McaDisplay.PlotPointSize = Medium
    Case 5
        McaDisplay.PlotPointSize = Large
    Case Else
        McaDisplay.PlotPointSize = BestFit
    End Select
 
    McaDisplay.ShowXAxisGridLines = (m_stPrefs.XGrid = 1)
    McaDisplay.XAxisAsEnergy = (m_stPrefs.XGridAsEnergy = 1)
    McaDisplay.ShowYAxisGridLines = (m_stPrefs.YGrid = 1)
    McaDisplay.ShowPlotBorders = (m_stPrefs.Borders = 1)
    McaDisplay.NumberOfTicks = m_stPrefs.Ticks
    McaDisplay.ShowStatus = (m_stPrefs.ShowBar = 1)
    Select Case m_stPrefs.StatusPage
    Case 2
        McaDisplay.ShowSpectralDataSpreadSheet = True
    Case Else
        McaDisplay.ShowCalculationSpreadSheet = True
    End Select
    McaDisplay.ShowInfo = (m_stPrefs.ShowPages = 1)
    McaDisplay.DisplayUpdateRate = m_stPrefs.UpdateRate * 1000
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Analysis Done
Private Sub m_SeqAnalyzer_AnalyzeDone(ByVal hRes As Long, ByVal nStep As Integer)
    Me.Caption = gc_AppTitle
    If (hRes <> 0) Then
        MsgBox "Analysis Error in Step " & Str(nStep) & ": " & m_SeqAnalyzer.Message(hRes)
    End If
End Sub

' Close Adjust when new DS opened
Private Sub McaDisplay_DragAndDropOpen()
    CloseAdjust
    UpdateMenus
End Sub

'Capture RMB
Private Sub McaDisplay_MouseDown(ByVal Button As Integer, ByVal Shift As Integer, ByVal X As Single, ByVal y As Single)
    If (Button = 2) Then
        PopupMenu mnuDisplay
    End If
End Sub

Private Sub McaDisplay_UpdateTimeInfo(ByVal StartTime As String, ByVal ElapsedReal As Double, ByVal ElapsedLive As Double, ByVal DeadTime As Double)
    'Here you can check elapsed times during acquisitions
End Sub

'Utility to handle updating the menus
Private Sub mnuDisplay_Click()
    Dim bEnable As Boolean
    
    On Error GoTo ErrHdlr
    mnuDisplayAutoScale.Checked = McaDisplay.AutoScale
    bEnable = McaDisplay.ShowSpectralNuclideAnnotationsLines
    mnuDisplayShowNuclides.Checked = bEnable
    mnuDisplayNextNuclide.Enabled = bEnable
    mnuDisplayPrevNuclide.Enabled = bEnable
    mnuDisplayNextNucline.Enabled = bEnable
    mnuDisplayPrevNucline.Enabled = bEnable
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Updating the menus
Private Sub Form_Load()
    'Init the Show report flag
    m_bShowReport = True
    mnuAnalysisShowReport.Checked = m_bShowReport
    
    'Init the menus
    UpdateMenus
    
    'Init the prefs
    Set m_stPrefs = New CPreferences
    m_stPrefs.LoadPrefs
    SetPrefs
End Sub

'Resize
Private Sub Form_Resize()
    If (m_bShowReport) Then
        ReportWin.Visible = True
        McaDisplay.Left = 100
        McaDisplay.Width = Me.Width - 300
        McaDisplay.Top = 0
        McaDisplay.Height = Me.Height - 2800
        ReportWin.Left = McaDisplay.Left
        ReportWin.Width = McaDisplay.Width
        ReportWin.Top = McaDisplay.Height
        ReportWin.Height = Me.Height - ReportWin.Top - 800
    Else
        ReportWin.Visible = False
        McaDisplay.Left = 100
        McaDisplay.Width = Me.Width - 300
        McaDisplay.Top = 0
        McaDisplay.Height = Me.Height - 800
    End If
End Sub

'Close up
Private Sub Form_Unload(Cancel As Integer)
    McaDisplay.CloseAll
    m_stPrefs.StorePrefs
End Sub



Private Sub mnuDisplayShowNuclides_Click()
    McaDisplay.ShowSpectralPeakInformation = Not mnuDisplayShowNuclides.Checked
    McaDisplay.ShowSpectralNuclideAnnotationsLines = Not mnuDisplayShowNuclides.Checked
End Sub

'File Open File
Private Sub mnuFileOpenFile_Click()
    Dim CAMFile As New CanberraDataAccessLib.DataAccess
    
    On Error GoTo ErrHdlr
    
    'Use the MS common dialog to get a filename
    OpenDialog.Filter = "Cam Files|*.CNF"
    OpenDialog.DialogTitle = "Open CAM File"
    OpenDialog.DefaultExt = "*.CNF"
    OpenDialog.FileName = "*.CNF"
    OpenDialog.CancelError = True
    OpenDialog.Flags = cdlOFNHideReadOnly
    OpenDialog.ShowOpen
    
    'Assume we have vald file name and try to open
    CAMFile.Open OpenDialog.FileName, dReadWrite
    
    'If you plan to use the Spectral Data spreadsheet, the
    ' Extended Cursor Information Display or the
    ' Nuclide Annotation lines then you might want to try opening
    ' the file with DirectAccess:
    '
    '   CAMFile.Open OpenDialog.FileName, dReadWrite Or dDirectAccess
    '
    ' This might have some side effects :
    ' Since direct access bypasses the server (VDM) not all
    ' clients of the same file will not be notified of updates
    ' to the file. This may or may not be relevant depending on your
    ' application. Consider running a peak-area analysis on the
    ' currently displayed datasource. Had the file been open
    ' directaccess, then the MVC will not update the ROIs because it
    ' does not know the file changed
        
    'Assume all is well and display
    CloseAdjust
    DisplaySource CAMFile
    
    'Cleanup
    Set CAMFile = Nothing
    Exit Sub
    
ErrHdlr:
    If (Err.Number = cdlCancel) Then
        Exit Sub 'User clicked cancel on the dialog
    Else
        ProcessError
    End If
End Sub

'File Open Detector
Private Sub mnuFileOpenDetector_Click()
    Dim Dev As New CanberraDeviceAccessLib.DeviceAccess
    Dim frmOpen As New FOpenDetector
    
    On Error GoTo ErrHdlr
    'Use the OpenDetector form to get a detector name
    If (frmOpen.CreateForm(Me) = vbOK) Then
        'Connect and Display
        Dev.Connect frmOpen.m_strDetector
        CloseAdjust
        DisplaySource Dev
    End If
    
    'Clean up
    Unload frmOpen
    Set Dev = Nothing
    Exit Sub

ErrHdlr:
    'Handle some common errors
    If (Err.Number = ERR_BUSYBUTNEVER) Then
        'The device is busy but is not being monitored by the VDM.
        'There are three options: stop and reverify, continue acquire,
        'or just forget it
        Dim iResponse As Integer
        iResponse = MsgBox("Detector " & frmOpen.m_strDetector & " is acquiring. Stop acquisiton and reverify?", vbYesNoCancel)
        If (iResponse = vbYes) Then
            Dev.Connect frmOpen.m_strDetector, aTakeControl, SpectroscopyDetector
        ElseIf (iResponse = vbNo) Then
            Dev.Connect frmOpen.m_strDetector, aContinue, SpectroscopyDetector
        Else
            Exit Sub
        End If
        Resume Next
    ElseIf (Err.Number = ERR_VERIFYWARN) Then
        'The device is open but has differences in the settings from
        'those last time it was saved
        ProcessError
        Resume Next
    Else
        'Something has prevented you from connecting.
        ProcessError
    End If

End Sub

'File Save
Private Sub mnuFileSave_Click()
    On Error GoTo ErrHdlr
    
    If (McaDisplay.NumberOfSources = 0) Then
        Exit Sub
    End If
    
    McaDisplay.Save
    UpdateMenus
    Exit Sub
    
ErrHdlr:
    ProcessError
End Sub

'File Save As
Private Sub mnuFileSaveAs_Click()
    On Error GoTo ErrHdlr
    
    If (McaDisplay.NumberOfSources = 0) Then
        Exit Sub
    End If
    
    'Use the MS common dialog to get a filename
    OpenDialog.Filter = "CAM File | *.Cnf"
    OpenDialog.DialogTitle = "Save Datasource to File"
    OpenDialog.FileName = ""
    OpenDialog.DefaultExt = "*.txt"
    OpenDialog.CancelError = True
    OpenDialog.Flags = cdlOFNHideReadOnly 'Or cdlOFNOverwritePrompt 'we could just use this flag but I wanted to show how to handle the FILEEXISTS error.
    OpenDialog.ShowSave
    
    'Use MVC's save function
    McaDisplay.Save OpenDialog.FileName, False
    Exit Sub
    
ErrHdlr:
    If (Err.Number = cdlCancel) Then
        Exit Sub 'User clicked cancel on the dialog
    ElseIf (Err.Number = ERR_FILEEXISTS) Then
        'Ask if wants to overwrite
        If (vbYes = MsgBox("File Exists. Overwrite?", vbYesNo, gc_AppTitle)) Then
            McaDisplay.Save OpenDialog.FileName, True
        End If
    Else
        ProcessError
    End If
End Sub

'File Close
Private Sub mnuFileClose_Click()
    On Error GoTo ErrHdlr
    
    If (McaDisplay.NumberOfSources = 0) Then
        Exit Sub
    End If
    
    McaDisplay.Close
    CloseAdjust
    UpdateMenus
    Exit Sub
    
ErrHdlr:
    ProcessError
End Sub

'File Close All
Private Sub mnuFileCloseAll_Click()
    On Error GoTo ErrHdlr
    
    If (McaDisplay.NumberOfSources = 0) Then
        Exit Sub
    End If
    
    McaDisplay.CloseAll
    CloseAdjust
    UpdateMenus
    Exit Sub
    
ErrHdlr:
    ProcessError
End Sub

'File Print
Private Sub mnuFilePrint_Click()
    On Error GoTo ErrHdlr
    
    If (McaDisplay.NumberOfSources = 0) Then
        Exit Sub
    End If
    
    McaDisplay.PrintPlotDialog
    Exit Sub
    
ErrHdlr:
    ProcessError
End Sub

'File Copy
Private Sub mnuFileCopy_Click()
    On Error GoTo ErrHdlr
    
    If (McaDisplay.NumberOfSources = 0) Then
        Exit Sub
    End If
    
    McaDisplay.CopyToClipBoard
    Exit Sub
    
ErrHdlr:
    ProcessError
End Sub

'File Export
Private Sub mnuFileExport_Click()
    On Error GoTo ErrHdlr
    Dim strFile As String
    
    If (McaDisplay.NumberOfSources = 0) Then
        Exit Sub
    End If
    
    'Remove extension
    strFile = McaDisplay.CurrentDataSourceName
    If (McaDisplay.CurrentDataSourceType = SpectroscopyFile) Then
        Dim i As Integer
        i = InStr(1, strFile, ".")
        If (i > 0) Then
            strFile = Left(strFile, i - 1)
        End If
    End If
    strFile = strFile & ".txt"
    
    'Use the MS common dialog to get a filename
    OpenDialog.Filter = "Text Files | *.Txt"
    OpenDialog.DialogTitle = "Export Spectrum"
    OpenDialog.FileName = strFile
    OpenDialog.DefaultExt = "*.txt"
    OpenDialog.CancelError = True
    OpenDialog.Flags = cdlOFNHideReadOnly Or cdlOFNOverwritePrompt
    OpenDialog.ShowSave
    
    McaDisplay.ExportData OpenDialog.FileName
    Exit Sub
    
ErrHdlr:
    If (Err.Number = cdlCancel) Then
        Exit Sub 'User clicked cancel on the dialog
    Else
        ProcessError
    End If
End Sub

'File Exit
Private Sub mnuFileExit_Click()
    Unload Me
End Sub

'Display Expand
Private Sub mnuDisplayExpand_Click()
    On Error GoTo ErrHdlr
    McaDisplay.ExpandMode = Not McaDisplay.ExpandMode
    UpdateMenus
    Exit Sub
    
ErrHdlr:
    ProcessError
End Sub

'Display Zoom
Private Sub mnuDisplayZoom_Click()
    On Error GoTo ErrHdlr
    McaDisplay.ActivateZoom = Not McaDisplay.ActivateZoom
    UpdateMenus
    Exit Sub
    
ErrHdlr:
    ProcessError
End Sub

'Zoom out
Private Sub mnuDisplayZoomOut_Click()
    On Error GoTo ErrHdlr
    McaDisplay.ZoomOut
    Exit Sub
    
ErrHdlr:
    ProcessError
End Sub

'Log Mode
Private Sub mnuDisplayLog_Click()
    On Error GoTo ErrHdlr
    McaDisplay.LinearScale = False
    m_stPrefs.Linear = False
    UpdateMenus
    Exit Sub
    
ErrHdlr:
    ProcessError
End Sub

'Linear Mode
Private Sub mnuDisplayLinear_Click()
    On Error GoTo ErrHdlr
    McaDisplay.LinearScale = True
    m_stPrefs.Linear = True
    UpdateMenus
    Exit Sub
    
ErrHdlr:
    ProcessError
End Sub

'Auto Scale
Private Sub mnuDisplayAutoScale_Click()
    On Error GoTo ErrHdlr
    McaDisplay.AutoScale = Not McaDisplay.AutoScale
    UpdateMenus
    Exit Sub
    
ErrHdlr:
    ProcessError
End Sub

' Next Roi
Private Sub mnuDisplayNextRoi_Click()
    On Error GoTo ErrHdlr
    McaDisplay.NextRoi
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Previous Roi
Private Sub mnuDisplayPreviousRoi_Click()
    On Error GoTo ErrHdlr
    McaDisplay.PreviousRoi
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'AddRoi
Private Sub mnuDisplayAddRoi_Click()
    On Error GoTo ErrHdlr
    McaDisplay.AddRoi
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Delete Roi
Private Sub mnuDisplayDeleteRoi_Click()
    On Error GoTo ErrHdlr
    McaDisplay.DeleteRoi
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Delete All Rois
Private Sub mnuDisplayClearAll_Click()
    On Error GoTo ErrHdlr
    McaDisplay.DeleteAllRois
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Load Rois
Private Sub mnuDisplayLoadRois_Click()
    On Error GoTo ErrHdlr
    
    'Use the MS common dialog to get a filename
    OpenDialog.Filter = "Roi Files|*.ROI|Cam Files|*.CNF"
    OpenDialog.DialogTitle = "Open Roi File"
    OpenDialog.DefaultExt = "*.ROI"
    OpenDialog.FileName = "*.ROI"
    OpenDialog.CancelError = True
    OpenDialog.Flags = cdlOFNHideReadOnly
    OpenDialog.ShowOpen
    
    If (vbYes = MsgBox("Would you like attempt to load Rois by Energy?", vbYesNo)) Then
        McaDisplay.LoadRois OpenDialog.FileName, True
    Else
        McaDisplay.LoadRois OpenDialog.FileName, True
    End If
    
    Exit Sub
ErrHdlr:
    If (Err.Number = cdlCancel) Then
        Exit Sub 'User clicked cancel on the dialog
    Else
        ProcessError
    End If
End Sub

'Store Rois
Private Sub mnuDisplayStoreRois_Click()
    On Error GoTo ErrHdlr
    
    'Use the MS common dialog to get a filename
    OpenDialog.Filter = "Roi Files|*.ROI|Cam Files|*.CNF"
    OpenDialog.DialogTitle = "Save Roi File"
    OpenDialog.DefaultExt = "*.ROI"
    OpenDialog.FileName = "*.ROI"
    OpenDialog.CancelError = True
    OpenDialog.Flags = cdlOFNHideReadOnly Or cdlOFNOverwritePrompt
    OpenDialog.ShowSave
    
    McaDisplay.SaveRois OpenDialog.FileName, True
    
    Exit Sub
ErrHdlr:
    If (Err.Number = cdlCancel) Then
        Exit Sub 'User clicked cancel on the dialog
    Else
        ProcessError
    End If
End Sub

'Next Nuclide
Private Sub mnuDisplayNextNuclide_Click()
    On Error GoTo ErrHdlr
    If (Not McaDisplay.ShowSpectralNuclideAnnotationsLines) Then Exit Sub
    McaDisplay.NextNuclide
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Next Nuclide line
Private Sub mnuDisplayNextNucline_Click()
    On Error GoTo ErrHdlr
    If (Not McaDisplay.ShowSpectralNuclideAnnotationsLines) Then Exit Sub
    McaDisplay.NextNuclideLine
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Prev Nuclide
Private Sub mnuDisplayPrevNuclide_Click()
    On Error GoTo ErrHdlr
    If (Not McaDisplay.ShowSpectralNuclideAnnotationsLines) Then Exit Sub
    McaDisplay.PreviousNuclide
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Prev Nuclide Line
Private Sub mnuDisplayPrevNucline_Click()
    On Error GoTo ErrHdlr
    If (Not McaDisplay.ShowSpectralNuclideAnnotationsLines) Then Exit Sub
    McaDisplay.PreviousNuclideLine
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Preferences
Private Sub mnuDisplayPreferences_Click()
    Dim frmPrefs As New FPreferences
    
    If (vbOK = frmPrefs.CreateForm(Me, m_stPrefs)) Then
        SetPrefs
        UpdateMenus
    End If
    
    Unload frmPrefs
End Sub

'Acquire Setup
Private Sub mnuMCAAcquireSetup_Click()
    Dim Dev As CanberraDeviceAccessLib.DeviceAccess
    Dim frmAcqSetup As FMcaSetup
    
    On Error GoTo ErrHdlr
    If (McaDisplay.CurrentDataSourceType <> SpectroscopyDetector) Then Exit Sub
    Set frmAcqSetup = New FMcaSetup
    Set Dev = McaDisplay.CurrentDataSource
    frmAcqSetup.CreateForm Me, Dev
    Set Dev = Nothing
    Unload frmAcqSetup
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Acquire Start
Private Sub mnuMCAAcquireStart_Click()
    Dim Dev As CanberraDeviceAccessLib.DeviceAccess
    
    On Error GoTo ErrHdlr
    If (McaDisplay.CurrentDataSourceType <> SpectroscopyDetector) Then Exit Sub
    Set Dev = McaDisplay.CurrentDataSource
    'You could also call McaDisplay.AcquireStart
    Dev.AcquireStart
    Set Dev = Nothing
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Acquire Status
Private Sub mnuMCAAcquireStatus_Click()
    Dim Dev As CanberraDeviceAccessLib.DeviceAccess
    Dim frmMcaWait As FMcaWait
    
    On Error GoTo ErrHdlr
    If (McaDisplay.CurrentDataSourceType <> SpectroscopyDetector) Then Exit Sub
    Set Dev = McaDisplay.CurrentDataSource
    Set frmMcaWait = New FMcaWait
    frmMcaWait.CreateForm Me, Dev
    Set Dev = Nothing
    Unload frmMcaWait
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Acquire Stop
Private Sub mnuMCAAcquireStop_Click()
    Dim Dev As CanberraDeviceAccessLib.DeviceAccess
    
    On Error GoTo ErrHdlr
    If (McaDisplay.CurrentDataSourceType <> SpectroscopyDetector) Then Exit Sub
    Set Dev = McaDisplay.CurrentDataSource
    'You could also call McaDisplay.AcquirePause
    Dev.AcquirePause
    Set Dev = Nothing
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'MCA Adjust
Private Sub mnuMCAAdjust_Click()
    Dim Dev As CanberraDeviceAccessLib.DeviceAccess
    On Error GoTo ErrHdlr
    
    If (McaDisplay.CurrentDataSourceType <> SpectroscopyDetector) Then Exit Sub
    
    'Use error trapping to test to see if valid
    m_frmAdjust.Visible = True
    'if last line executed without an error, then the
    ' object exists so just show it
    m_frmAdjust.SetFocus
    Exit Sub
    
FormNew:
    m_frmAdjust.Top = Me.Top + Me.Height - 200
    m_frmAdjust.Left = Me.Left
    Set Dev = McaDisplay.CurrentDataSource
    m_frmAdjust.CreateForm Me, Dev
    Set Dev = Nothing
    Exit Sub
    
ErrHdlr:
    If (Err.Number = 91) Then 'Object used without being set
        Set m_frmAdjust = New FAdjust
        Resume FormNew
    End If
    ProcessError
End Sub

'Clear Data
Private Sub mnuMCAClearData_Click()
    Dim Dev As CanberraDeviceAccessLib.DeviceAccess
    On Error GoTo ErrHdlr
    If (McaDisplay.CurrentDataSourceType <> SpectroscopyDetector) Then Exit Sub
    Set Dev = McaDisplay.CurrentDataSource
    'You could also call McaDisplay.Clear
    Dev.Clear
    Set Dev = Nothing
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Copy Report
Private Sub mnuAnalysisCopyReport_Click()
    On Error GoTo ErrHdlr
    ReportWin.CopyAll
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Copy Selected
Private Sub mnuAnalysisCopySelected_Click()
    On Error GoTo ErrHdlr
    ReportWin.Copy
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Print Report
Private Sub mnuAnalysisPrintReport_Click()
    On Error GoTo ErrHdlr
    'You could show the MS common print dlg and then pass in the
    'printer name to print out
    ReportWin.PrintOut
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Save Report
Private Sub mnuAnalysisSaveReport_Click()
    On Error GoTo ErrHdlr
    Dim strFile As String
    
    'Get a default file name
    strFile = "*"
    If (McaDisplay.NumberOfSources > 0) Then
        'Remove extension
        strFile = McaDisplay.CurrentDataSourceName
        If (McaDisplay.CurrentDataSourceType = SpectroscopyFile) Then
            Dim i As Integer
            i = InStr(1, strFile, ".")
            If (i > 0) Then
                strFile = Left(strFile, i - 1)
            End If
        End If
    End If
    strFile = strFile & ".rpt"
    
    'Use the MS common dialog to get a filename
    OpenDialog.Filter = "Text Report Files | *.rpt"
    OpenDialog.DialogTitle = "Save Report"
    OpenDialog.FileName = strFile
    OpenDialog.DefaultExt = "*.rpt"
    OpenDialog.CancelError = True
    OpenDialog.Flags = cdlOFNHideReadOnly Or cdlOFNOverwritePrompt
    OpenDialog.ShowSave
    
    ReportWin.SaveText OpenDialog.FileName, True
    Exit Sub
    
ErrHdlr:
    If (Err.Number = cdlCancel) Then
        Exit Sub 'User clicked cancel on the dialog
    Else
        ProcessError
    End If
End Sub

'Show Report
Private Sub mnuAnalysisShowReport_Click()
    m_bShowReport = Not m_bShowReport
    mnuAnalysisShowReport.Checked = m_bShowReport
    Form_Resize
End Sub


'Execute An Analysis Sequence
Private Sub mnuAnalysisExecute_Click()
    On Error GoTo ErrHdlr
    Dim Datasource As Object
    Dim strCurrentDir As String
    Dim strAsfFiles As String
    
    If (McaDisplay.NumberOfSources = 0) Then Exit Sub
        
    'Change current drive
    strCurrentDir = CurDir
    strAsfFiles = GetEnvironmentVar("ASEQFILES")
    ChDrive Left(strAsfFiles, 1)
    ChDir strAsfFiles
    
    'Use the MS common dialog to get a filename
    OpenDialog.Filter = "Sequence Files|*.ASF"
    OpenDialog.DialogTitle = "Open Sequence File"
    OpenDialog.DefaultExt = "*.ASF"
    OpenDialog.FileName = "*.ASF"
    OpenDialog.CancelError = True
    OpenDialog.Flags = cdlOFNHideReadOnly
    OpenDialog.ShowOpen
    
    Set Datasource = McaDisplay.CurrentDataSource
    m_SeqAnalyzer.Analyze Datasource, , OpenDialog.FileName, True, , , , , ReportWin
    Me.Caption = gc_AppTitle & " - [Analyzing]"
    
    'Restore current Dir
    ChDrive Left(strCurrentDir, 1)
    ChDir strCurrentDir
    
    Set Datasource = Nothing
    Exit Sub
ErrHdlr:
    If (Err.Number = 91) Then 'Need to create seq analyzer
        Set m_SeqAnalyzer = New CanberraSequenceAnalyzerLib.SequenceAnalyzer
        Resume
    End If
    If (Err.Number = cdlCancel) Then
        'Restore current Dir
        ChDrive Left(strCurrentDir, 1)
        ChDir strCurrentDir
        Exit Sub
    End If
    ProcessError
End Sub

'Execute Current Sequence
Private Sub mnuAnalysisExecuteCurrent_Click()
    On Error GoTo ErrHdlr
    Dim Datasource As Object
    
    If (McaDisplay.NumberOfSources = 0) Then Exit Sub
    
    Set Datasource = McaDisplay.CurrentDataSource
    m_SeqAnalyzer.Analyze Datasource, , , True, , , , , ReportWin
    Me.Caption = gc_AppTitle & " - [Analyzing]"
    
    Set Datasource = Nothing
    Exit Sub
ErrHdlr:
    If (Err.Number = 91) Then 'Need to create seq analyzer
        Set m_SeqAnalyzer = New CanberraSequenceAnalyzerLib.SequenceAnalyzer
        Resume
    End If
    ProcessError
End Sub

'Edit Analysis sequence
Private Sub mnuAnalysisEditSequence_Click()
    Dim frmEditSeq As FSequenceEditor
    Dim Datasource As Object
    
    On Error GoTo ErrHdlr
    If (McaDisplay.NumberOfSources = 0) Then Exit Sub
    
    'Create an editor
    Set Datasource = McaDisplay.CurrentDataSource
    Set frmEditSeq = New FSequenceEditor
    If (frmEditSeq.CreateForm(Me, Datasource) = vbOK) Then
        UpdateMenus
    End If
    
    'Clean up
    Set Datasource = Nothing
    Unload frmEditSeq
    Set frmEditSeq = Nothing
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Next Datasource
Private Sub mnuDatasourceNext_Click()
    On Error GoTo ErrHdlr
    CloseAdjust
    McaDisplay.NextSource
    UpdateMenus
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Previous Datasource
Private Sub mnuDatasourcePrevious_Click()
    On Error GoTo ErrHdlr
    CloseAdjust
    McaDisplay.PreviousSource
    UpdateMenus
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Show the calibrations screen
Private Sub mnuOptionsCalibrations_Click()
    Dim frmCalib As FCalibrations
    Dim Datasource As CanberraDataAccessLib.DataAccess
    
    On Error GoTo ErrHdlr
    If (McaDisplay.NumberOfSources = 0) Then Exit Sub
    If (McaDisplay.CurrentDataSourceType <> SpectroscopyFile) Then Exit Sub
    
    'Create
    Set Datasource = McaDisplay.CurrentDataSource
    Set frmCalib = New FCalibrations
    frmCalib.CreateForm Me, Datasource
    
    'Clean up
    Set Datasource = Nothing
    Unload frmCalib
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Execute CFED - an example of how to shell another application
Private Sub mnuOptionsCFED_Click()
    On Error GoTo ErrHdlr
    
    Dim strExe As String
    strExe = GetEnvironmentVar("EXEFILES") & "\CFED.EXE"
    'Disable myself during the execute
    Me.Enabled = False
    SyncShell strExe
    Me.Enabled = True
    Exit Sub
ErrHdlr:
    ProcessError
End Sub

'Sample Edit
Private Sub mnuOptionsSampleEdit_Click()
    Dim frmSample As FSampleEdit
    Dim Datasource As Object
    
    On Error GoTo ErrHdlr
    If (McaDisplay.NumberOfSources = 0) Then Exit Sub
    
    'Create
    Set Datasource = McaDisplay.CurrentDataSource
    Set frmSample = New FSampleEdit
    If (frmSample.CreateForm(Me, Datasource) = vbOK) Then
        UpdateMenus
    End If
    
    'Clean up
    Set Datasource = Nothing
    Unload frmSample
    Exit Sub
ErrHdlr:
    ProcessError
End Sub
