Attribute VB_Name = "MErrors"
'-------------------------------------------------------
'MErrors - Errors.Bas
'
'Purpose:
'   General Error handling defines, messages, and Macros
'
'Revision History:
'   May-24-1999      MAS     Created
'-------------------------------------------------------

'These are common component error codes
Public Const ERR_NONE = 0
Public Const ERR_CAMMISSING = &H8BE8805A    'Cam parameter not on file
Public Const ERR_BUSYBUTNEVER = &H8CE99EA2  'Detector is acquiring without being monitored
Public Const ERR_HDWUNAVAIL = &H80120008    'Detector is not available
Public Const ERR_OWNERMISMATCH = &H80130019 'Another owner has control of the detector
Public Const ERR_VERIFY = &H8CE99EA3        'Device setup does not match definition
Public Const ERR_VERIFYWARN = &H8CE99D36    'Device settings do not match definition
Public Const ERR_FILEEXISTS = &H8CE99DA0    'File already exists

Public Sub ProcessError()
    If (Err.Number <> 0) Then
        MsgBox Err.Description & " (" & Hex(Err.Number) & ")", vbOKOnly, gc_AppTitle
    End If
End Sub

