Attribute VB_Name = "MEnvironment"
'-------------------------------------------------------
'MEnvironment - Environment.bas
'
'Purpose:
'   Routines to set/get environment variables
'
'Revision History:
'   May-27-1999      MAS     Created
'-------------------------------------------------------
Option Explicit

'Call this function to set up the Genie2000 environment
Declare Function bG2KEnv Lib "G2K_VB" () As Integer

Declare Function bG2KSetEnv Lib "G2K_VB" _
    (ByVal lpName As String, ByVal lpBuffer As String) As Integer

Declare Function GetEnvironmentVariable _
    Lib "kernel32" Alias "GetEnvironmentVariableA" _
    (ByVal lpName As String, ByVal lpBuffer As String, _
    ByVal nSize As Long) As Long
    
'-------------------------------------------------------
'GetEnvironmentVar - Get an environment setting
'
'Arguments :
'   strName     String identifying enviroment setting("CAMFILES")
'
'Returns :
'   The environment setting
'-------------------------------------------------------
Public Function GetEnvironmentVar(strName As String) As String
    Dim strEnv As String
    Dim ret As Long
    
    strEnv = String$(255, Chr$(0))
    ret = GetEnvironmentVariable(strName, strEnv, 255)
    GetEnvironmentVar = SzFromStr(strEnv)
End Function
'-------------------------------------------------------
'SetEnvironmentVar - Set an environment setting
'
'Arguments :
'   strName     String identifying enviroment setting("CAMFILES")
'   strVal      The environment setting
'
'Returns :
'   True on success
'-------------------------------------------------------
Public Function SetEnvironmentVar(strName As String, strVal As String) As Boolean
    'Where strName = "CAMFILES" etc...
    SetEnvironmentVar = bG2KSetEnv(strName, strVal)
End Function
'-------------------------------------------------------
'SetGenieEnvironment - Setup the genie environment settings
'
'Arguments :
'   None
'
'Returns :
'   True on success
'-------------------------------------------------------
Public Function SetGenieEnvironment() As Boolean
    SetGenieEnvironment = bG2KEnv
End Function


