VERSION 5.00
Begin VB.Form FCalibrations 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "View Calibration"
   ClientHeight    =   4560
   ClientLeft      =   45
   ClientTop       =   240
   ClientWidth     =   6855
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4560
   ScaleWidth      =   6855
   StartUpPosition =   1  'CenterOwner
   Begin VB.CommandButton cmdOK 
      Caption         =   "OK"
      Height          =   495
      Left            =   2760
      TabIndex        =   1
      Top             =   3840
      Width           =   1335
   End
   Begin VB.ListBox EnergyList 
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   2160
      Left            =   120
      TabIndex        =   0
      Top             =   360
      Width           =   6615
   End
   Begin VB.Label lblLoTailCal 
      Height          =   255
      Left            =   120
      TabIndex        =   5
      Top             =   3360
      Width           =   6615
   End
   Begin VB.Label lblFWHMCal 
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   3000
      Width           =   6615
   End
   Begin VB.Label lblEnergyCal 
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   2640
      Width           =   6615
      WordWrap        =   -1  'True
   End
   Begin VB.Label Label1 
      Caption         =   " Channel     Energy      Uncert.     FWHM        Low Tail"
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   120
      Width           =   6495
   End
End
Attribute VB_Name = "FCalibrations"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'-------------------------------------------------------
'FCalibrations
'
'Purpose:
'   Dialog used to view the calibration information
'
'Public Members:
'   None
'
'Revision History:
'   May-24-1999      MAS     Created
'-------------------------------------------------------
Option Explicit
Private m_oDatasource As CanberraDataAccessLib.DataAccess
'----------------------------------------------------------
'CreateForm
'
'Arguments:
'   I   : Parent (parent form)
'   I   : Datasource to view calibrations on
'
'Returns:
'   vbMsgBoxResult  vbOK
'
'Purpose:
'   Start the Form and run to completion, return to the caller
'   success of operation
'----------------------------------------------------------
Public Function CreateForm(Parent As Form, Datasource As CanberraDataAccessLib.DataAccess) As Integer
    Dim i As Integer
    
    Set m_oDatasource = Datasource
    SetDatasource
    'Show myself and then return the users response
    Me.Show 1, Parent
    
    CreateForm = vbOK
End Function

Private Sub SetDatasource()
    Dim Vals1 As Variant
    Dim Vals2 As Variant
    Dim Vals3 As Variant
    Dim strFormat As String
    Dim i As Integer
    Dim j As Integer
    
    'This is just an example of how to use the calibrations property of
    ' DataAccess. This allows easy access to the calibration info. This
    ' could all be done for efficiency as well. It uses an error handling
    ' scheme to determine how large the arrays are. If a violation of the
    ' array size takes place the code caries through to the next
    ' calibration
    
    'Get the Calibrations
    On Error GoTo Done
    Vals1 = m_oDatasource.Calibrations.Energy.Points
    Vals2 = m_oDatasource.Calibrations.Fwhm.Points
    Vals3 = m_oDatasource.Calibrations.LowTail.Points
    
    'Add the points to the list box
    On Error GoTo DoneLoop
    i = 0
    While True
        strFormat = FixedStr(Str(Vals1(0, i)), 12)              'Channel
        strFormat = strFormat & FixedStr(Str(Vals1(1, i)), 12)  'Energy
        strFormat = strFormat & FixedStr(Str(Vals1(2, i)), 12)  'Uncertainty
        strFormat = strFormat & FixedStr(Str(Vals2(1, i)), 12)  'FWHM
        strFormat = strFormat & FixedStr(Str(Vals3(1, i)), 12)  'LowTail
        EnergyList.AddItem strFormat
        i = i + 1
    Wend
DoneLoop:

    ' get the Energy eq
    On Error GoTo DoneEnergy
    Vals1 = m_oDatasource.Calibrations.Energy.Curve
    strFormat = "Energy = "
    strFormat = strFormat & Str(Vals1(0)) & " keV"            'Offset
    If (Vals1(1) > 0) Then
        strFormat = strFormat & " + " & Str(Vals1(1)) & " *Ch" 'Slope
    End If
    If (Vals1(2) > 0) Then
        strFormat = strFormat & " + " & Str(Vals1(2)) & " *Ch^2" 'Quad
    End If
        
DoneEnergy:

    On Error GoTo DoneFWHM
    lblEnergyCal = strFormat
    
    'get the FWHM eq
    Vals2 = m_oDatasource.Calibrations.Fwhm.Curve
    strFormat = "FWHM= "
    strFormat = strFormat & Str(Vals2(0)) & " keV"            'Offset
    If (Vals1(1) > 0) Then
        strFormat = strFormat & " + " & Str(Vals2(1)) & " *E^1/2"
    End If
    
DoneFWHM:

    On Error GoTo DoneloTail
    lblFWHMCal = strFormat
    
    'get the LOTAIL eq
    Vals3 = m_oDatasource.Calibrations.LowTail.Curve
    strFormat = "Low Tail = "
    strFormat = strFormat & Str(Vals3(0)) & " keV"            'Offset
    If (Vals1(1) > 0) Then
        strFormat = strFormat & " + " & Str(Vals3(1)) & " *E"
    End If
    
DoneloTail:
    On Error GoTo Done
    lblLoTailCal = strFormat
    
Done:

    'You could make this into a calibration editor but currently
    ' we only allow setting the calibration points. Generating the
    ' curve must be done through our software, or by setting the
    ' appropriate CAM parameters individually.
    '
    'If you want to set the points here is an example of how
    ' Energy.Points would be set :
    '
    'Dim Vals As Single(0 to 2, 0 to 2) 'Chans, Energies, Uncert
    'Vals(0, 0) = 161
    'Vals(0, 1) = 245
    'Vals(0, 2) = 330
    'Vals(1, 0) = 88.04
    'Vals(1, 1) = 125.06
    'Vals(1, 2) = 165.08
    'Vals(2, 0) = 0.04
    'Vals(2, 1) = 0.05
    'Vals(2, 2) = 0.06
    'm_oDatasource.Calibrations.Energy.Points = Vals
    
End Sub

Private Sub cmdOK_Click()
    Me.Hide
End Sub

