// SM$:FO  F:\CANBERRA\GENIE\INCLUDE\UTILITY.H - 08/15/96 07:56:09
/* **************************< UTILITY.H >************************* *
 * Purpose:                                                         *
 *  Prototype the calls to common system-wide utility functions.    *
 *  The sources are in CIUTIL\COMMON; the individual prototypes     *
 *  will note the name of the particular source file; the source    *
 *  will document the arguments and return values.                  *
 * ---------------------------------------------------------------- *
 * History:                                                         *
 *  27-Dec-90, LES:  Utl prefix;  FILE_DSC.                         *
 *  21-Jan-91, LES:  Conditional compile of above; add CTimeCAM.    *
 *                   Also - prototype dUtlTimeNow().                *
 *  23-jan-91, dsr:  Added protos for CTimeSTR                      *
 *  24-Jan-91, LES:  Pointers are explicitly FAR, per agreement.    *
 *   6-may-91, dsr:  Added UtlGetCal, UtlRoi, UtlEval structs/protos*
 *  14-may-91, dsr:  fixed a bug in i'face to UtlEval               *
 *  17-Jun-91, rls:  Added rEn2Chan prototype                       *
 *  18-Jun-91, rls:  Added AefQuery prototype, struct. defn's, etc. *
 *  11-Sep-91, rls:  Added ulDoStrip, ulDoSmooth, dCnvtULtoD,       *
 *                   and ulCnvtDtoUL prototype                      *
 *  19-Sep-91, sew   Added ulUtlInitEneq prototype                  *
 *   4-Dec-91, sew   Added fPrintFile to prototype                  *
 *   3/23/92   dsr   made "portable"                                *
 *  10-Feb-93, ras   Added sCamInit to prototype                    *
 *   4-Mar-93, sew   IBMC Changes                                   *
 *  25-May-93, LES:  Add EFFUTIL pieces (conditional); & ulSadStat. *
 *  14-Dec-93, TLG:  Added SHIFT.C function prototypes.             *
 *  14-Jan-94, sew   Change AEF File Phase numbers.                 *
 *   8-apr-94, dsr   added vWtmean() prototype                      *
 *  14-jun-94  dsr   .add phase for reagent blank subtract          *
 *                   .add alpha avg efficiency capability           *
 *  30-Aug-94  sew   new CAM time conversion routines               *
 *  31-may-95  dsr   add lReport() function to utility              *
 *  15-Aug-95, LES:  Add the fMXEnvirons prototype.                 *
 *  15-Nov-95, LES:  Add the zUtlScanEnv prototype.                 *
 *  19-Mar-96, sew:  add conditionals for C++ support.              *
 * **************************************************************** */

//#if (defined(__IBMC__) || defined(__IBMCPP__))
// #define PASCAL_CALL _System                                             SM$:O
#define PASCAL_CALL WINAPI                                              // SM$:M1
                                                                        // SM$:C
#if (!(defined(__MIG__) || defined(__MIG_LIB__)))
#if (defined(__IBMC__) && (__IBMC__ <  200))
int _Optlink strcmpi (char * dst, char * src);
// char * _Optlink strnset (char * string, char val, unsigned int count);  SM$:O
char * _Optlink _tcsncset(char * string,char val,unsigned int count);   // SM$:M1
                                                                        // SM$:C
#endif
#endif
//#endif

#if __cplusplus
extern "C" {
#endif

/* -------------------------- USADSTAT.C -------------------------- */

// ULONG PASCAL_CALL            faramarz
ULONG ulSadStat( HMEM hDSC, short sRC );


/* -------------------------- DATETIME.C -------------------------- */

//BOOL  PASCAL_CALL             faramarz
BOOL fUtlIntoCAM_DT( ULONG ulDateTime, USHORT usWhich, double  * pdCAM );

//BOOL  PASCAL_CALL   faramarz
BOOL fUtlFromCAM_DT( double dCAM, USHORT usWhich, ULONG  * pulDateTime );


void vWtmean (double dXi[],  double dXUi[], int iN,
                     double *pdWtm, double *pdWtmU);

/* -------------------------- TIMENOW.C --------------------------- */

// double  PASCAL_CALL dUtlTimeNow( void ); faramarz
double  dUtlTimeNow( void );

//BOOL    PASCAL_CALL fUtlTimeNow( double  * pdNow );
BOOL  fUtlTimeNow( double  * pdNow );

/* -------------------------- CTIMECAM.C -------------------------- */

//#if defined (__time_h)
/* - NOTE -- <time.h> defines this; any code
*  that calls one of these => will include.
*/

// BOOL  PASCAL_CALL faramarz
BOOL fUtlCTimeToCAM( struct tm  * pstTime, double  * pdTime );

// BOOL  PASCAL_CALL faramarz
BOOL fUtlCAMToCTime( double dTime, struct tm  * pstTime );

// BOOL PASCAL_CALL faramarz
BOOL fUtlGMTime(double dTime, struct tm * pstTime);

// double PASCAL_CALL faramarz
double dUtlMKTime(struct tm * pstTime);

//#endif

/* -------------------------- STRIPFCT.C -------------------------- */

// ULONG PASCAL_CALL ulDoStrip( HMEM hInpDSC, HMEM hOutDSC, double dFactor);
ULONG  ulDoStrip( HMEM hInpDSC, HMEM hOutDSC, double dFactor);

// double PASCAL_CALL dCnvtULtoD( ULONG ulW);
double dCnvtULtoD( ULONG ulW);

// ULONG PASCAL_CALL ulCnvtDtoUL( double ulW);
ULONG  ulCnvtDtoUL( double ulW);


/* -------------------------- SMTHFCT.C -------------------------- */

// ULONG PASCAL_CALL ulDoSmooth( HMEM hInpDSC, USHORT usPts);
ULONG  ulDoSmooth( HMEM hInpDSC, USHORT usPts);



/* -------------------------- CTIMESTR.C -------------------------- */


// FLAG PASCAL_CALL fUtlCAMToStr    (double          dTime,
FLAG              fUtlCAMToStr    (double          dTime,
                                    PSZ             pszDate,
                                    PSZ             pszTime);

// FLAG PASCAL_CALL fUtlCAMToString (double          dTime,
FLAG             fUtlCAMToString (double          dTime,
                                    PSZ             pszDate,
                                    PSZ             pszTime,
                                    BOOL            fCentury);

// FLAG PASCAL_CALL fUtlStrToCAM    (PSZ             pszDate,
FLAG             fUtlStrToCAM    (PSZ             pszDate,
                                    PSZ             pszTime,
                                    double          *pdTime,
                                    PSZ             pszFmt);

// FLAG PASCAL_CALL fUtlStringToCAM (PSZ             pszDate,
FLAG             fUtlStringToCAM (PSZ             pszDate,
                                    PSZ             pszTime,
                                    double          *pdTime,
                                    PSZ             pszFmt,
                                    FLAG            fFourDig);

/* -------------------------- FILE_DSC.C -------------------------- */

// int  PASCAL_CALL
int iUtlCreateFileDSC( HMEM  * phDSC, BOOL fAdvise, HWND hAdvise );
int iUtlCreateFileDSC2( HMEM  * phDSC, BOOL fAdvise, HWND hAdvise );

/* --------------- GETCAL.C  ROI.C  EVAL.C -------------------- */

#if __cplusplus
}
#endif


    /*------------------------ */
    /* Generic equation struct */
    /*------------------------ */
    typedef struct stEncalEq_S {

        USHORT          usType;
        ULONG           ulNofC;
        REAL            rCoeff[6];
        REAL            rLowBound;
        FLAG            fLowBound;
    
        } stEncalEq_T;

    /*------------------------ */
    /* All energy calibrations */
    /*------------------------ */
    typedef struct stEncalEqs_S {

        stEncalEq_T     stENeq;
        stEncalEq_T     stFWeq;
        stEncalEq_T     stLTeq;
        stEncalEq_T     stHTeq;

        } stEncalEqs_T;

    /*----------------- */
    /* encal - which eq */
    /*----------------- */
#define ENW_ENCAL   1
#define ENW_FWHM    2
#define ENW_T1      3
#define ENW_T2      4

    /*-------------- */
    /* encal eq type */
    /*-------------- */
#define EN_NONE     0
#define EN_POLY     1
#define EN_SQRT     2

    /*------------ */
    /* error codes */
    /*------------ */
#define UtlRoiBadLimits         0x00600001L /* roi can't include ch, etc.*/

#define UtlRoiInsufMem          0x00640001L /* insuf mem (malloc, etc.)  */

    /*-------------------- */
    /* Function Prototypes */
    /*-------------------- */

#if __cplusplus
extern "C" {
#endif

    ULONG      ulUtlGetEneq   (HMEM            hdsc,
                             USHORT          usWhich,
                             USHORT          usAdc,
                             stEncalEq_T      *pstEq);
    ULONG      ulUtlPutEneq   (HMEM            hdsc,
                               USHORT          usWhich,
                               USHORT          usAdc,
                               stEncalEq_T      *pstEq);
    ULONG      ulUtlInitEneq  (HMEM            hdsc,
                               USHORT          usAdc);
    ULONG      ulUtlRoi       (HMEM            hdsc,
                               FLAG            fUseCal,
                               ULONG           ulCh,
                               REAL            rEn,
                               ULONG            *pulLo,
                               ULONG            *pulHi);
    REAL        rUtlEval       (stEncalEq_T      *pstEq,
                                REAL            rVal);
    REAL        rEn2Chan       (REAL            rEnergy,
                                stEncalEq_T      *pstEnEq);

#if __cplusplus
}
#endif

/* --------------------------- EFFUTIL.c --------------------------- */
/*
 * - NOTE, May-93 - Some of this duplicates bits of COMDEFS.h.
 *  (There is no necessary ! connection, but the functions prototyped
 *  here do pretty much duplicate those in ANA\COMMON.)
 * - Note that <get_put.h> is required - for the (sub-)structs.
 */

#if defined (_EFFUTIL_)

#define MAX_EFPTS        45

/* ---------------------- */

typedef struct stEfAvg_S {    /* alpha avg efficiency structure */
    REAL        rAvgEff;
    REAL        rAvgEffU;
    } stEfAvg_T;

typedef struct stEfEq_S {     /* generic efcal equation structure */

    USHORT      usType;

    union {
        stEfDual_T   stDual;
        stEfEmp_T    stEmp;
        stEfLinear_T stLin;
        stEfAvg_T    stAvg;
        } u;

    } stEfEq_T;

#define EF_NONE     0  /* efcal equation type [dup of COMDEFS.h] */
#define EF_DUAL     1
#define EF_EMP      2
#define EF_LIN      3
#define EF_AVG      4
#define EF_INTERP   5

/* ---------------------- */

typedef struct {    /* the 'object' used to call the eval fns */

    stEfEq_T  stEqu;

    INT       iNPts;

    REAL      arEn [MAX_EFPTS];
    REAL      arEff[MAX_EFPTS];
    REAL      arVar[MAX_EFPTS];

    } EffEquObj_T;


/* ---------------------- */

#if __cplusplus
extern "C" {
#endif

ULONG
ulUtlGetEffObj (
    HMEM        hdsc,
    USHORT    usWhich, /* _DUAL, _EMP, _LIN, or _AVG. */
    USHORT      usAdc,
    EffEquObj_T  *pstObj );


REAL
rUtlEffic (
    EffEquObj_T  *pstObj,
    REAL      rEnergy     );


REAL
rUtlEffVar (
    EffEquObj_T  *pstObj,
    REAL      rEnergy,
    REAL      rEff );

#if __cplusplus
}
#endif

#endif

/* -------------------------- AEF Query --------------------------- */

#define PHASESIZE 24
#define DESCRIPTIONSIZE 24
#define ENGINESIZE 16
#define LOCATIONSIZE 64
#define RESOURCESIZE 64
#define REPORTSIZE 13 + 17 /*Filename +CAM_N_RPTSECTNAME*/

#define MAXLIST 1024
#define MAXLINE 256
#define OPEN_READ 1
#define OPEN_WRITE 0

/*---------------------- */
/* aef phase type codes */
/*---------------------- */
#define AEFPHTYPE_ACQ          10
#define AEFPHTYPE_PLOC         20
#define AEFPHTYPE_PAREA        30
#define AEFPHTYPE_IPF          35
#define AEFPHTYPE_AREAC        40
#define AEFPHTYPE_ARREAG       45
#define AEFPHTYPE_EFFC         50
#define AEFPHTYPE_ATTNC        60
#define AEFPHTYPE_NID          70
#define AEFPHTYPE_ACTC         80
#define AEFPHTYPE_MDA          90
#define AEFPHTYPE_RPT          100


/*---------------------- */
/* aef engine type codes */
/*---------------------- */
#define AEFTYP_Common       1
#define AEFTYP_Sequence     2
#define AEFTYP_Report       3


/*
 -----------------------
 - Possible return codes
 -----------------------
*/

#define AEF_NULL_FILE     10000
#define AEF_NULL_DATA     10001
#define AEF_CANT_OPEN     10002
#define AEF_MALLOC_ERROR  10003
#define AEF_FSEEK_ERROR   10004
#define AEF_FTELL_ERROR   10005
#define AEF_TOO_SMALL     10006
#define AEF_NOMATCH       10007



typedef struct stAef_S {

    CHAR Phase[PHASESIZE+1];            /* name of the analysis phase */
    BYTE PhaseType;                     /* phase type: code defined above */
    CHAR Description[DESCRIPTIONSIZE+1];/* descriptive name for the engine */
    CHAR Engine[ENGINESIZE+1];          /* lanugage independent name */
    BYTE Type;                          /* engine type: codes defined above */
    CHAR Location[LOCATIONSIZE+1];      /* engine location (DLL!SUBNAME) */
    CHAR Resource[RESOURCESIZE+1];      /* resource (DLL!IDLG_ID!ENTRYPOINT) */
    CHAR Report[REPORTSIZE+1];          /* report template */

    } stAef_T;


/*
 ------------
 - Prototypes
 ------------
*/
#if __cplusplus
extern "C" {
#endif

USHORT AefQuery(CHAR *szFilename, stAef_T *Data, CHAR *szBuffer, USHORT *pusMaxLen);

/* -------------------------- PRNTFILE.C -------------------------- */

BOOL  fPrintFile(PSZ pszRptFile);


/* -------------------------- LREPORT.C -------------------------- */

LONG              lUtlReport (HMEM        hdsc,
                            CHAR        *pszRptTpl,
                            CHAR        *pszSect,
                            REAL        rSigma,
                            FLAG        fPrinter,
                            FLAG        fDelete,
                            LONG        *plRC2);


/* -------------------------- CAMINIT.C --------------------------- */

SHORT sCamInit (HMEM hDSC, USHORT usNofChans);


/* --------------------------- SHIFT.C ---------------------------- */

ULONG ulUtlShiftDatasource (HMEM, HMEM, HMEM, ULONG);
void  vUtlShift (stEncalEq_T *, REAL *, LONG, stEncalEq_T *, REAL *, LONG);


/* ------------------------- MIXEDENV.C --------------------------- */

int fMXEnvirons( void );


/* --------------------------- GETENV.C --------------------------- */

char * zUtlScanEnv( char * );

/* --------------------------PARSECMD.C ---------------------------- */

LPSTR* paszParseCommandLine(char * , INT *argc);
void vFreeArgv(INT argc, char **argv);

/* --------------------------G2KENVMT.C ---------------------------- */

void vG2KEnv( void );

#if __cplusplus
}
#endif

/* *************************** E-O-F ****************************** */
