/* *****************************< SPASST.H >***************************** */
/* Editor:  L.Stone                 Origin: 19-Jun-90                     */
/* ---------------------------------------------------------------------- */
/* Purpose:                                                               */
/*  Contain any 'system wide' constants and definitions - intended to be  */
/*  #included with <cistd.h>, which is after <os2.h> (or <cios2.h>).      */
/*  (That is - there will certainly be platform-dependent pieces here.    */
/*  This is specific to OS/2; we expect VMS, UNIX, DOS, to be different.  */
/* ---------------------------------------------------------------------- */
/* History:                                                               */
/*  19-Jun-90, LES:  Bring in HMEM from VDM.H and IPC.H.                  */
/*                   Merge with VDM$ERR.H - certainly 'system wide'.      */
/*  ..-Jun-90, DSR:  Define an application-level ESO.                     */
/*  07-Jul-90, LES:  Bring in (the rest of) VDM.H.                        */
/*  16-Aug-90, LES:  Name a 'class' for CAM (it has its own e-codes).     */
/* (26-Sep-90, RAS: -- Did some edits get lost ...)                       */
/*  09-Nov-90, LES:  Bring in the ACC_xxx bit definitions.                */
/*  24-Nov-90, LES:  Add an error 'class' - ECL_CRT.                      */
/*  15-Jan-91, LES:  Change the Open/Close access bits - more like CAM.   */
/*  25-Mar-91, LES:  Add MAX_FileMID.                                     */
/*  08-May-91, LES:  Add ACC_TakeOver;  move the ACX_ bits to SAD_VDM.    */
/*   3/23/92   dsr   made "portable"                                      */
/*  12-Apr-93, RJH:  Add AioXXXX flags                                    */
/*  10-Nov-95, LES:  Copy ACC_Direct from <sadlocal>                      */
/* ********************************************************************** */

#if (defined(VMS) || defined(RISC) || defined(ultrix) || defined(mips))
#if !defined(HMEM) 
#define HMEM  SEL
/*#define HMEM  USHORT           Redefined in crackers as a void */
#endif
#endif
    /* 'Handle to' a block of memory from DosAllocSeg. */

/* ************************************************************************ *
 *  -- The bits of an fsAccess parameter -- Used to Open a datasource.      *
 * ************************************************************************ */

#define ACC_ReadOnly    0
#define ACC_ReadWrite   1
#define ACC_Exclusive   2
#define ACC_SysWrite    4
#define ACC_AppWrite    8
                /* Allow 'shared' read/write - under 'special circumstances' */
        /* (The names come from CAM.) */
#define ACC_Continue    16
#define ACC_TakeControl 32
                /* Force 'take control', if busy. */
        /* Memo on "BBNO", LES to RLS, 13-Feb-91. */
#define ACC_TakeOver    64
                /* Takeover ownership of the AIM. */
#define ACC_Direct     128
                /* Request that the open be 'direct-to-CAM'. */

/* Define more flags for AIO routines */

#define AIO_CLOSE_NoUpdate 1    /* AioClose2: Don't flush the datasource */
#define AIO_CLOSE_Delete 2  /* AioClose2: delete the file */
#define AIO_CREATE_NoPHAData 1  /* AioCreate: don't create PHA block using info from default file */
#define AIO_SPEC_CVTF 1     /* AioReadSpectrum2: return data in float */
#define DIRECT_ACCESS_EV "DIRECT2CAM"

/* ********************************************************************** *
 * Author: L.Stone                  Origin: 19-Jan-90 *
 * ---------------------------------------------------------------------- *
 * Purpose:                               *
 *  Name the classes and sources of error codes to be used throughout     *
 *  the SpAsst system - based on an RLS memo of 22-Jan-90.        *
 * ---------------------------------------------------------------------- *
 * Notes:                                 *
 *  The intent is that, at the application level, the code will see an    *
 *  unsigned long (ULONG) result code which is normally 0, meaning OK.    *
 *  If not - its high-order 16 bits reflect the source of the error and   *
 *  a class-code, as described below.  Its low-order 16 bits will have    *
 *  meaning specific to the source and class.                 *
 *                                    *
 *  That is - a function within the VDM server may return an error to     *
 *  the client whose value is :                       *
 *    MAKEULONG( usRC, ESO_Server + ECL_OpSys )           *
 *  where usRC was the return code from a call to the operating system.   *
 *                                    *
 *  Not all Classes have meaning for every Source.  ECL_Hardware can      *
 *  come only from ESO_Protocol, for example.                 *
 * ********************************************************************** */

/* ******************************************** *
 *  Source - At what level, within the VDM,     *
 *           where the error first recognized.  *
 * ******************************************** */

#define ESO_Protocol    0x10
#define ESO_Driver  0x20
#define ESO_Server  0x30
#define ESO_IPC     0x40
#define ESO_Client      0x50
#define ESO_App         0x60


/* ********************************** *
 *  Class - What sort of function     *
 *          detected the error.       *
 * ********************************** */

#define ECL_None    0
    /*  Unclassified.  Used when the error itself is sufficient. */

#define ECL_Command 1
    /*  A function saw a command that could not be handled (now). */
    /*  The low-order word will have a 'reason' code - Busy, etc. */

#define ECL_Hardware    2
    /*  The protocol driver was unable to complete the function - */
    /*  MCA in incompatible mode, perhaps. */

#define ECL_Comm    3
    /*  An error recognized at the I/O level - parity, etc. */

#define ECL_OpSys   4
    /*  A request to OS/2 - for memory, perhaps - failed. */

#define ECL_Environs    5
    /*  A necessary environment variable was missing. */

#define ECL_Conversion  6
    /*  This can come only from IPC.  Its data conversion for a message   */
    /*  can see an error, and the value of that error (overflow, perhaps) */
    /*  will be in the low-order word. */

#define ECL_CAM     7
    /*  CAM has its own set of error codes (CAMMSGS.H).  We will need */
    /*  this to (be certain we can) differentiate them from 'FDR'.    */

#define ECL_CRT     8
    /*  CRT for 'C' runtime.  See a note in VDM3\BITS\BILDPATH. */


/* ************************************************************************ *
 * Author: L.Stone                    Origin: 22-Jan-90 *
 * ------------------------------------------------------------------------ *
 * Notes:                                   *
 * - FileName and FileRoot have no meaning in HPFS --               *
 * - The C-library has equivalents -- but they don't allow for HPFS --      *
 * - The MID Editor has its own - because its (possibly remote) files must  *
 *  be restricted to FAT, we think.                     *
 * ************************************************************************ */

#if (defined(VMS) || defined(RISC) || defined(ultrix) || defined(mips))
#define MAX_PathName	256
#else
#define MAX_PathName    128
#endif
#define MAX_P   MAX_PathName
    /*  Maximum path length, OS/2 V1.1. */
    /*  Also the max "fully-qualified" file name ? */

#define MAX_FileName    13
#define MAX_F    MAX_FileName

#define MAX_FileRoot    9
#define MAX_X     MAX_FileRoot
    /*  For 'front of' file-name (some files have fixed extensions). */

#define MAX_UserName    16
#define MAX_U     MAX_UserName

#define MAX_FileMID 9
    /*  Files accessed by the MID editor -- (*.DRD, *.MID etc.) */
    /*  a) All have fixed paths\extensions;  b) Assume FAT. */
#define MAX_SAPID 20  /* */

/* **************************** End of File ***************************** */
