/* *************************** SAD_RC.H ******************************* *
 * Author:  L.Stone                   Origin: 10-Apr-90 *
 * -------------------------------------------------------------------- *
 * Purpose:                             *
 *  Define the (direct) return codes, and the client-level error codes. *
 * -------------------------------------------------------------------- *
 * History:                                                             *
 *   3/31/92   dsr   extracted rc definitions from SAD.H        *
 *  29-Jun-92, LES:  Added _UpAgainst, for the new Get\Puts.        *
 * ******************************************************************** */

#define CSI_Okay    0
#define CSI_Verify  1
    /* Used as a 'warning' from OpenDataSource -- look at props. */
#define CSI_End     2
    /* To be used as 'end-of-list', for enum-nodes, enum-files. */

#define CSI_Error   -1
#define CSI_NoDSC   -2

#define CSI_NotYet  -999

#define CSI_Source  3
#define CSI_Target  4
    /* These have meaning only for SadSaveAs and ClassCopy. */


/* ---- Indirect codes - obtained from a call to GetStatus - the */
/*  low-word of the 32-bit error code when hi-word is ESO_Client. */
/* --   Most of these are very much unexpected in a running system. */

#define CSI_WrongState  -3
#define CSI_Unsupported -4
#define CSI_ShortResp   -5
#define CSI_LongResp    -6
    /* (Can ReadMore -- IF expecting.) */
    /* (Must 'flush', however, if any intent to continue.) */
#define CSI_Memory  -7
    /* (An 'alloc' failure.) */
#define CSI_Unexpected  -8
#define CSI_DenyAccess  -9
    /* The required 'property' isn't there. */
#define CSI_Syntax  -10
    /* The Name in the call to FirstMember has no '[' (or N==0). */
#define CSI_OwnNode -11
    /* CreateDSC couldn't find own node name. */
#define CSI_BadParam    -12
#define CSI_UpAgainst   -13
    /* - some system limit, that is unexpected. */

/* *************************** End of File **************************** */
