/* ****************************** SAD_NEST.H ****************************** *
 * Author: L.Stone                                        Origin: 12-Oct-90 *
 * ------------------------------------------------------------------------ *
 * Purpose:                                                                 *
 *  Describe a few of the structures used by / for the calls to SAD --      *
 *  (the ones whose types are explicit in the SAD.H prototypes) (which are  *
 *  the ones filled\received by the 'app').                                 *
 * ------------------------------------------------------------------------ *
 * History:                                                                 *
 *  05-Apr-93, LES:  Add a DSC_FullName constant.                           *
 *  13-May-94, LES:  Add the InfoICB_T structure.                           *
 *  08-Jul-94, LES:  No //'s -- (ND is porting the report engine).          *
 *  02-Jan-95, LES:  Support SadMultipleROI().                              *
 *  28-Mar-95, DRD:  SadListFiles structure                                 *
 *  26-Oct-95, LES:  Three CTL_ opcodes for (possible) s-changer updates.   *
 *  15-Nov-95, LES:  No //'s -- see 8-Jul-94.                               *
 *  16-Apr-97, LES:  New member of FetchFrom_T, with query op-code.         *
 *  21-Jan-98, LES:  Support for NewAIM.                                    *
 * ************************************************************************ */

#if defined (SAD_INCLUDED)
#else
#define SAD_INCLUDED

#ifdef WIN32
#include <com_vdm.h>                   /* common def'ns for Sad & Mid */
#endif

/* &&&&&&&&&&&&&&&&&&&&&&&& Constants &&&&&&&&&&&&&&&&&&&&&&&&&&&& */

/* -------------------------------
 *  Possible bits in flAdvise in SadAdviseOf
 *  (The caller wishes to be notified of event -- on this input.)
 *  Note, Feb-91 -- Assign 'top down', assuming that the bits
 *  being added to CAM will be 'bottom up'.
 */

#define ADV_AcquireEnd    0x80000000L
    /*  Collect-Done on this input. */

#define ADV_ChangerSet    0x40000000L
    /*  After a sample-changer command - when the changer is ready. */

#define ADV_OtherOpen     0x20000000L
    /*  Another user has opened this input for Control.   */
    /*  (And \ Or) It was verified and may have changed.  */

#define ADV_HdwChange     0x10000000L
    /*  The status-checker saw Failure | Reset from a device. */

#define ADV_AcquireStart  0x08000000L

#define ADV_DataChanged   0x04000000L
    /*  Set by the Clear command and by PutSpectrum. */

#define ADV_SuspectEcal   0x02000000L
    /*  (Feb-92 - Not used.) */

#define ADV_DevRequest    0x01000000L
    /*  The hdw-checker saw a 'service request' from a device. */

#define ADV_DevUpdated    0x00800000L
    /*  The hdw-checker updated the file from a device. */

#define ADV_Advanced      0x00400000L
    /* Someone (else) advanced the sample-changer. */

#define ADV_HdwError      0x00200000L
    /* The status-checker failed to communicate with the device. */

#define ADV_ExtEvent      0x00100000L
    /* The detector saw the external-start. */

/* -------------------------------
 *  9-Feb-91, The ones from CAM, per RLS memo.
 *  They are set by any PutParam to a parameter of that 'class'.
 */

#define ADV_DISPLAY     1
#define ADV_ACQUIRE     2
#define ADV_CALIB       4
#define ADV_ANALYSIS    8
#define ADV_SAMPLE      16
#define ADV_EXTEVENT    32

#define WM_ADVICEMSG    WM_USER + 1
/* --------------------------------
 *  The bits in flProps - returned to client by the open -
 *   - used by SAD to verify (some of) the calls to it 'sooner';
 *   - available to the app via a call to QueryDSC (below).
 */
#define PRP_Counter         1
#define PRP_NotVerified     2
#define PRP_ReadAccess      4
#define PRP_WriteAccess     8
#define PRP_Control         16
#define PRP_NativeFile      32
#define PRP_Fraction        64
#define PRP_Hardware        128
#define PRP_VfyFatal        256
#define PRP_VfyMajor        512
#define PRP_VfyMinor        1024
#define PRP_NoSpectrum      2048
#define PRP_InputOfMXR      4096
#define PRP_NewAIM        0x2000
#define PRP_NewAIM_2      0x4000
    /* That is: 2nd ADC on. */
#define PRP_DesktopDSP    0x8000
    /* 2nd 'ADC' on DSA is: MCS. */

/* ---------------------------------
 *  The 'op-codes' used in the call to ControlDSC.
 */
#define CTL_StartAcq    1
#define CTL_AbortAcq    2
#define CTL_StopAcq     3
#define CTL_BumpChanger 4
#define CTL_ClearData   5
#define CTL_PowerReset  6
#define CTL_ReVerify    7
#define CTL_ChangerHome 8
#define CTL_ChangerLoad 9
#define CTL_ChangerUnld 10

#define CTL_PassThru    100
#define CTL_Specials    256

/* ---------------------------------
 * - Additional op-codes - same message used for 'specials'.
 *  (The device-drivers' 'transparent' ones will be > 100
 *   and < 256 - as defined in DRIVER.H.)
 */
#define CTL_FileFlush   256
#define CTL_AckRequest  257
#define CTL_ClearDone   258
#define CTL_AcceptErr   259

#define CTL_PassToCAM   512
/*
** >= 0x2000 is PCAM's _crelvl -- used to create or empty! a block.
** >= 0x1000 is PCAM's _dellvl -- & 0xfff is one of a few "levels".
*/

/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/*
 *  The 'parameter' argument to SadCalculate.
 *  (Also used - internally - by SadScaleData.)
 */

typedef
struct CalcParam_S {

         HMEM   hObject;    /* (Filled by Sad.)                         */
         USHORT usStart;    /*  First chan in 'ROI'.                    */
         USHORT usStop;     /*  Last "" "".                             */
         USHORT usBkgndChs; /*  N-Chans to set bkgd. (If 0 - no area.)  */
         float  rSigma;     /*  Sigma "at which %Error is quoted".      */

    } CalcParam_T;

/* ================================ */
/*
 * - The struct returned BY the call to SadCalculate.
 */

typedef
struct CalcValue_S {

         USHORT dum1, dum2;
         ULONG  dum3;
         double dIntegral;
         double dArea;
         float  rPeak;
         float  rFWHM;
         float  rFWTM;
         float  rAreaError;
         double dum7;
         USHORT dum8;
         float  rGRatio;

    } CalcValue_T;

/* ================================ */
/*
 * - The args to SadMultipleROI (for 'SoftMCS', today).
 *  (SRS limits to 10 ROIs; any need for more?)
 */

typedef
struct IntgParam_S {
    HMEM   hObject; /* (Filled by Sad.) */
    USHORT usCount;
    short  fsNetArea;   /* Bit-mapped - 1 per ROI. */
    USHORT ausStart[10];
    USHORT ausStop [10];
    } IntgParam_T;

typedef
struct IntgValue_S {
    double adValue[10];
    } IntgValue_T;

/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/*
 * The op-codes to SadQueryDSC, and the union of returns.
 */

#define DSC_ServerType  1
    /*  Returns a single char - 'B', 'F' or 'M' - the one from */
    /*  the .NCF file record used to LogIn to the VDM server.  */

#define DSC_Connection  2
    /*  Returns the IPC connection handle - so caller can do   */
    /*  IPC things directly. (Careful ! Bypasses handshaking.) */

#define DSC_Properties  3
    /*  Returns the 32-bit mask of 'things you can do to this DS'.    */
    /*  (See the PRP_ values, above.)                                 */

#define DSC_CurrentMem  4
    /*  Returns current MemberOF/MemGroup. */

#define DSC_CountMem    5
    /* Returns NofMembers/Groups. */

#define DSC_NameOfDS    6

#define DSC_FullName    7
    /* For use by V1.4 batch\MVC. */

#define DSC_WeighVDM    8
    /* Returns 0, 1, 2 for 'Heavy', 'Lite', Portable.  */
    /* That is: Standard, Standalone, InSpector.       */

#define DSC_AdvWindow   9
    /* The handle of the window passed to SadAdviseOf  */

/* ---------------------- */

typedef
union Fetched_U {

    char    chKind;     /* _ServerType.  */

    HMEM    hConnect;   /* _Connection.  */

    long    flProps;    /* _Properties.  */

    USHORT  usCurrent;  /* _CurrentMem.  */

    USHORT  usInputs;   /* _CountMem.    */

    BYTE    fbVDM;      /* _WeighVDM.    */

    char    szDSName[MAX_P];

    HWND    hWndAdvise; /* _AdvWindow.   */


    } FetchFrom_T;

/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/*
 *  The return from the call to QueryDevice - 0 <= OpCode <= 31
 */

typedef
struct { char szTrue[16];  char szFalse[16]; } TF_string_T;

/*
 * The (> 31) op-codes to SadQueryDevice; also see below.
 */

#define DV_Status   100
#define DV_AcqModes 101
    /* The reponse is a short; see the driver document. */

/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/*
 * The op-codes to SadQueryDataSource, and the union of returns.
 */

#define DSQ_Status      1
#define DSQ_Dirty       2
#define DSQ_VerifyRC    3

/* ---------------------- */

typedef union {

    struct {
        short  fsStatus;
        USHORT usBusyGrp;
        }  stDS;

    long    flDirty;

    ULONG   ulVfyRC;

    } DSQuery_T;


/* -------- The bits in stDS.fsStatus ------- */
#define DSS_XWait   1
#define DSS_Idle    2
#define DSS_Busy    4
#define DSS_Done    16
#define DSS_Update  32
/*
 *  If DSS_Busy and the datasource is multi-grp,
 *  stDS.usBusyGrp is the one that's acquiring.
 */

/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/*
 *  The return from the call to QueryInputDevices.
 *  ('Input' because - that's the 'common' term for a hdw DS = detector.)
 *  (It uses RQ_QueryDS with op-code == DSQ_Devices.)
 */

#define DSQ_Devices     0

typedef
struct InputQuery_S {

    struct {
        BYTE fbX;  BYTE bNof;
        long flBitRW; } astDevOf[16];

    } InputQuery_T;

/*
 *  The array is indexed by the DEV_xx constants;  the
 *  two BYTE values are what is returned from the call
 *  to the corresponding device driver (if this datasource
 *  has such a device). (See the driver document.)
 *  The 1-bit (bit #0) of .fbX means: There IS such a device
 *  but it is 'manual'; bit #1 (the 2-bit) means: That
 *  device is programmable.  If programmable, the other
 *  two values are defined:  bNof is 'tweakable' params;
 *  flBitRW is the OR of the read and write masks.
 * - 30-Jan-92, flBitRW will be 0 if VFY_Model or _HdwFail.
 */

/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/*
 *  The return from the call to QueryDevice - OpCode == DV_Status.
 *  (It uses RQ_QueryDS with op-code == DSQ_ThisDev + device.)
 */

#define DSQ_TrueBit 0x300
#define DSQ_ModeDev 0x200
#define DSQ_ThisDev 0x100

typedef
struct StatusQuery_S {

        long  flControls;
        long  flVerified;

        } StatusQuery_T;

/* -------- Bits in flControls -------
 */
#define CST_PwrReset    1
#define CST_HdwFail     8
#define CST_Request     16
#define VFY_Serial      0x100
#define VFY_Read        0x200
#define VFY_Write       0x400
#define VFY_Model       0x1000
#define VFY_Software    0x4000
#define VFY_HdwFail     0x8000

/* -- Feb-92, These are not used today. */
#define VFY_Owner       0x800
#define VFY_Hardware    0x2000

/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/*
 *  The argument to the call to SadQueryCAM.  The return
 *  is a structure described in CAMINFO.H.
 */

typedef
struct QueryCAM_S {

    char    szParamName[13];
    USHORT  usDevice;
    USHORT  usBitNumber;

    } QueryCAM_T;

/* ++++++++++++++++++ Get\Put ListCAM -- +++++++++++++++++++ */
/*
 * - The 'pstList' argument is a pointer to an array of 'usCount'
 *  structs of the following form:
 */
typedef
struct { ULONG   ulParam;
         USHORT  usSize;
         USHORT  usPCV;

         } ListOfCAM_T;
/*
 * - The 'ulParam' contains the CAM_ value for the intended parameter;
 *  'usPCV' is reserved for possible implementation of IPC translate.
 *
 * - If the usBytesPer argument is 0 -- then 'pvData' points to
 *  an array of pointers, each of whose members points to
 *  (usSize bytes of) the actual data to be sent \ received.  However --
 *
 * - IF -- the usBytesPer argument is 4 or 8 -- then the 'usSize'
 *  member of the list is ignored, and --
 * - The 'pvData' argument is a pointer to an array of structs of
 *  one of these two types. The caller has to know which of
 *  the union members to reference -- pvData[i].unValue.dX, for
 *  example, knowing that the corresponding CAM-param has the
 *  CAM_G_ prefix.
 * - If all requested params are CAM_L or CAM_F, the four-byte
 *  version can and should be used; if any are CAM_G or CAM_X,
 *  use the 8-byte option.
 * - For completeness reasons, xX is here for possible use in
 *  referencing CAM_X_ (time-stamp) values.
 */

union byte4_U { long lX;  float rX; };

union byte8_U { long   lX;   float  rX;
                double dX;   double xX; };

typedef struct {
    union byte4_U  unValue;
    } request4_T;

typedef struct {
    union byte8_U  unValue;
    } request8_T;

/* +++++++++++++++++++++ Get\Put Array +++++++++++++++++++++++++ */
/*
 * - The 'pstParam' arg to Get- and PutArray is the address of a
 *   struct of the ListOfCAM_T form, above.
 * - The 'fsFlags' argument can use (the OR of) any of the following
 *   bits:
 *    o  _Point means, the 'pvData' arg points to an array of
 *       pointers TO the data (each member of which is assumed to
 *       have length specified in the 'usSize' member of stParam).
 *       Otherwise, pvData points directly to an array OF the data.
 *    o  _Entry means, the values represent a set of 'tabular' entries
 *       (either record-tabular or common-tabular, in CAM terms).
 *       Otherwise, they represent a record-oriented parameter.
 */

#define GPA_Point   1
#define GPA_Entry   2

/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/*
 * - The 'usSearch' arg to FindRecord uses one of the following
 *  'op'-codes;  the 'pvObject' arg must be the type noted.
 *
 *      Op --          object          -- will find:
 *
 *   SEEK_History    dTimeStamp      a record in the _QARREC class with
 *                                   that date-time (or later).
 *
 *   SEEK_Nuclide    szNuclide[9]    a record in the _NUCL class with a
 *                                   name which is equal to or greater
 *                                   than szNuclide (the search rule is
 *                                   very specific and assumes AA-999x).
 *
 *   SEEK_Peak       OjEnergy_T      a record in the _PEAK class whose
 *                                   energy (in keV) is equal to or
 *                                   greater than rEnergy - or, within
 *                                   +\- rToler of it, if rToler is not 0.
 *
 *   SEEK_NucLine    OjEnergy_T      a record in the _NLINE class.
 */

typedef struct { float rEnergy; float rToler; } OjEnergy_T;

#define SEEK_Peak       1
#define SEEK_Nuclide    2
#define SEEK_History    3
#define SEEK_NucLine    4

/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/*
 * - Possible values for the 'sVFS' arg to SadScaleData.
 */

#define VFS_AutoLog 0x7A
#define VFS_AutoLin 0x7F

#define VFS_Log_218 32
#define VFS_Log_224 31
#define VFS_Log_232 30
/* ----
 * - the above are the three fixed log-base-two scales --
 *  they are used as: a scaled value of 2047 (vertical-full-
 *  scale) represents:
 *    a) 2 to the 18 = 256 K;
 *    b) 2 to the 24 = 16  M;
 *    c) 2 to the 32 = 4096M;
 *
 * - Other values are used as shift-count, to do linear
 *  scaling.  Negative values are shift RIGHT; positive are
 *  shift LEFT.  (Only the low-order 8 bits are used.)
 */

/* ++++++++++++++++++++++++++++++++++++++++++++++++
**
** - The arg to SadInfoICB
*/

typedef struct {

          BYTE  bModel;
          char  szSerial[10];

          }  InfoICB_T;

/* ++++++++++++++++++++++++++++++++++++++++++++++++
**
** - The response from SadLoadedMidFiles
*/

typedef struct SadMidListResp_S {
    FLAG   fNotAllReturned;      /* Set if buffer not big enough for all  */
    USHORT usNofFileNames;       /* # of file names returned              */
    CHAR   szFileName[9];        /* first file name                       */
/*
**  A variable # of file names are located after this.
*/
} SadMidListResp_T;

#endif

/* ***************************** E-O-F ******************************* */
