/* ***************************** SAD.H ******************************** *
 * Author:  L.Stone                                   Origin: 10-Apr-90 *
 * -------------------------------------------------------------------- *
 * Purpose:                                                             *
 *  Prototype the Spectroscopy Assistant Access to DataSource functions.*
 *  Also, #define the (direct) return codes, and the client-level error *
 *  codes.                                                              *
 * -------------------------------------------------------------------- *
 * History:                                                             *
 *  15-Apr-94, LES:  SadOpenICB() &c.                                   *
 *  16-Dec-94, LES:  Prototype 3 new calls.                             *
 *  16-Mar-95, DRD:  Prototype Sad calls for Loaded MID files           *
 *  14-Nov-95, DRD:  Change prototype for SadFirstInputOnMid and        *
 *                      SadNext...                                      *
 *  19-Mar-96, SEW:  Add conditionals for C++ support.                  *
 * ******************************************************************** */

/* ---- Structures and constants ---- */
#include <sad_nest.h>

/* ---- Direct return codes ---- */
#include <sad_rc.h>

#define SADENTRY  short WINAPI

/* ------------------------ */
#if __cplusplus
extern "C" {
#endif

#ifdef WIN32

SADENTRY SadCreateDSC( void * pstCfg, HMEM * phDSC,
                                      FLAG fAdv, HWND hWin );

SADENTRY SadCreateDSC2( void * pstCfg, HMEM * phDSC,
                                      FLAG fAdv, HWND hWin );

SADENTRY SadCloneDSC( HMEM hDSC, HMEM * phNew );

SADENTRY SadThreadDSC( HMEM hDSC, HMEM * phNew );

SADENTRY SadDeleteDSC( HMEM hDSC );

SADENTRY SadEnumNodes( HMEM hDSC, void * pstCfg, USHORT * pusN,
                                                     char chWho );

SADENTRY SadGetStatus( HMEM hDSC, ULONG * pulRC, short * psCli,
                                                 USHORT * pusAct );

SADENTRY SadOpenDataSource( HMEM hDSC, char * pszName,
                                 USHORT usType, short fsAccess,
                                 FLAG fVerify, char * pszShellID );

SADENTRY SadOpenICB( HMEM hDSC, char * pszName, USHORT usAddr,
                                short fsAccess, char * pszShellID );

SADENTRY SadGetSpectrum( HMEM hDSC, USHORT usStart, USHORT usCount,
                                 FLAG fFloat, void * pvData );

SADENTRY SadGetStruct( HMEM hDSC, USHORT usWhich,
                         USHORT usRecord, USHORT usEntry,
                         void * pvData, USHORT usSize );

SADENTRY SadGetNuclide( HMEM hDSC, USHORT usWhich,
                              USHORT usRecord, USHORT usEntry,
                              void * pstNucl,  USHORT usSize );

SADENTRY SadGetParam( HMEM hDSC, ULONG ulParam,
                              USHORT usRecord,   USHORT usEntry,
                              void * pvData, USHORT usExpect );

SADENTRY SadGetArray( HMEM hDSC, void * pstParam,
                         USHORT usRecord, USHORT usEntry,
                         void * pvData,  USHORT usCount, short fsFlags );

SADENTRY SadGetListCAM( HMEM hDSC,
                          USHORT usRecord,  USHORT usEntry,
                          USHORT usCount,   USHORT usBytesPer,
                          void * pstList,   void * pvData );

SADENTRY SadFindRecord( HMEM hDSC,  USHORT usSearch,
                          void * pvObject,   USHORT usStartAt,
                          USHORT * pusFound, FLAG * pfExact );

SADENTRY SadCopyRecord( HMEM hDSC, USHORT usClass,  USHORT usSrcR,
                            HMEM hTgt, USHORT usTgtR, FLAG fDelete );

SADENTRY SadCloseDataSource( HMEM hDSC );

SADENTRY SadCreateFile( HMEM hDSC, char * szFile, FLAG fEvenIf,
                          USHORT usFTy, USHORT usApp, USHORT usChans );

SADENTRY SadPutSpectrum( HMEM hDSC, USHORT usStart, USHORT usCount,
                                           void * pvData );

SADENTRY SadPutStruct( HMEM hDSC, USHORT usWhich,
                         USHORT usRecord, USHORT usEntry,
                         void * pvData, USHORT usSize );

SADENTRY SadPutListCAM( HMEM hDSC,
                          USHORT usRecord,  USHORT usEntry,
                          USHORT usCount,   USHORT usBytesPer,
                          void * pstList, void * pvData );

SADENTRY SadPutArray( HMEM hDSC, void * pstParam,
                         USHORT usRecord, USHORT usEntry,
                         void * pvData,  USHORT usCount, short fsFlags );

SADENTRY SadPutNuclide( HMEM hDSC, USHORT usWhich, USHORT usRecord,
                                    void * pvNucl, USHORT usSize,
                                    void * pvLines, USHORT usBytes );

SADENTRY SadPutParam( HMEM, ULONG, USHORT, USHORT, void *, USHORT );

SADENTRY SadClassCount( HMEM hDSC, USHORT usClass,
                                             USHORT * pusCount );

SADENTRY SadEntryCount( HMEM hDSC, ULONG ulParam, USHORT usRecord,
                                             USHORT * pusCount );

SADENTRY SadFirstInput( HMEM, FLAG, char * );
SADENTRY SadNextInput( HMEM, char * );
SADENTRY SadFirstInputOnMid( HMEM, char *, BYTE, USHORT, char * );      /* drd 11/14/95, 11/19/95 */
SADENTRY SadNextInputOnMid( HMEM, BYTE, USHORT, char * );               /* drd 11/19/95 */
SADENTRY SadLoadedMidFiles( HMEM, USHORT usMaxMidFiles, VOID * );       /* drd 3/16/95 */
SADENTRY SadQueryMidFile( HMEM, CHAR *, FileInfo_T * );                 /* drd 4/6/95  */

SADENTRY SadScaleData( HMEM, USHORT, USHORT, short, void * );
SADENTRY SadCalculate( HMEM, CalcParam_T *, CalcValue_T * );
SADENTRY SadMultipleROI( HMEM, IntgParam_T *, IntgValue_T * );

SADENTRY SadAdviseOf( HMEM, HWND, long, FLAG );
SADENTRY SadGetAdvise( HMEM, HWND *, long *, USHORT * );
SADENTRY SadControlDSC( HMEM, USHORT, USHORT );
SADENTRY SadSetCurrent( HMEM, USHORT, USHORT );

SADENTRY SadInsertOne( HMEM, USHORT, USHORT, USHORT );
SADENTRY SadDeleteOne( HMEM, USHORT, USHORT, USHORT );

SADENTRY SadQueryDSC( HMEM hDSC, USHORT usOp,
                                         FetchFrom_T * punRes );

SADENTRY SadQueryDataSource( HMEM hDSC, USHORT usOp,
                                           DSQuery_T * punRes );

SADENTRY SadQueryInputDevices( HMEM hDSC, InputQuery_T * pstRes );

SADENTRY SadQueryDevice( HMEM hDSC, USHORT usDev, USHORT usOpCode,
                                             void * pstRes );

SADENTRY SadQueryCAM( HMEM hDSC, QueryCAM_T * pstAsk,
                                             void * pstInfo );

SADENTRY SadQueryExCAM( ULONG ulParam, void * pstInfo );

SADENTRY SadQueryAdjust( HMEM hDSC, USHORT usDev, USHORT usCtl,
                                             void * pstRes );

SADENTRY SadFirstMember( HMEM hDSC, char * szCounter,
                                           char * acMember );

SADENTRY SadNextMember( HMEM hDSC, char * acMember );

SADENTRY SadFlush( HMEM hDSC );
SADENTRY SadReVerify( HMEM hDSC );
SADENTRY SadClearDone( HMEM hDSC );
SADENTRY SadAckRequest( HMEM hDSC, USHORT usDevice );
SADENTRY SadDeleteLevel( HMEM hDSC, USHORT usLevel );
SADENTRY SadAcceptOpenError( HMEM hDSC );

SADENTRY SadSaveAs( HMEM hSource, HMEM hTarget );
SADENTRY SadClassCopy( HMEM hSrc, HMEM hTgt, USHORT usClass );

SADENTRY SadInfoICB( HMEM hSrc, InfoICB_T * pst );
SADENTRY SadGetICB( HMEM hSrc, BYTE bRegister, BYTE * pbData );
SADENTRY SadPutICB( HMEM hSrc, BYTE bRegister, BYTE bData );

SADENTRY SadCreateBlock( HMEM hDSC, USHORT usClass, ULONG ulBytes,
                                                    long  flFlags );

SADENTRY SadReadUFBlock( HMEM hDSC, USHORT usClass, ULONG ulOffset,
               void * pvData, USHORT usBytes, long flags, USHORT * pusAct );

SADENTRY SadWriteUFBlock( HMEM hDSC, USHORT usClass,
                      void * pvData, USHORT usBytes, long flags );
#else
#define SADENTRY

SADENTRY SadQueryDSC( HMEM hDSC, USHORT usOp, FetchFrom_T * punRes );
SADENTRY SadQueryCAM( HMEM hDSC, QueryCAM_T * pstAsk, void * pstInfo );

SADENTRY SadGetArray( HMEM hDSC, void * pstParam,
                         USHORT usRecord, USHORT usEntry,
                         void * pvData,  USHORT usCount, short fsFlags );
SADENTRY SadPutArray( HMEM hDSC, void * pstParam,
                         USHORT usRecord, USHORT usEntry,
                         void * pvData,  USHORT usCount, short fsFlags );
SADENTRY SadGetStatus( HMEM hDSC, ULONG * pulRC, short * psCli, USHORT * pusAct );
#endif

#if __cplusplus
}
#endif

/* *************************** End of File **************************** */
