/*
* ==========================================================================
*
* Name:         ipc.h
* Date:         7/25/89
* Project:      ipc
* Author:       Don Reichler
* System:       OS/2 v1.1
* Compiler:     MSC v5.1
*
* Purpose:      This is the IPC include file for application use, along with
*               ipcproto.h.  They are for internal IPC use as well.
*
*               os2ipc.h is not needed by the applications (especially once
*               released !)
*
* Notes:
*
* Invocation:   #include <os2.h>
*               #include <cistd.h>
*               #include <ipc.h>
*               #include <os2ipc.h>     (for internal use only)
*               #include <ipcproto.h>
*               #include "myapp.h"
*
* Inputs:       none
*
* Outputs:      none
*
* Edits:        16-Jul-89 LES   Change typedef names to _T.
*                               Add #defines of msg-buf defaults.
*                               Use HPIPE and HMEM.
*                               Add IPC_NoAdvise and IPC_NoNode.
*               02-Aug-89 LES   Change struct & type names; add sem4.
*               04-Aug-89 LES   Add more (OS2) params to connection.
*                               (Some of) <os2.h> is now assumed.
*               08-Aug-89 LES   Closing/Closed states; rid of TID.
*                               Add state to ipcBuf, with #defines; e-code.
*                               Add IPC_MaxMsgSize, and place in ipcCon.
*               12-Aug-89 dsr   Added server stuff (ServerCon_T, Topic_T)
*               17-Aug-89 dsr   Added some more members to the above
*                         LES   _NoConnect is a state, BrokenCon is error.
*               23-Aug-89 LES   More ipcCon gadgets for new Thread code.
*               25-Aug-89 LES   Added an _Advise state (already an _Idle).
*               28-Aug-89 LES   ServerCon has fWaitMode and hBufCommand.
*               30-Aug-89 dsr   Added hDangleCon for dangling nowait con.
*                               Added #define of HM_NULL.  Deleted cmdFld.
*               06-Sep-89 dsr   Added ulS4LockConList to topic struct.
*               13-Sep-89 LES   IPC_Client.
*               14-Sep-89 dsr   Deleted fWait from topic and con structs.
*                               Added IPC_Active for RC from TermServer.
*               18-Sep-89 dsr   Added IPC_TermServer for RC.
*               11/09/89  dsr   reorganized what's where (ipc.h and os2ipc.h)
*                               changes to some structures per v1.4 gen'l SDD
*               14-Jun-91 LES   Cleanup (rid of externally-unused stuff).
* ==========================================================================
*/
#include <winsock.h>

/*
 ***********************
 * Structure definitions
 ***********************
*/


typedef struct config_S {           /* Config Info Structure        */

    BYTE    bSysType;               /* system type of node          */
    CHAR    chServerType;           /* server type code             */
    CHAR    szIpcName[512];         /* node and name of server      */
    CHAR    szNode[256];            /* node name                    */
    CHAR    szServer[256];          /* server name                  */

// Additions to support Win32 --
    WORD    wGarbage;
    SOCKADDR *zGarbage;
    UINT    uGarbage;
//
    CHAR    szComputerName[MAX_COMPUTERNAME_LENGTH+1];
                                /* IPC uses this in the GetHostByName.  */
    } ipcCfg_T;

//#define IPC_MaxMsgSize  16384       /* longest possible in OS/2 */
#define IPC_MaxMsgSize    32768       /* ? Apr-97, LES, Win32 -- */
/* --
** a) Win32 sockets may not have a limit.  However --
** b) The IPC 'buffer' code is checking USHORT values
**  against this number, so OneUp's 65535 had to be wrong --
** c) What code (outside of NUCLIB's "get every nuclide\line")
**  (which has other problems) will ever call for something
**  outside of the OS/2 limit, today?
*/


/*
 *****************************
 * IPC response & status codes
 *****************************
 */

#define IPC_Okay          0 /* Successful completion */
#define IPC_Error    0x8000 /* Sign (error) bit only */

#define IPC_AdviseAck     2
#define IPC_InProcess     3 /* BOF received by ServerStat.         */
#define IPC_MoreData      6 /* Message in buffer, but there's more.      */
#define IPC_Closed       10
#define IPC_NoConnect    11 /* No connection yet established.            */

#define IPC_DataErr      -1 /* Conversion error - data processed regardless. */
#define IPC_TimeOut      -2 /* Timeout during read, especially in wait mode. */
#define IPC_CommErr      -3 /* Miscellaneous communications error.           */
#define IPC_InsufMem     -4 /* Cannot allocate some structure.               */
#define IPC_NoServer     -5 /* Server/node combination doesn't exist.        */
#define IPC_OutOfRange   -6 /* Parameter not in valid range.                 */
#define IPC_NoData       -7 /* No data to get from message.                  */
#define IPC_NoMsg        -8 /* No message to get/cancel.                     */
#define IPC_InvHandle    -9 /* Invalid connection or buffer handle.          */
#define IPC_NoRoom      -10 /* No room to "grow" buffer within limits.       */
#define IPC_InvType     -11 /* Invalid IPC data type specified.              */
#define IPC_ConfigErr   -12 /* Config file not found or other config error.  */
#define IPC_Busy        -13 /* Message transaction already in progress.      */
#define IPC_OutOfCons   -14 /* Out of connections to present/accept.         */
#define IPC_NoAdvise    -15 /* Advise messages are disabled.                 */
                     /* -16    unused at this time                           */
#define IPC_BrokenCon   -17 /* No longer a connection.                       */
#define IPC_WrongState  -18 /* Can't accept message buffer - incomplete or.  */
#define IPC_SysError    -19 /* System error (e.g. can't dealloc memory)      */
#define IPC_NoResource  -20 /* Not enough system resources                   */
#define IPC_DupServer   -21 /* Server (topic) already exists                 */
#define IPC_ActiveCons  -22 /* Active connections (termserver can't term)    */
#define IPC_TermServer  -23 /* TermServer called (ServerStat || AcceptCon    */



/*
 ******************************
 * ClientStat Status Mask Codes
 ******************************
*/

#define IPC_MskSending   1      /* Note that only Recvd, Advise, MoreD,     */
#define IPC_MskSent      2      /* and MoreA are needed by the app.         */
#define IPC_MskRecvd     4      /* Sent and Sending aren't really needed,   */
#define IPC_MskMoreD     8      /* except by IPC internals                  */
#define IPC_MskAdvise   16
#define IPC_MskMoreA    32


/*
 ******************************
 * IpcPutField Field Type Codes
 ******************************
*/

#define IPC_TypBof       -1 /* Beginning-of-message field                */
#define IPC_TypEof       -2 /* End-of-message field                      */

#define IPC_TypChar       1 /* See data types in programming conventions */
#define IPC_TypByte       2 /*      "            "            "          */
#define IPC_TypShort      3 /*      "            "            "          */
#define IPC_TypUshort     4 /*      "            "            "          */
#define IPC_TypLong       5 /*      "            "            "          */
#define IPC_TypUlong      6 /*      "            "            "          */
#define IPC_TypFloat      7 /*      "            "            "          */
#define IPC_TypDouble     8 /*      "            "            "          */
#define IPC_TypBool       9 /*      "            "            "          */

                            /*        values must be consecutive         */
                            /*        IPC_TypChar < x < IPC_TypBool      */


/*
 **********************
 * Data Error Flag Bits
 **********************
*/

#define IPC_DataOver  1     /* DataFlags bit 0 - overflow   */
#define IPC_DataUnder 2     /* DataFlags bit 1 - underflow  */
#define IPC_DataInfin 4     /* DataFlags bit 2 - infinity   */
#define IPC_DataNan   8     /* DataFlags bit 3 - Not a Num  */
                            /* DataFlags bit 4-15 - unused  */


/* ************************** End of File **************************** */
