/* ***************************** GET_PUT.H **************************** *
 * -------------------------------------------------------------------- *
 * Purpose:                             *
 *  Contain the WST_ codes, and the structure definitions, to support   *
 *  the calls to SadGet/PutStruct.  Used by the 'app' AND file drivers. *
 * -------------------------------------------------------------------- *
 * Notes:                               *
 *  Should this USE the CAM_N.H constants !?                *
 * -------------------------------------------------------------------- *
 * History:                             *
 *  20-Jun-91, LES:  Change to PAResults_T.             *
 *  31-Jul-91, RAS:  Add Nuclide Library structures.            *
 *  01-Aug-91, LES:  Get rid of the old ^ versions -- obsolete.     *
 *  05-Aug-91, LES:  Split the NCLUnits struct (two classes).       *
 *  13-Aug-91, LES:  Updates to stEfDual; add stEfLinear.       *
 *  26-Aug-91, LES:  Further updates --.                *
 *  24-Oct-91, LES:  Include the needed 'new' params in CtfRec.     *
 *  29-Oct-91, LES:  Notes on GetNuclide; add DSR's 4 new lib- guys.    *
 *  05-Dec-91, LES:  Notes on PutNuclide.               *
 *  09-Dec-91, LES:  PSNid has an added member.             *
 *  24-Jan-92, LES:  Add five structs for REPORTer.         *
 *   3/23/92   dsr   made "portable"                    *
 *   9-Nov-92, RAS:  changed NCLUnits_S for NucLib SPR          *
 *  26-Jan-93, RAS:  add NCLMpcCF_S for MPC conversion factor       *           *
 * ******************************************************************** */

/* ------ Reserve these -- see GETNUKE.H -------
#define WST_Nuclide 1
#define WST_NuclideAnd  2
#define WST_NucLine 3
------------------------------------------------

** ------ Reserve these -- see PUTNUKE.H -------
#define WST_NuclNID 40
#define WST_AllMDA  41
#define WST_NuclMDA 42
#define WST_LineMDA 43
------------------------------------------------
*/

/* ++++++++++++++++++++++++++++++++ */
/*
 * - Each of these equations takes a record number - for the ADC.
 *   They are CLS_ACQP (!).
 */
#define WST_EcalOld 2
    /* (Used internally - by 'grandfather'.) */
#define WST_EcalEq  4

typedef
struct G_EcalEq_S {
    ULONG   ulNofC; /*  N-of-coeffs ==>. (0 is uncalibrated ?) */
    REAL    rCoeff[6];  /*  [0] Constant, [1] Linear, [2] Quadratic, [3] Cubic. */
    } G_EcalEq_T;

/* -- Units of E-Cal are keV (until I'm told otherwise). That is:
 *  we expect the driver [!?] to convert TO, if it's looking at other.
 */

/* -------------------------------- */

#define WST_FwhmEq  5
#define WST_FwhmQP     14

typedef
struct G_FwhmEq_S {
    REAL    rCoeff[3];
    } G_FwhmEq_T;
/*
 * - If FwhmEq is used - [1] is sqrt(E) and [2] is undefined.
 *   FwhmQP reads the (old ?) polynomial form.
 */
/* -------------------------------- */

#define WST_HiTail  6
#define WST_LoTail  7

typedef
struct G_TailEq_S {
    REAL    rCoeff[2];
    } G_TailEq_T;

/* ++++++++++++++++++++++++++++++++ */

#define WST_FcalEq  8
    /* Takes a record number - Geometry (== ADC). ( CLS_GEOM ) */

typedef
struct G_FcalEq_S {
    float   rFcalLo[3];
    float   rCrossOver; /* The energy (in keV) at which --. */
    float   rFcalHi[6];
    } G_FcalEq_T;
/* - Type is always polynomial (!?). */

/* -------------------------------- */

#define WST_Search  13
    /* The "Peak Search Results" 'common' block.  ( CLS_PEAK ) */
    /* (A flag bit will indicate: _PSDATE is 'locate' or 'analyze'.) */

typedef
struct G_CommonPS_S {
    ULONG   flFlagsPSR;         /* _PSFLAGS */

    double  dAnalyzeDate;       /* _PSDATE */

    char    szPLVers[17];       /* _PEAKVERS */
    char    szPAVers[17];       /* _PKANALVERS */
    } G_CommonPS_T;

/* -------------------------------- */

#define WST_PeakPS  9
    /* Takes a 'record number' - in CLS_PEAK. */
#define PST_PAResults   15
#define WST_ARResults   35
/*
 * 20-Jun-91 -- We don't remember why we thought of these as a pair;
 *      we're not sure that they couldn't be merged; --.
 * 30-Aug-91 -- But -- we're adding a third.
 */
typedef
struct G_PeakPS_S {   /* 'PS' for Peak Search - (Some are from the */
              /*  'locate' phase; others are 'analysis'.) */
    float   rEnergy;        /* _PSENERGY */

    float   rCentroid;      /* _PSLOCCENT */
    float   rErrorInC;      /* _PSDLOCCENT */
    float   rSignif;        /* _PSSIGNIF */
    ULONG   flPkFlags;      /* _PSPFLG */

    float   rCentroidA;     /* _PSCENTRD */
    float   rErrorInA;      /* _PSDCENTRD */

    ULONG   ulLeftCh;       /* _PSLEFT */
    ULONG   ulCountCh;      /* _PSWIDTH */

    float   rFit;       /* _PSFIT  (meaning -- unknown) */
    float   rArea;      /* _PSAREA */
    float   rOrigArea;      /* _PSORIGAREA */
    float   rOrigErr;       /* _PSORIGERR */
    float   rCps;       /* _PSCTSS */
    float   rCpsErr;        /* _PSCERR */
    float   rBackground;    /* _PSBACKGND */
    float   rErrorInB;      /* _PSDBACK */
    float   rFWHM;      /* _PSFWHM */
    float   rLoTail;        /* _PSTAIL1 */
    float   rHiTail;        /* _PSTAIL2 */
    } G_PeakPS_T;

/* ------------ */

typedef struct PAResults_S {
    ULONG   ulLeftCh;       /* _PSLEFT */
    ULONG   ulCountCh;      /* _PSWIDTH */
    float   rFit;           /* _PSFIT */
    float   rKValue;        /* _PSKVAL */
    float   rCentroidA;     /* _PSCENTRD */
    float   rErrorInA;      /* _PSDCENTRD */
    float   rArea;      /* _PSAREA */
    float   rAreaErr;       /* _PSDAREA   (New, 20-Jun. NOT ^^.) */
    float   rOrigArea;      /* _PSORIGAREA */
    float   rOrigErr;       /* _PSORIGERR */
    float   rBackground;    /* _PSBACKGND */
    float   rErrorInB;      /* _PSDBACK */
    float   rCps;           /* _PSCTSS */
    float   rCpsErr;        /* _PSCERR */
    float   rFWHM;      /* _PSFWHM */
    float   rLoTail;        /* _PSTAIL1 */
    float   rHiTail;        /* _PSTAIL2 */
    } PAResults_T;

/* ------------ */

typedef
struct ARResults_S {
    float   rEnergy;        /* _PSENERGY */
    float   rArea;      /* _PSAREA */
    float   rAreaErr;       /* _PSDAREA */
    float   rOrigArea;      /* _PSORIGAREA */
    float   rOrigErr;       /* _PSORIGERR */
    float   rCps;       /* _PSCTSS */
    float   rCpsErr;        /* _PSCERR */
    float   rAmbBack;       /* _PSAMBBACK */
    float   rAmbBackErr;    /* _PSDAMBBACK */
    } ARResults_T;

/* -------------------------------- */

#define WST_DispROI 10
    /* (Takes a 'record number' - CLS_DISP.) */

struct G_DispROI_S {
    ULONG   ulTypeROI;  /* _RGNTYPE (it has the flag !) */
    ULONG   ulStartCh;  /* _RGNSTART */
    ULONG   ulEndCh;    /* _RGNEND */
    };

/* -------------------------------- */

#define WST_CommonPA    11
    /* These are CLS_PROC - Processing Parameters. */

typedef
struct G_CommonPA_S {
    ULONG   flProcFlags;    /* _PROCFLAGS */

    ULONG   ulFirstChAn;    /* _PASTART */
    ULONG   ulLastChAn;     /* _PAEND */
    ULONG   ulNofContin;    /* _PRNBKCHN */
    CHAR    szContinuumF[7];    /* _ROIPSBTYP */
    } G_CommonPA_T;

/* -------------------------------- */

#define WST_Sample  12

struct G_Elapse_S {
    double  dStartAcq;  /* _ASTIME */
    double  dElapTrue;  /* _EREAL */
    double  dElapLive;  /* _ELIVE */
    char    szTitle[33]; /* ?? */
    };

/* ================================ */

#define WST_EnergyCal        16

typedef
struct G_Cal_S {

    REAL        rEnergy;                /* CALENERGY */
    REAL        rCentr;                 /* CALCENTROID */
    REAL        rCentrErr;              /* CALCENTERR */
    REAL        rFwhm;                  /* CALFWHM */
    LONG        flFlags;                /* CALFLAGS */

    } G_Cal_T;

/* ================================ */

#define WST_ShapeCal         17

typedef
struct G_SC_S {

    REAL        rEnergy;                /* SCENERGY */
    REAL        rFwhm;                  /* SCFWHM */
    REAL        rFwhmErr;               /* SCFWHMERR */
    REAL        rTail1;                 /* SCTAIL1 */
    REAL        rTail1Err;              /* SCTAIL1ERR */
    REAL        rTail2;                 /* SCTAIL2 */
    REAL        rTail2Err;              /* SCTAIL2ERR */
    LONG        flFlags;                /* SCFLAGS */
    ULONG   ulRoiLo;        /* SCSTART */
    ULONG   ulRoiHi;        /* SCEND */

    } G_SC_T;

/* ================================ */

#define WST_EFEntry      18

typedef
struct stEFEntry_S {        /* Efficiency Cal - tabular entry */

    REAL        rEnergy;                /* DENERGY */
    REAL        rEff;                   /* DEFF */
    REAL        rEffErr;                /* DEFFERR */
    REAL        rEffEfac;               /* DEFFEFAC */

    } stEFEntry_T;

/* ================================ */

#define WST_CtfRec     19

typedef
struct stCtfRec_S {     /* Certificate rec. */

    char    szNuclide[9];       /* CTFNUCL */
    char    szHLUnits[3];       /* CTFHLFUNITS */
    REAL    rEnergy;        /* CTFENER */
    REAL    rEmRate;        /* CTFRATE */
    REAL        rEmRateErr;             /* CTFERROR */
    DOUBLE      dxHlf;                  /* CTFHLFLIFE */
    DOUBLE      dxHlfErr;               /* CTFHLFERR */
    REAL    rAbundance;     /* CTFABUN */
    LONG    flCalInitNO;        /* CTFNOASKINI */
    } stCtfRec_T;

/* ================================ */

#define WST_EfDual    20
#define WST_EfLinear      34

typedef
struct stEfDual_S {        /* Efcal - Dual polynomial equation */

    LONG    lLdegree;       /* DLDEGREE */
    LONG    lHdegree;       /* DHDEGREE */
    REAL    rLfac[6];       /* DLCALFAC1-6 */
    DOUBLE  dLerr[11];      /* LERRMAT1-11 */
    REAL    rLChi;          /* DLCALCHI */
    REAL    rCross;         /* CROSSOVER */
    REAL    rHfac[10];      /* DHCALFAC1-10 */
    DOUBLE  dHerr[19];      /* HERRMAT1-19 */
    REAL    rHChi;          /* DHCALCHI */

    } stEfDual_T;

  /* +++++++++++++++++++++++++ */

typedef
struct stEfLinear_S {        /* Efcal - (?) equation */

    LONG    lDegree;    /* LNDEGREE */
    REAL    rFac[10];   /* LNCALFAC1-10 */
    DOUBLE  dErr[19];   /* LNERRMAT1-19 */
    REAL    rChi;       /* LNCHISQ */

    } stEfLinear_T;

/* ================================ */

#define WST_EfEmp    21

typedef
struct stEfEmp_S {         /* Efcal - Empirical equation */

    LONG    ldegree;        /* EMPDEGREE */
    REAL    rLfac[7];       /* DCALFAC1-7 */
    REAL    rChi;           /* EMPCHISQ */
    REAL    rAvgErr;        /* EFFAVERR */

    } stEfEmp_T;

/* ================================ */

#define WST_EcalSetup    22

typedef
struct EcalSetup_S {

    LONG    flEcalFlags;    /* ECALFLAGS */
    REAL    rEcalCnvFact;   /* ECALCNV */
    char    szEcalUnits[17];    /* ECALUNITS */
    char    szEcalType [9]; /* ECALTYPE */
    char    szFWHMType [9]; /* FWCALTYPE */

    } EcalSetup_T;

/* ================================ */

#define WST_AcqPage 23

typedef
struct AcqPage_S  {

    double  dAcqStart;      /* ASTIME */
    double  dPsetLive;      /* PLIVE */
    double  dPsetTrue;      /* PREAL */
    double  dElapLive;      /* ELIVE */
    double  dElapTrue;      /* EREAL */

    float   rElapComp;      /* ECOMP */
    float   rPsetComp;  /* ! -- VDM has to discover --. */
    USHORT  usCompMode;

    } AcqPage_T;

/* ================================ */

#define WST_SamplePage  24

typedef
struct SamplePage_S {

    float   rQuantity;      /* SQUANT */

    char    szTitle [65];   /* STITLE */
    char    szIdent [17];   /* SIDENT */
    char    szGeom  [17];   /* SGEOMTRY */
    char    szType  [17];   /* STYPE */
    char    szUnits [17];   /* SUNITS */
    char    szBuild [9];    /* -- !? */

    } SamplePage_T;

/* ================================ */

#define WST_EcalAll    25

typedef
struct EcalAll_S {

    double  dEcalTime;          /* ECALTIME */
    double  dScalTime;          /* SCALTIME */
    char    szEcalType [9]; /* ECALTYPE */
    char    szFWHMType [9]; /* FWCALTYPE */
    ULONG   ulNofC;             /* ECALTERMS  (N-of-coeffs) */
    float   rEcCoeff[6];        /* ECOFFSET, ECSLOPE, ECQUAD, ECALFAC1-3 */
    float   rEcalChi;           /* ECALCHISQ */
    char    szEcalUnits[17];    /* ECALUNITS */
    float   rEcalCnvFact;       /* ECALCNV */
    LONG    flEcalFlags;    /* ECALFLAGS */
    float   rFwSqCoeff[2];      /* FWHMOFF, FWHMSLOPE */
    float   rFwSqChi;           /* FWHMCHISQ */
    float   rFwPolyCoeff[3];    /* C1FWHM, C2FWHM, C3FWHM */
    float   rFwPolyChi;         /* FWPOLYCHISQ */
    float   rT1Coeff[2];        /* C1TAIL1, C2TAIL1 */
    float   rT1Chi;             /* TAIL1CHISQ */
    float   rT2Coeff[2];        /* C1TAIL2, C2TAIL2 */
    float   rT2Chi;             /* TAIL2CHISQ */
    float   rShape511[3];       /* FW511, T1511, T2511 */
    float   rShapeRef[3];       /* FWRef, T1Ref, T2Ref */

    } EcalAll_T;

/* ================================ */

#define WST_SpecialPks  26

typedef
struct SpecialPeak_S {
    float   r511FWHM;   /* _FW511 */
    float   r511LoTail; /* _T1511 */
    float   r511HiTail; /* _T2511 */
    float   rRefFWHM;   /* _FWREF */
    float   rRefLoTail; /* _T1REF */
    float   rRefHiTail; /* _T2REF */
    } SpecialPeak_T;

/* ================================ */

#define WST_SampleDesc  27
    /* (Extension of SamplePage, above.) */
    /* (Used in\by sample screen - to define.) */

typedef
struct SampleDesc_S {

    float   rQuantity;      /* SQUANT */

    char    szTitle [65];   /* STITLE */
    char    szIdent [17];   /* SIDENT - sample-ID */
    char    szGeom  [17];   /* SGEOMTRY */
    char    szType  [17];   /* STYPE - sample type */
    char    szUnits [17];   /* SUNITS */

    char    szLine1 [65];   /* SDESC1 */
    char    szLine2 [65];   /* SDESC2 */
    char    szLine3 [65];   /* SDESC3 */
    char    szLine4 [65];   /* SDESC4 */

    char    szCollect[25];  /* SCOLLNAME */

    double  dStartTime;     /* SDEPOSIT - Beginning of build-up. */
    double  dStopTime;      /* STIME   ('Grab' time if ==> is "".) */
    char    szBuildUp [9];  /* BUILDUPTYPE - Deposit\Irrad. */

    } SampleDesc_T;

/* ================================ */

#define WST_SetPreset   28

union pset_U {
    double  dPsetTime;  /* Live or True, depending on mode -- */
    ULONG   ulSweeps;   /* -- unless mode says _SWEEPS. */
    };

/* ---------------- */

typedef struct {

    long    flPsetMode;   /* See CAMPDEF - the PMOD bits. */
    union pset_U unTime;
    double  dPsetComp;    /* The appropriate --. */
    ULONG   ulStartCh;    /* Define the range of - */
    ULONG   ulStopCh;     /* - the comp preset. */

    } Preset_T;

/*  Note ---
 *  If _PMOD_AREA or _PERR is set, the value of _BACKGNDCHNS
 *  is implied ! for use in the calculation.
 *  (That is: the same one being used for display of area.)
 */

/* ================================ */

#define WST_NCLNuclide  29

typedef
struct Nuclide_S {
    CHAR    szName[9];      /* T_NCLNAME */
    CHAR    szType[17];     /* T_NCLSBHDR */
    double  dHalfLife;      /* X_NCLHLFLIFE */
    double  dHLUncer;       /* X_NCLHLFERR */
    CHAR    szHLUnits[3];   /* T_NCLHLFUNITS */
    } Nuclide_T;

/* ================================ */

#define WST_NCLLine  30

typedef
struct NucLine_S {
    float   rEnergy;        /* F_NLENERGY */
    float   rEngUncer;      /* F_NLENGERR */
    float   rAbundance;     /* F_NLABUN */
    float   rAbundUncer;    /* F_NLABUNERR */
    ULONG   fKey;       /* L_NLFKEYLINE */
    } NucLine_T;

/* ================================ */

#define WST_NCLMpc  31

typedef
struct NCLMpc_S {
    float   rOccSolAir;     /* F_NCLMPC2 */
    float   rOccSolH2O;     /* F_NCLMPC4 */
    float   rOccIsAir;      /* F_NCLMPC */
    float   rOccIsH2O;      /* F_NCLMPC3 */
    float   rPubSolAir;     /* F_NCLMPC6 */
    float   rPubSolH2O;     /* F_NCLMPC8 */
    float   rPubIsAir;      /* F_NCLMPC5 */
    float   rPubIsH2O;      /* F_NCLMPC7 */
    } NCLMpc_T;

/* ================================ */

#define WST_NCLMore  32
    /* ('More' because: that's the editor op that defines them.) */

typedef
struct NucMore_S {
    float   rEquivFactor;      /* F_NCLEQUFAC */
    CHAR    szDecayParent[9];  /* T_NCLPARENT */
    CHAR    szDecayDaught[9];  /* T_NCLDAUGHT */
    float   rAveGamma;         /* F_NCLGAMMA */
    float   rAveBeta;          /* F_NCLBETA */
    ULONG   fNoEBar;           /* L_NCLFNOEBAR */
    ULONG   fNoMDA;        /* ??? */
    float   rAbundLim;         /* F_NCLABNLIM */
    } NucMore_T;

/* ================================ */

#define WST_NCLEngU   8

typedef
struct NCLEngU_S {
    float   rEngUConv;         /* F_NLECCNVFAC */
    char    szEngUnits[17];    /* T_NLECUNITS */
    } NCLEngU_T;

/* ================================ */

#define WST_NCLUnits  33

typedef
struct NCLUnits_S {
    char    szOccSolAirAU[9];    /* T_NCLMPC2AU */
    char    szOccSolH2OAU[9];    /* T_NCLMPC4AU */
    char    szOccInsAirAU[9];    /* T_NCLMPC1AU */
    char    szOccInsH2OAU[9];    /* T_NCLMPC3AU */
    char    szPubSolAirAU[9];    /* T_NCLMPC6AU */
    char    szPubSolH2OAU[9];    /* T_NCLMPC8AU */
    char    szPubInsAirAU[9];    /* T_NCLMPC5AU */
    char    szPubInsH2OAU[9];    /* T_NCLMPC7AU */
    char    szOccSolAirQU[9];    /* T_NCLMPC2QU */
    char    szOccSolH2OQU[9];    /* T_NCLMPC4QU */
    char    szOccInsAirQU[9];    /* T_NCLMPC1QU */
    char    szOccInsH2OQU[9];    /* T_NCLMPC3QU */
    char    szPubSolAirQU[9];    /* T_NCLMPC6QU */
    char    szPubSolH2OQU[9];    /* T_NCLMPC8QU */
    char    szPubInsAirQU[9];    /* T_NCLMPC5QU */
    char    szPubInsH2OQU[9];    /* T_NCLMPC7QU */
    } NCLUnits_T;

/* ================================ */

#define WST_NCLMpcCF  49

typedef
struct NCLMpcCF_S {
    float   rOccSolAirCF;     /* F_NCLMPC2QCF */
    float   rOccSolH2OCF;     /* F_NCLMPC4QCF */
    float   rOccIsAirCF;      /* F_NCLMPC1QCF */
    float   rOccIsH2OCF;      /* F_NCLMPC3QCF */
    float   rPubSolAirCF;     /* F_NCLMPC6QCF */
    float   rPubSolH2OCF;     /* F_NCLMPC8QCF */
    float   rPubIsAirCF;      /* F_NCLMPC5QCF */
    float   rPubIsH2OCF;      /* F_NCLMPC7QCF */
    } NCLMpcCF_T;

/* ================================ */
/* -- The following four structs are convenient for
 *  the (more efficient, we hope) put of analysis results
 *  by the 'engines' --
 */
#define WST_PSNid   36

typedef struct G_PSNid_S {

    float   rEnergy;        /* _PSENERGY */
    float   rCps;       /* _PSCTSS */
    float   rCpsErr;        /* _PSCERR */
    float   rEff;           /* _PSEFF */
    float   rEffErr;        /* _PSEFFERR */
    ULONG   flPkFlags;      /* _PSPFLG */

    } G_PSNid_T;

/* -------------------------------- */

#define WST_PSMda   37

typedef struct G_PSMda_S {

    float   rBack;          /* _PSBACKGND */
    float   rBackErr;       /* _PSDBACK */
    float   rAmbBack;       /* _PSAMBBACK */
    float   rAmbBackErr;    /* _PSDAMBBACK */
    ULONG   flPkFlags;      /* _PSPFLG */

    } G_PSMda_T;

/* -------------------------------- */

#define WST_ProcNid 38

typedef struct G_ProcNid_S {

    float   rTol;           /* _TOLERANCE */
    float   rConfid;        /* _CONFID */
    float   rMdaConfid;     /* _MDACONFID */
    ULONG   ulFirstCh;      /* _PASTART */
    ULONG   ulLastCh;       /* _PAEND */

    } G_ProcNid_T;

/* -------------------------------- */

#define WST_NLNid   39

typedef struct G_NLNid_S {

    ULONG   ulNLPeak;       /* _NLPEAK */
    double  dAct;           /* _NLACTVTY */
    double  dActErr;        /* _NLERR */
    float   rEff;           /* _NLEFFICIENCY */
    float   rEffErr;        /* _NLEFFERR */

    } G_NLNid_T;

/* ================================ */

#define WST_ReportPL    44
#define WST_ReportPA    45
#define WST_ReportPM    46
#define WST_ReportNU    47
#define WST_ReportNL    48


typedef struct RptPL_S {

    float   rCentroid;      /* _PSLOCCENT */
    float   rErrorInC;      /* _PSDLOCCENT */
    float   rEnergy;        /* _PSENERGY */
    float   rErrorInE;      /* _PSDENERGY */
    float   rSignif;        /* _PSSIGNIF */

    } RptPL_T;

/* -------------------------------- */

typedef struct RptPA_S {

    ULONG   ulLeftCh;       /* _PSLEFT */
    ULONG   ulCountCh;      /* _PSWIDTH */
    float   rCentroidA;     /* _PSCENTRD */
    float   rErrorInA;      /* _PSDCENTRD */
    float   rEnergy;        /* _PSENERGY */
    float   rErrorInE;      /* _PSDENERGY */
    float   rOrigArea;      /* _PSORIGAREA */
    float   rOrigErr;       /* _PSORIGERR */
    float   rBackground;    /* _PSBACKGND */
    float   rErrorInB;      /* _PSDBACK */
    float   rFit;           /* _PSFIT */
    float   rKValue;        /* _PSKVAL */
    long    fPPFit;     /* _PSPPFIT */
    long    fFitROI;        /* _PSPFITROI */
    long    fFitConv;       /* _PSPFITCONV */
    long    fPPADone;       /* _PSPPADONE */
    long    fPMult;     /* _PSPMULT */

    } RptPA_T;

/* -------------------------------- */

typedef struct RptPM_S {

    float   rEnergy;        /* _PSENERGY */
    float   rOrigArea;      /* _PSORIGAREA, */
    float   rOAreaErr;      /* _PSORIGERR, */
    float   rArea;      /* _PSAREA, */
    float   rAreaErr;       /* _PSDAREA, */
    float   rEff;       /* _PSEFF, */
    float   rEffErr;        /* _PSEFERR, */
    float   rAmbBack;       /* _PSAMBBACK, */
    float   rABError;       /* _PSDAMBBACK, */
    float   rPTCRatio;      /* _PSPTCRATIO, */
    float   rCps;           /* _PSCTSS */
    float   rCpsErr;        /* _PSCERR */
    float   rFWHM;      /* _PSFWHM */
    float   rFWHMErr;       /* _PSDFWHM, */
    long    fPPFit;     /* _PSPPFIT, */
    long    fPPADone;       /* _PSPPADONE, */
    long    fPMult;     /* _PSPMULT, */

    } RptPM_T;

/* -------------------------------- */

typedef struct RptNU_S {

    CHAR    szName[9];      /* _NCLNAME */
    CHAR    szType[17];     /* _NCLSBHDR */
    float   rConfidence;    /* _NCLCONFID */
    double  dWtMean;        /* _NCLWTMEAN */
    double  dWtMErr;        /* _NCLWTMERR */
    double  dHalfLife;      /* _NCLHLFLIFE */
    double  dHLUncer;       /* _NCLHLFERR */
    CHAR    szHLUnits[3];   /* _NCLHLFUNITS */
    double  dMDA;       /* _NCLMDA */
    long    fFDecay;        /* _NCLFFDECAY */
    long    fIdent;     /* _NCLFIDENT */
    long    fShortHL;       /* _NCLFSHORTHL */
    long    fIntReject;     /* _NCLFINTFREJ */
    long    fKeyOut;        /* _NCLFKEYOUT */
    long    fNoRptMDA;      /* _NCLFNORPTMDA */

    } RptNU_T;

/* -------------------------------- */

typedef struct RptNL_S {

    float   rEnergy;        /* _NLENERGY */
    float   rEngUncer;      /* _NLENGERR */
    float   rAbundance;     /* _NLABUN */
    float   rAbundUncer;    /* _NLABUNERR */
    ULONG   ulNLPeak;       /* _NLPEAK */
    double  dAct;           /* _NLACTVTY */
    double  dActErr;        /* _NLERR */
    double  dMDA;       /* _NLMDA */
    float   rEff;           /* _NLEFFICIENCY */
    float   rEffErr;        /* _NLEFFERR */
    long    fKeyLine;       /* _NLFKEYLINE */
    long    fInterfere;     /* _NLFFINTERF */

    } RptNL_T;

/* ================================ */

#define WST__   50

/* #define BIG_STRUCT  (sizeof (SampleDesc_T)) */
/*  ( Sizeof union of all, best way -- ) */
/* ==> BIG_ONES.H, Apr-91 --. */

/* ******************************* E-O-F ****************************** */
