/* Source Code Example - GENIE-PC Programming Library */


/* Windows includes */

#include <windows.h>
#include "crackers.h"

/* C run time library includes */

#include <tchar.h>
#include <stdio.h>


/* GENIE-PC User Library includes */

#include <citypes.h>

#include <spasst.h>
#include <sad.h>
#include <ci_files.h>
#include <campdef.h>
#include <cam_n.h>


/* GENIE-PC Utility Library includes */

#include <utility.h>


/* User's includes */


/* Application source code */


main(int argc, char *argv[], char *envp[])
{
       HMEM         hDSC;
       INT          iRC;
       SHORT        sRC;
       ULONG        ulRC;
       CHAR         szIdent[CAM_N_SIDENT];
       REAL         rQuant;


/* Set Environment from the registry */

       vG2KEnv(); 


/* Establish a connection to the local VDM */

       iRC = iUtlCreateFileDSC2(&hDSC, 0, 0);
       if (iRC) {
            printf("Error creating a VDM connection: %u", iRC);
            return(1);
       }


/* Open a CAM file datasource */

       sRC = SadOpenDataSource(hDSC, "C:\\GENIE2K\\CAMFILES\\NBSSTD.CNF",
                               CIF_NativeSpect,
                               ACC_Exclusive|ACC_SysWrite|ACC_ReadWrite,
                               FALSE, "");
       if (sRC) {
            ulRC = ulSadStat(hDSC, sRC);
            printf("Error opening NBSSTD.CNF: %lx", ulRC);
            return(1);
       }


/* Read/write parameters to/from NBSSTD.CNF */

       sRC = SadGetParam(hDSC, CAM_T_SIDENT, 0, 0, szIdent, CAM_N_SIDENT);
       if (sRC) {
            ulRC = ulSadStat(hDSC, sRC);
            printf("Error reading sample ID: %lx", ulRC);
            return(1);
       }

       rQuant = 10.0;
       sRC = SadPutParam(hDSC, CAM_F_SQUANT, 0, 0, &rQuant, sizeof(REAL));
       if (sRC) {
            ulRC = ulSadStat(hDSC, sRC);
            printf("Error writing sample quantity: %lx", ulRC);
            return(1);
       }


/* Save changes to NBSSTD.CNF, cleanup and exit */

       sRC = SadFlush(hDSC);
       if (sRC) {
            ulRC = ulSadStat(hDSC, sRC);
            printf("Error saving changes to NBSSTD.CNF: %lx", ulRC);
            return(1);
       }
       sRC = SadCloseDataSource(hDSC);
       sRC = SadDeleteDSC(hDSC);
       return(0);
}

/**** End Of File ****/

