/* ************************< DRIVER.H >******************************** *
 * -------------------------------------------------------------------- *
 * Notes:                                                               *
 * - The 'device' structs (xxxParam_S) MUST agree with SCRIPT.H in the  *
 *  CAM project !  That's the means by which Get\PutParam to\from       *
 *  'hardware' works.   Also note - that the access to the driver uses  *
 *  a bit-map, and the bits are one-for-one with those parameters.      *
 * - The fact that MID_RECS.h is very similar is confusing! It is not   *
 *  used in the same way.  Those details are in SAVE_MID.               *
 * - LES has no clue on use of DRD's "heierarchy"; many notes are (!?). *
 * - Dec-97, LES cleaned up DRD's MCA-param changes - 3 (4?) params had *
 *  no use (the driver had no bits); one reserved 2 bytes for double.   *
 * -------------------------------------------------------------------- *
 * History                                                              *
 *   1-Aug-90, RAS:  Start from a copy S100PDrv.h & Queries.h           *
 *  11-Sep-90, RAS:  Alpha release for protocol driver                  *
 *  15-Feb-91, RAS:  Update to SDD v1.4                                 *
 *  18-Apr-91, LES\RAS:  Add hCAM to the various Read, Write & Ctl.     *
 *  22-Apr-91, LES:  Add fBusy, likewise.  Also (1) usFiller --.        *
 *  29-Aug-91, RAS:  Add Mxr access struct to Acq start/stop, clear     *
 *  13-Sep-91, RAS:  Add Mxr active input to Acq start/stop.            *
 *   4-Dec-91, RAS:  Add Group # for AccuSpec memory groups.            *
 *  15-Jan-92, RAS:  Add ICB device support                             *
 *  20-Jan-92, LES:  Add two params to AcqStpC_S - for AIM \ ADC.       *
 *  23-Jan-92, LES:  Same as above for McaP_S.                          *
 *  12-Feb-92, RAS:  Add usAdcNo for AIM.                               *
 *  23-Mar-92, RAS:  Add query of default parameters                    *
 *  25-May-93, RAS:  Add support for GENIE Portable; update, LES, 7-Jun.*
 *  09-Jul-93, LES:  More portable changes.                             *
 *  14-Jun-93, LES:  Restore ! the label field in Entries_S.            *
 *  28-Jul-93, RAS:  Add Dig Stab overrange reset control #define       *
 *  06-Aug-93, RAS:  Two more power-mgmt params.                        *
 *  23-Aug-93, RAS:  Add TotalSteps to Scroll Bar structure.            *
 *  13-Sep-93, RAS:  Rearrange Pwr Mgr structure for Inspector          *
 *  17-Nov-93, SEW:  IBMC Changes                                       *
 *  25-Oct-93, RAS:  Add fOverrange for dig stab,                       *
 *                 change sHiRange to rRange for HV supply              *
 *  04-Nov-93, RAS:  Add hCAM to Query result union                     *
 *  20-Dec-93, RAS:  Add fFault to HVPS struct                          *
 *  05-Jan-94, RAS:  Add f12vFault to PwrMgt struct & fZeroOverrng to   *
 *                   DigStab struct                                     *
 *  17-Feb-94, RAS:  Add flCParam to RWSVMask struct for ? Cal params   *
 *  15-Apr-94, LES:  Add IcbDTR (direct-to-register) 'device's.         *
 *  17-Feb-95, DRD:  Add support for Alpha Analyst (new driver, new     *
 *                      vacuum device, & new parms for MCA and Amp      *
 *  15-Mar-95, DRD:  Support for hierarchical inputs                    *
 *  25-May-95, DRD:  Move new parms for Alpha Analyst support           *
 *  30-May-95, DRD:  Support for vacuum device type based on VR-mode    *
 *  05-Sep-95, DRD:  Add MCAQPARAM_FixedDetType                         *
 *  26-Oct-95, LES:  Reserve three control opcodes for s-changer.       *
 *  20-Nov-95, DRD:  Add hierarchical inputs to DevOpen                 *
 *                   Add Vacuum fault to vacuum parameters              *
 *  09-Feb-96, LES:  More SCHGR opcodes; GAChanger 'type'.              *
 *  12-Feb-96, LES:  The s-changer struct supports 3 new params.        *
 *  24-Apr-96, SEW:  Add conditionals for C++ support                   *
 *  18-Jul-96, DRD:  Amp - Pulser offset                                *
 *  15-Jul-97, LES:  Add two new MCA-device constants.                  *
 *  14-Aug-97, ARW:  Add items to support the DSP Gain, Filter          *
 *                   and Stabilizer devices.                            *
 *  21-Oct-97, LES:  Expand the query-for-controls array, for DSP.      *
 *  09-Jan-98, LES:  Add support for new AIM and DesktopDSP.            *
 * ******************************************************************** */

#ifdef __cplusplus
extern "C" {
#endif


#define DRIVER


/************************
 * -- The prototypes -- *
 ************************/

#if defined(WIN32)
#define MDRNTRY  ULONG WINAPI
#else
#define MDRNTRY  ULONG
#endif


// #ifndef WIN32 !??
#define WORD  USHORT


//  Misc
#define MAX_ICB_REGS       16
#define MAX_DSA_CMDS       64


/********************
 * -- structures -- *
 ********************/

struct NtryPt_S {
    CHAR      szName[16];
    };


/****** Device ******/  /* See note at the top. */

struct McaParam_S {
    USHORT    usStartCh;
    USHORT    usNoChannels;
    FLAGS     fsMxrInput;
    CHAR      szAcqMode[5];
    BYTE      fbFiller; // (? See the AcqCtl guy --)
    FLAGS     fsPresetType;
    double    dPLiveTime;
    double    dPTrueTime;
    ULONG     ulPSweeps;
    USHORT    usCompStartCh;
    USHORT    usCompEndCh;
    float     rPComp;
    double    dELiveTime;
    double    dETrueTime;
    float     rEComp;
    ULONG     ulESweeps;
    REAL      rHvpsCurrent;      // A-A hvps leakage current
    FLAG      fVRModeSet;        // A-A Vacuum-regulated mode setting
    BYTE      abFiller[8];       // (Dec-97, LES)
    CHAR      szAcqInputID[13];  // A-A input (detector) ID
    };

#define MCA_HVPS_CURRENT 15
#define MCA_VR_MODE      16      // Position of VR mode setting

#define DEVMASK_McaHvpsCurrent (1L<<MCA_HVPS_CURRENT)
#define DEVMASK_McaVrMode      (1L<<MCA_VR_MODE)
/* --
** Note that this (the MCA 'device') is what the VDM uses to read
** and maintain detector 'run-time' info.
*/

struct AdcParam_S {
    FLAG      fDXferTime;
    FLAG      fPeakDetect;
    FLAG      fCoinTiming;
    FLAG      fCoinMode;
    CHAR      szAcqMode[9];
    SHORT     sRange;
    SHORT     sGain;
    SHORT     sOffset;
    float     rLLD;
    float     rULD;
    float     rZero;
    float     rThreshold;
    FLAG      fLtcPurSig;
    FLAG      fAmpInternal;
    USHORT    usFiller;
    };

struct MxrParam_S {
    FLAG      fDepInpt;
    CHAR      szMode[9];
    BYTE      bNofInputs;
    USHORT    usNoChannel;
    FLAG      fMxrEnabled;
    USHORT    usFiller;
    };

struct DSParam_S {
    USHORT    usZeroPkCh;
    USHORT    usZeroWin;
    USHORT    usZeroWinSpace;
    USHORT    usZeroStabRate;
    FLAG      fZeroAdjRange;
    CHAR      szZeroStab[5];
    float     rZeroCorr;
    float     rZeroRange;
    FLAG      fZeroOverrange;
    USHORT    usGainPkCh;
    USHORT    usGainWin;
    USHORT    usGainWinSpace;
    USHORT    usGainStabRate;
    FLAG      fGainAdjRange;
    CHAR      szGainStab[5];
    float     rGainCorr;
    float     rGainRange;
    FLAG      fGainOverrange;
    float     rZeroRatio;
    float     rGainRatio;
    };

struct AmpParam_S {
    CHAR      szPreAmpType[9];
    float     rCoarseGain;
    float     rFineGain;
    float     rSFineGain;
    float     rCompositeGain;
    float     rShaping;
    CHAR      szShapeMode[9];
    FLAG      fInputMode;
    FLAG      fInputPolar;
    CHAR      szBLRMode[9];
    FLAG      fInhibitPolar;
    CHAR      szDTCntl[9];
    FLAG      fPileupRej;
    USHORT    usPoleZero;
    FLAG      fAttenuate;
    FLAG      fPulserStat;             // status of pulser                       // drd 2/17/95
    REAL      rPulserEnergy;           // energy of pulser                       // drd 2/17/95
    REAL      rPulserGain;             // gain for pulser                        // drd 2/17/95
    REAL      rPulserOffset;           // offset for pulser
    };

#define AMP_PULS_STAT    15            // position of pulser status parm         // drd 2/17/95
#define AMP_PULS_ENERGY  16            // position of pulser energy parm         // drd 2/17/95
#define AMP_PULS_GAIN    17            // position of pulser gain parm           // drd 2/17/95
#define AMP_PULS_OFFSET  18

#define DEVMASK_PulserOffset      (1L<<AMP_PULS_OFFSET)

struct HVSParam_S {
    float     rHighVolt;               // high voltage setting                   // drd 5/25/95
    FLAG      fOverloadLtch;
    FLAG      fInhibitLtch;
    FLAG      fInhibitSig;
    FLAG      fHVPolarity;
    FLAG      fInhibitSet;
    FLAG      fOverloadSet;
    FLAG      fHVOn;
    float     rHVLimit;
    float     rRange;
    FLAG      fFault;
    USHORT    usFiller;
    };

#define HVPS_ON 7

#define DEVMASK_HvpsOn    (1L<<HVPS_ON)

struct PMParam_S {
    char      szMode[5];
    FLAG      fBatteryA;
    char      szBatAStatus[5];
    float     rBatAVoltage;
    char      szBatBStatus[5];
    float     rBatBVoltage;
    FLAG      fBatsStatus;
    FLAG      fRamBackStatus;
    USHORT    usStbyDelay;
    USHORT    usStrtDelay;
    FLAG      f12vFault;
    FLAG      fMcaReset;
    USHORT    usFiller;
    };

struct VacParam_S {                    // Parameters for Vacuum Device           // drd 2/17/95
    REAL rAirPressure;                 // Regulated air pressure                 // drd 2/17/95
    REAL rVacMinThreshold;             // minimum air pressure threshold         // drd 2/17/95
    REAL rVacMaxThreshold;             // maximum air pressure threshold         // drd 2/17/95
    REAL rAirTemp;                     // air temperature                        // drd 2/17/95
    CHAR szValveState[5];              // state of valve                         // drd 2/17/95
    REAL rAirThickness;                // air thickness                          // drd 4/4/95
    REAL rAirPresRead;                 // actual air pressure                    // drd 5/30/95
    FLAG fFault;                       // vacuum fault                           // drd 11/20/95
    REAL rSampDistance;                // sample distance
    };

#define VAC_AIR_PRES 0                 // position of air pressure parm          // drd 2/17/95
#define VAC_MIN_THRESH 1               // position of min threshold parm         // drd 2/17/95
#define VAC_MAX_THRESH 2               // position of max threshold parm         // drd 2/17/95
#define VAC_AIR_TEMP 3                 // position of air temp parm              // drd 2/17/95
#define VAC_VALVE_STATE 4              // position of valve state parm           // drd 2/17/95
#define VAC_AIR_THICK 5                // position of air thickness parm         // drd 4/4/95
#define VAC_AIR_PRES_READING 6         // position of air pressure reading       // drd 5/30/95
#define VAC_FAULT 7                    // position of vacuum fault               // drd 11/20/95
#define VAC_SAMP_DIST 8                // position of sample distance

#define DEVMASK_VacAirPres        (1L<<VAC_AIR_PRES)
#define DEVMASK_VacMinThresh      (1L<<VAC_MIN_THRESH)
#define DEVMASK_VacMaxThresh      (1L<<VAC_MAX_THRESH)
#define DEVMASK_VacAirTemp        (1L<<VAC_AIR_TEMP)
#define DEVMASK_VacValveState     (1L<<VAC_VALVE_STATE)
#define DEVMASK_VacAirThick       (1L<<VAC_AIR_THICK)
#define DEVMASK_VacAirPresReading (1L<<VAC_AIR_PRES_READING)
#define DEVMASK_VacFault          (1L<<VAC_FAULT)
#define DVEMASK_VacSampDist       (1L<<VAC_SAMP_DIST)

struct GainParam_S {
    float     rCoarseGain;
    float     rFineGain;
    float     rSFineGain;
    float     rCompositeGain;
    SHORT     sGain;
    SHORT     sRange;
    SHORT     sOffset;
    float     rLLD;
    float     rZero;
    CHAR      szFDMode[9];
    float     rFD;
    FLAG      fInputPolar;
    FLAG      fInhibitPolar;
    CHAR      szDTCntl[9];
    FLAG      fCoinMode;
    float     rPURGuard;
    FLAG      fTRPinhibit;
    SHORT     sLTtrim;
    float     rICR;
    };

struct FltrParam_S {
    float   rRiseTime;
    float   rFlatTop;
    char    szBLRMode[9];
    char    szPreAmpType[9];
    USHORT  usPoleZero;
    USHORT  usFiller;
    };

struct ChgrParam_S {
    FLAG      fChngrRdy;
    USHORT    usHardError;
    USHORT    usSoftError;
    USHORT    usOOSReason;
    FLAG      fNegPolarity;
    USHORT    usFiller;
    };


struct MCSParam_S {
    char      szDiscrimMode[9]; // TTL, Fast, ROI
    float     rDwellTime;       // (Units !?)
    USHORT    usChanStart;
    USHORT    usChanEnd;        // Of ROI, if.
    FLAG      fOverwrite;       // Else Add-mode.
// ---
    float     rDwellRange;      // (Break up for dlg !?)
    float     rDwellValue;
    };


struct PISRParam_S {
    char      szPulserMode[9];
    USHORT    usBufferSize;
    USHORT    usLowOffset;
    USHORT    usHighOffset;
    USHORT    usLowTiming;
    USHORT    usHighTiming;
    USHORT    usPulserRate;
    FLAG      fNegPolarity;
    USHORT    usFiller;
// --
    USHORT    usGammaCutoff;   // Needed at protocol level;
                   // set at device level based on channels.
    };


/******* Open *******/

struct DevOpen_S {
    CHAR      szSerNum[9];
    CHAR      szOwner[9];
    FLAG      fOverride;
    USHORT    usAdcNo;                 // input # for controller                 // drd 11/20/95
    USHORT    usInpDim1;               // Hierarchical location of input         // drd 11/20/95
    USHORT    usInpDim2;               // Hierarchical location of input         // drd 11/20/95
                                       // although somewhat awkward, these paras // drd 11/20/95
                                       // are required for opening each input    // drd 11/20/95
                                       // of a controller (such as Alpha         // drd 11/20/95
                                       // Analyst), Naming convention is         // drd 11/20/95
                                       // needed by driver                       // drd 11/20/95
    };

union OParam_U {
    struct    DevOpen_S   stDevO;
    };


struct OResult_S {
    CHAR      szSerNum[9];
    BYTE      fbFlags;  // (Only) For New-AIM, Jan-98.
                        // 1: New-AIM; 2: 2nd-ADC.
    };


union  OResult_U {    // Open results union
    struct    OResult_S  stOpenR;
    };



/****** Close ******/

union ClParam_U {
    SHORT                 sNull;
    };



/****** Read *******/

struct McaP_S {
    FLAG      fWait;
    HMEM      hCAM;     // Access to assoc. CAM file.
    FLAG      fBusy;    // RTDB 'acquiring'.
    FLAGL     flMcaRMask;
    BYTE      bInputNumber;
    FLAGS     fsPresetType;
    struct    PDDAccess_S *  pstPDDMxrAccs;                             // SM$:M1
    USHORT    usStartCh;     // not used 2/12/92
    USHORT    usNoChannels;  // not used 2/12/92
    USHORT    usAdcNo;
    USHORT    usInpDim1;               // Hierarchical location of ADC           // drd 3/15/95
    USHORT    usInpDim2;               // Hierarchical location of ADC           // drd 3/15/95
    };

struct McaMidP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    BYTE      bInputNumber;
    };

struct DevP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    FLAGL     flRMask;
    };

struct InStatP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    BYTE      bInputNumber;
    USHORT    usStartCh;     // not used 2/12/92
    USHORT    usNoChannels;  // not used 2/12/92
    USHORT    usAdcNo;
    USHORT    usInpDim1;               // Hierarchical location of ADC           // drd 3/15/95
    USHORT    usInpDim2;               // Hierarchical location of ADC           // drd 3/15/95
    };

struct SDataP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    USHORT    usStartCh;
    USHORT    usNumChs;
    USHORT    usCurGroupNo;
    USHORT    usActGroupNo;
    USHORT    usAdcNo;                 // ADC # to allow driver to make offset   // drd 3/15/95
    USHORT    usInpDim1;               // Hierarchical location of ADC           // drd 3/15/95
    USHORT    usInpDim2;               // Hierarchical location of ADC           // drd 3/15/95
    };

struct MailBP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    USHORT    usNumber;
    USHORT    usNoWds;
    USHORT    usOffset;
    };

struct CalcDP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    USHORT    usStartCh;
    USHORT    usNoChannels;
    USHORT    usCurCh;
    USHORT    usBackground;
    float     rSigma;
    USHORT    usInputNo;
    };

struct ScaleDP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    USHORT    usStartCh;
    USHORT    usNoChannels;
    SHORT     sScaleMode;
    SHORT     sVFS;
    SHORT     sScaleType;
    USHORT    usAdcNo;                 // ADC # to allow driver to make offset   // drd 3/15/95
    USHORT    usInpDim1;               // Hierarchical location of ADC           // drd 3/15/95
    USHORT    usInpDim2;               // Hierarchical location of ADC           // drd 3/15/95
    };

struct IcbDTR_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    BYTE      bRegister;
    };

struct NullP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    };                                 // Note this structure cannot be added to // drd 4/5/95
                                       // unless InpP_S is changed also.  InpP_S // drd 4/5/95
                                       // needs to have the fields added before  // drd 4/5/95
                                       // usAdcNo.  If InpP_S is changed, any    // drd 4/5/95
                                       // previous drivers using the old InpP_S  // drd 4/5/95
                                       // would have to be rereleased.           // drd 4/5/95
                                       // This is due to ulDirectCtl in          // drd 4/5/95
                                       // DS$CNTRL.c using the InpP_S structure  // drd 4/5/95
                                       // regardless of whether the control uses // drd 4/5/95
                                       // input dimensions or not                // drd 4/5/95

struct InpP_S {                        // structure used for Pass with Inputs    // drd 4/5/95
    FLAG      fWait;                                                             // drd 4/5/95
    HMEM      hCAM;                                                              // drd 4/5/95
    FLAG      fBusy;                                                             // drd 4/5/95
    USHORT    usAdcNo;                 // ADC # to allow driver to make offset   // drd 4/5/95
    USHORT    usInpDim1;               // Hierarchical location of ADC           // drd 4/5/95
    USHORT    usInpDim2;               // Hierarchical location of ADC           // drd 4/5/95
    };                                                                           // drd 4/5/95

struct IcbDev_S {
    ULONG     ulNofRegs;
    BYTE      abAddr[16];
    };


union  RParam_U {     // Read parameters union
    struct    McaP_S    stMcaP;
    struct    McaMidP_S stMcaMP;
    struct    DevP_S    stDevP;
    struct    InStatP_S stInStatP;
    struct    SDataP_S  stSDP;
    struct    MailBP_S  stMboxRP;
    struct    CalcDP_S  stCalcP;
    struct    ScaleDP_S stScaleP;
    struct    NullP_S   stNullP;
    struct    IcbDTR_S  stICBRP;
    struct    IcbDev_S  stICBP;
    };


/****** Read Results *******/

struct InStatR_S {
    FLAGS     fsInputStatus;    // 1: busy; 0x8000: XWait
                                // (2, 4, 8 can mean 'reached'?)
    FLAGS     fsActive;         // map of busy MXR inputs
    ULONG     ulMSecSince;      // since Start, when XWait goes away
    };

struct SDataR_S {
    USHORT    usActChs;
    ULONG     aulData[512];
    };

struct McaMidR_S {
    ULONG     ulMaxMemory;
    USHORT    usNoChannel;
    BYTE      bNofAdcs;
    };

struct MailBR_S {
    USHORT    ausData[1024];
    };

struct CalcDR_S {
    ULONG     ulCurData;
    double    dIntegral;
    double    dArea;
    float     rPercentError;
    };

struct ScaleDR_S {
    SHORT     sVFS;
    SHORT     sNoDataPts;
    USHORT    ausData[1024];
    };

struct SmpChgrR_S { // (Jan-98, ChgrParam replaces?)
    FLAG      fChngrRdy;
    USHORT    usHardError;
    USHORT    usSoftError;
    USHORT    usOOSReason;
    FLAG      fNegPolarity;
    };


union  RResult_U {    // Read results union
    FLAGS                fsCtlStatus;
    struct    InStatR_S  stInStatR;
    FLAGS                fsDiagStatus;
    FLAGS                fsMCAStatus;
    struct    SDataR_S   stSDR;
    struct    McaMidR_S  stMcaMR;
    struct    MailBR_S   stMboxR;
    struct    CalcDR_S   stCalcR;
    struct    ScaleDR_S  stScaleR;

    struct    McaParam_S stMcaR;
    struct    SmpChgrR_S stSmpChgrR;
    struct    AdcParam_S stAdcR;
    struct    MxrParam_S stMxrR;
    struct    DSParam_S  stDSR;
    struct    AmpParam_S stAmpR;
    struct    MCSParam_S stMCSR;
    struct    HVSParam_S stHVSR;
    struct    PMParam_S  stPwrMgtR;
    struct    VacParam_S stVacR;       // Vacuum device results                  // drd 2/17/95
    struct    GainParam_S stGainR;
    struct    FltrParam_S stFilter;
    struct    PISRParam_S stPulser;
    struct    ChgrParam_S stChange;
    BYTE                 abIcbR[MAX_ICB_REGS];
    USHORT               awDSAR[MAX_DSA_CMDS];
    };


/****** Write *******/

struct CtlStatW_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    FLAGS     fsCtlStatus;
    };

struct SDataLP_S {     // spectrum data load parameter structure
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    USHORT    usStartCh;
    USHORT    usNumChs;
    ULONG     aulData[512];
    USHORT    usCurGroupNo;
    USHORT    usActGroupNo;
    USHORT    usAdcNo;                 // ADC # to allow driver to make offset   // drd 3/15/95
    USHORT    usInpDim1;               // Hierarchical location of ADC           // drd 3/15/95
    USHORT    usInpDim2;               // Hierarchical location of ADC           // drd 3/15/95
    };

struct McaMidLP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    ULONG     ulMaxMemory;
    USHORT    usNoChannel;
    BYTE      bNofAdcs;
    BYTE      bInputNumber;
    };

struct MboxLP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    USHORT    usNumber;
    USHORT    usNoWds;
    USHORT    usOffset;
    USHORT    ausData[1024];
    };

struct McaLP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    FLAGL     flMcaWMask;
    BYTE      bInputNumber;
    struct    McaParam_S stMcaP;
    struct    PDDAccess_S *  pstPDDMxrAccs;
    };

struct AdcLP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    FLAGL     flWMask;
    struct    AdcParam_S stAdcP;
    };

struct AmpLP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    FLAGL     flWMask;
    struct    AmpParam_S stAmpP;
    USHORT    usGroupNo;
    };

struct DSLP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    FLAGL     flWMask;
    struct    DSParam_S stDSP;
    USHORT    usGroupNo;
    };

struct HVSLP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    FLAGL     flWMask;
    struct    HVSParam_S stHVSP;
    USHORT    usGroupNo;
    };

struct PwrMgtLP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    FLAGL     flWMask;
    struct    PMParam_S stPwrMgtP;
    };

struct VacLP_S {                                                                 // drd 2/17/95
    FLAG      fWait;                                                             // drd 2/17/95
    HMEM      hCAM;                                                              // drd 2/17/95
    FLAG      fBusy;                                                             // drd 2/17/95
    FLAGL     flWMask;                                                           // drd 2/17/95
    struct    VacParam_S stVacP;                                                 // drd 2/17/95
    };                                                                               // drd 2/17/95

struct MCSLP_S {                                                                 // drd 2/17/95
    FLAG      fWait;                                                             // drd 2/17/95
    HMEM      hCAM;                                                              // drd 2/17/95
    FLAG      fBusy;                                                             // drd 2/17/95
    FLAGL     flWMask;                                                           // drd 2/17/95
    struct    MCSParam_S stMCSP;                                                 // drd 2/17/95
    };                                                                               // drd 2/17/95

struct PISRLP_S {                                                                 // drd 2/17/95
    FLAG      fWait;                                                             // drd 2/17/95
    HMEM      hCAM;                                                              // drd 2/17/95
    FLAG      fBusy;                                                             // drd 2/17/95
    FLAGL     flWMask;                                                           // drd 2/17/95
    struct    PISRParam_S stPulser;                                                 // drd 2/17/95
    };                                                                               // drd 2/17/95

struct IcbDTRLP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    BYTE      bRegister;
    BYTE      bValue;
    BYTE      bMask;
    };

struct IcbDevLP_S {
    ULONG     ulNofRegs;
    struct {
        BYTE  bAddr;
        BYTE  bData;
        }     stPairs[MAX_ICB_REGS];
    };

struct DSADevLP_S {
    ULONG     ulNofRegs;
    struct {
        BYTE   bParam;
        USHORT usValue;
        }   astPair[MAX_DSA_CMDS];
    };

struct GainLP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    FLAGL     flWMask;
    struct    GainParam_S stGainP;
    };

struct FltrLP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    FLAGL     flWMask;
    struct    FltrParam_S stFltrP;
    };


struct SChgrLP_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    FLAGL     flWMask;
    struct    ChgrParam_S stChange;
    };


union  WParam_U {     // Write parameters union
    struct    CtlStatW_S stCtlStatW;
    struct    SDataLP_S  stSDP;
    struct    McaMidLP_S stMcaMLP;
    struct    McaLP_S    stMcaLP;
    struct    MboxLP_S   stMboxLP;
    struct    AdcLP_S    stAdcLP;
    struct    DSLP_S     stDSLP;
    struct    AmpLP_S    stAmpLP;
    struct    HVSLP_S    stHVSLP;
    struct    MCSLP_S    stMCSLP;
    struct    PwrMgtLP_S stPwrMgtLP;
    struct    VacLP_S    stVacLP;                                                // drd 2/17/95
    struct    IcbDTRLP_S stICBRLP;
    struct    IcbDevLP_S stIcbLP;
    struct    GainLP_S   stGainLP;
    struct    PISRLP_S   stPulserLP;
    struct    FltrLP_S   stFilterLP;
    struct    SChgrLP_S  stChangeLP;
    struct    DSADevLP_S stDeskLP;
    FLAGS                fsAck;
    };


/****** Control ********/

struct AcqStaC_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    USHORT    usStartCh;
    USHORT    usNoChannels;
    FLAGS     fsMxrInput;
    FLAGS     fsActiveInputs;
    CHAR      szAcqMode[5];
    BYTE      fbExternSS;
    FLAGS     fsPresetType;
    double    dPLiveTime;
    double    dPTrueTime;
    ULONG     ulPSweeps;
    USHORT    usCompStartCh;
    USHORT    usCompEndCh;
    float     rPComp;
    double    dELiveTime;
    double    dETrueTime;
    ULONG     ulESweeps;
    struct    PDDAccess_S *  pstPDDMxrAccs;
    USHORT    usGroupNo;
    USHORT    usAdcNo;
    USHORT    usAcqDelay;
    USHORT    usInpDim1;               // Hierarchical location of ADC           // drd 3/15/95
    USHORT    usInpDim2;               // Hierarchical location of ADC           // drd 3/15/95
    };

// Bits in fbExternSS
#define PHA_EXTSTART 0x01
#define PHA_EXTSTOP  0x02
#define MCS_EXTSTART 0x04
#define MCS_EXTSTOP  0x08

struct AcqStpC_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    USHORT    usMxrInput;
    FLAGS     fsActiveInputs;
    struct    PDDAccess_S *  pstPDDMxrAccs;
    USHORT    usStartCh;     // not used 2/12/92
    USHORT    usNoChannels;  // not used 2/12/92
    USHORT    usAdcNo;
    USHORT    usInpDim1;               // Hierarchical location of ADC           // drd 3/15/95
    USHORT    usInpDim2;               // Hierarchical location of ADC           // drd 3/15/95
    FLAGS     fsOptions;    // 1 = Abort
    };

struct ClrDataC_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    BYTE      bClear;
    USHORT    usStartCh;
    USHORT    usNoChannels;
    FLAGS     fsPresetType;
    FLAGS     fsMxrInput;
    struct    PDDAccess_S *  pstPDDMxrAccs;
    USHORT    usCurGroupNo;
    USHORT    usActGroupNo;
    USHORT    usAdcNo;
    USHORT    usInpDim1;               // Hierarchical location of ADC           // drd 3/15/95
    USHORT    usInpDim2;               // Hierarchical location of ADC           // drd 3/15/95
    };

struct IcbDevC_S {
    FLAG      fWait;
    HMEM      hCAM;
    FLAG      fBusy;
    };


union  CParam_U {     // Control parameters union
    struct    AcqStaC_S  stAcqStaC;
    struct    AcqStpC_S  stAcqStpC;
    struct    ClrDataC_S stClrC;
    struct    NullP_S    stNullC;
    struct    InpP_S     stInpC;                                                 // drd 6/27/95
    struct    IcbDevC_S  stIcbDevC;
    };


/****** Query ********/

struct RWSVMaskQ_S {
    FLAGL  flRParam;
    FLAGL  flWParam;
    FLAGL  flSParam;
    FLAGL  flVParam;
    FLAGL  flCParam;
    };

struct McaQParam_S {
    FLAGS  fsFullMem;
    FLAGS  fsNoAdcs;
    FLAGS  fsPreset;
    FLAGS  fsAcqMode;
    FLAGS  fsCalcData;
    FLAGS  fsScaleData;
    USHORT usGroups;
    FLAGS  fsInput;                    // flags concerning inputs, such as if    // drd 3/14/95
                                       // they can be renamed                    // drd 3/14/95
    USHORT usDim1Limit;                // Limit on Dimension 1                   // drd 4/5/95
    USHORT usDim2Limit;                // Limit on Dimension 2                   // drd 4/5/95
    };

#define MCAQPARAM_NoRenameInp 0x01     // no rename of input                     // drd 3/14/95
#define MCAQPARAM_FixedDetType 0x02    // detector type can't change             // drd 9/5/95

struct MxrQParam_S {
    FLAGS  fsNofInputs;
    FLAGS  fsTimers;
    FLAGS  fsInputType;
    };

struct DevSport_S {
    FLAG   fMxr;
    FLAG   fDigStab;
    };

struct CntlQParam_S {
    FLAGS  fsCntl;
    SHORT  sNofAdjCtls;
    SHORT  sNofMidCtls;
    FLAG   fDevCtls;
    SHORT  sNofWizCtls;
    };

struct BoolStrngs_S {
    CHAR   szFalseStr[16];
    CHAR   szTrueStr[16];
    };


union Entries_U {
    float  rValue;
    CHAR   szValue[9];
    FLAG   fValue;
    };

struct Entries_S {
    CHAR   szLabel[12];
    union  Entries_U unV;
    };

struct CntlCQ_S {        // common
    SHORT  sCtlNum;
    SHORT  sCtlType;
    BYTE   bParamID;
    CHAR   szCaption[15];
    LONG   lAuxMask;
    };

struct PBCntlQ_S {       // push button
    SHORT  sCtlNum;
    SHORT  sCtlType;
    BYTE   bParamID;
    CHAR   szCaption[15];
    LONG   lAuxMask;
    CHAR   szLabel[12];
    FLAG   fValue;
    };

struct RBCntlQ_S {       // radio buttons
    SHORT  sCtlNum;
    SHORT  sCtlType;
    BYTE   bParamID;
    CHAR   szCaption[15];
    LONG   lAuxMask;
    BYTE   bNofEntries;
    struct Entries_S astEnt[3];
    BYTE   bLimitCtl;
    double dLimitConv;
    };

struct CBCntlQ_S {       // combo-box / drop-down
    SHORT  sCtlNum;
    SHORT  sCtlType;
    BYTE   bParamID;
    CHAR   szCaption[15];
    LONG   lAuxMask;
    BYTE   bNofEntries;
    struct Entries_S astEnt[40];
// -- Oct-97, it was [8].  The union grows from 188? to nearly 900.
    };

struct SBCntlQ_S {       // scroll bar (all types)
    SHORT  sCtlNum;
    SHORT  sCtlType;
    BYTE   bParamID;
    CHAR   szCaption[15];
    LONG   lAuxMask;
    CHAR   szUnits[4];
    float  rMin;
    SHORT  sStep;
    double dConv;
    SHORT  sCoarseInc;
    SHORT  sIncType;
    SHORT  sPlace;
    BYTE   bLimitingID;
    BYTE   bLimitCtl;
    SHORT  sFineInc;
    SHORT  sTotalSteps;
    };


struct ProtoQParam_S {
    SHORT  sCommType1;
    SHORT  sCommType2;
    };



union  QResult_U {     // Query results union
    struct    RWSVMaskQ_S   stRWSVMaskQ;
    struct    McaQParam_S   stMcaQPR;
    struct    MxrQParam_S   stMxrPR;
    struct    DevSport_S    stDevSportQR;
    struct    CntlQParam_S  stAdcQPR;
    struct    CntlQParam_S  stCntlQPR;
    struct    CntlCQ_S      stCntlCQ;
    struct    PBCntlQ_S     stPBCntlQ;
    struct    RBCntlQ_S     stRBCntlQ;
    struct    CBCntlQ_S     stCBCntlQ;
    struct    SBCntlQ_S     stSBCntlQ;
    struct    CntlQParam_S  stSmpCQPR;
    struct    CntlQParam_S  stMxrQPR;
    struct    CntlQParam_S  stDSQPR;
    struct    CntlQParam_S  stAmpQPR;
    struct    CntlQParam_S  stHvpsQPR;
    struct    CntlQParam_S  stPMQPR;
    struct    CntlQParam_S  stVacQPR;  // Query Vacuum Parameters                // drd 2/17/95
    struct    ProtoQParam_S stProQPR;
    struct    BoolStrngs_S  stBoolQR;
    CHAR                    szDevTypeQR[9];
    FLAGS                   fsCtlStatus;
    FLAGS                   fsProp;
    FLAG                    fProp;
    BYTE                    bElapType;
    struct    AdcParam_S    stAdcQDef;
    struct    AmpParam_S    stAmpQDef;
    struct    HVSParam_S    stHvsQDef;
    struct    VacParam_S    stVacQDef;
    struct    GainParam_S   stGainQDef;
    struct    CntlQParam_S  stGainQPR;
    struct    FltrParam_S   stFltrQDef;
    struct    CntlQParam_S  stFltrQPR;
    struct    DSParam_S     stDSQDef;
    struct    PISRParam_S   stPsrQPR;
    HMEM                    hCAM;
    };


//  bDevice #defines

#define MCA                0
#define ADC                1
#define MXR                2
#define DigStab            3
#define SmpChngr           4
#define Amp                5
#define HVPS               6
#define PreAmp             7
#define LFC                8
#define MCS                9
#define Protocol          10
#define PwrMgmt           11
#define Vacuum            12                                                     // drd 2/17/95
#define GainDSP           13
#define FilterDSP         14
#define PISR              15

//  bProtocol #defines

#define S100P              1
#define xx75P              2
#define AccuSpecATP        3
#define AccuSpecMCP        7
#define AIMP               9
#define GeniPortP         10
#define AAnalystP         11                                                     // drd 2/17/95
#define DesktopDSPP       12
#define ManualP           16
#define SerialP           17
#define ParallelP         18
#define ICBP              19
#define RPI_ICBP          20

//  usDeviceType #defines

#define S100          0x0100
#define S35Plus       0x0200
#define AccuSpecA     0x0300
#define AccuSpecB     0x0400
#define AccuSpecNaI   0x0500
#define AccuSpecNaIP  0x0600
#define AccuSpecMC    0x0700
#define AccuSpecFMS   0x0800
#define AIM           0x0900
#define GeniePort     0x0A00
#define AAnalyst      0x0B00                                                     // drd 2/17/95
#define InSpectNaI    0x0C00
#define DesktopInsp   0x0D00
#define AIMwithDSP    0x0E00
#define DesktopDSP    0x0F00

/* Following can be ORed with above, to further identify a device. */
#define Manual        0x1000
#define Internal      0x2000
#define Parallel      0x3000
#define ICB           0x4000
#define RPI_ICB       0x5000
#define EtherPlus     0x6000                                                     // drd 3/31/95
#define GAChanger     0x7000    /* Feb-96, == Serial ? */

#define SoftType      0x0080           // Bit in device type set (only) by software
#define VRMode        0x0080           // (One use of the 'SoftType' bit.)
                                       // Set, for vacuum device, indicates that the
                                       // vacuum works in VR (or anti-recoil) mode.
#define ICB_TYPE      0x007F           // (Mask off SoftType to look at ~.)

//  Query Types

#define RWSVMask           1
#define ReadProperties     2
#define WriteProperties    3
#define WizDeviceCtls      4
#define AdjDeviceCtls      5
#define MidDeviceCtls      6
#define CntlParam          7
#define CommType           8
#define BoolStrngs         9
#define DevType            10
#define ElapType           11
#define DevSupport         12
#define Defaults           13
#define ILLEGAL            30

//  Read/Write Types

#define ControlStatus      1
#define InputStatus        2
#define ErrorStatus        3
#define SpectData          4
#define McaMidParam        5
#define Mailbox            7
#define CalcuData          8
#define ScaledData         9
#define StatusAck          10

#define McaParam           20
#define SmpChngrParam      21
#define AdcParam           22
#define MxrParam           23
#define DigStabParam       24
#define AmpParam           25
#define PampParam          26
#define HVSParam           27
#define MCSParam           28
#define LFCParam           29
#define ICBDev             30
#define PwrMgtParam        31
#define ICBRegister        32
#define ICBModel           33
#define ICBSerial          34
#define VacParam           35                                                    // drd 2/17/95
#define GainParam          36
#define FltrParam          37
#define DSAParam           38
#define PISRParam          39


//  Control OpCodes

#define AcquireStart       101
#define AcquireStop        102
#define Clear              103
#define SmpChngrAdv        108
#define DV_AskInProcess    111  /* Added for SCHGR, Feb-96. */
/* - Note: ^^ is the same as AmpAPZStat, below. There is no
**  reason why each device needs its own op-code for the 'same'
**  function; ControlDSC directs op to specified device.
*/
#define AmpAPoleZero       110
#define AmpAPZStat         111      /* It is 1+ ^^; MCA-AJST assumes. */
#define HVPSReset          112
#define IcbPwrReset        114
#define DSOvrRngReset      115
#define VentForLoad        116         // control to vent chamber              // drd 3/16/95
#define EvacFromLoad       117         // control to evacuate chamber          // drd 3/16/95
#define FltrABDC           118
#define FltrABDCStat       119

#define SCHGR_ErrorX       103      /* Re-use Clear - See note. */
#define SCHGR_Init         104
#define SCHGR_InitW        105
#define SCHGR_Load         106
#define SCHGR_LoadW        107
#define SCHGR_Stop         109
#define SCHGR_Bump         110      /* Re-use PoleZero and its Wait. */
#define SCHGR_BumpW        111
#define SCHGR_Home         118
#define SCHGR_HomeW        119
#define SCHGR_UnLoad       120
#define SCHGR_UnLoadW      121

#define SCHGR_AdvanceOn    110      /* For new-AIM-internal, Jan-98 -- */
#define SCHGR_AdvanceOff   109      /* (Signal set\cleared by driver.) */

//  Mxr/Mux Elapsed time access types

#define BD_TIMERS          1     // timers on MCA board (1520)
#define CH1_2              2     // elapsed in 1st 2 channels (589)
#define MXR_TIMERS         3     // timers on MXR

#ifdef __cplusplus
}
#endif


/* ****************************** E-O-F ***************************** */
