/*
* ==========================================================================
* File:         citypes.h
*
* Purpose:      CI "portable" C functions:  This is the Canberra standard
*               include file for C data types.  It defines standardized data
*               types as necessary for various hardware/OS platforms to be
*               used by "portable" Canberra/ND software.  See also cimacros.h
*
* Notes:        The Symbol which defines the current platform environment
*               must be defined upon entry.  Further, within a platform,
*               symbols may be defined to indicate other environment info.
*
*               Symbol              Implies...          Defined by...
*               ----------------    ----------------    --------------------
*               OS2                 OS/2                compile command line
*                   M_I86           Intel 86 Family     Microsoft C Compiler
*                   OS2_INCLUDED    OS/2 .h files       os2.h
*
*               VAX                 VAX VMS or ULTRIX   VMS & ULTRIX C Compiler
*
*       mips            DEC MIPS        MIPS C Compiler
*
*       __ALPHA         DEC Alpha CPU   OpenVMS compiler
*
*               DOS                 MS-DOS
*                   M_I86           Intel 86 Family     Microsoft C Compiler
*
* Invocation:   #include <citypes.h>
*
* Inputs:       (see notes above)
* Outputs:      Standardized datatypes, etc. defined
*
* OS/2 Example: (if os2.h needed, #include before citypes.h)
*               #include <citypes.h>
*               #include "myapp.h"
*               compile >>> cl ... /DOS2 ... myapp.c
*
* Edits:         3/12/92    dsr     first edition.  Combined <cistd.h> and
*                                   <ndtypes.h>, and added some more.
*                3/17/93    sew     IBMC Changes
*                7/04/92    tlg     Added support for alpha systems.
*                3/03/93    rjh     VAX/Alpha: don't define NULL if already defined
*                4/01/93    dsr     added CI_SysTypALPHA to rjh's changes
*                3/19/96    sew     add conditionals for C++ support
* ==========================================================================
*/

/*
-------------------------------------
- Scope Macros:
-   private for within file
-   public  for explicitly stating it
- Bit Masks
- System Type Codes
-------------------------------------
*/
#define PRIVATE     static
#define PUBLIC

#define BIT0        0x0001
#define BIT1        0x0002
#define BIT2        0x0004
#define BIT3        0x0008
#define BIT4        0x0010
#define BIT5        0x0020
#define BIT6        0x0040
#define BIT7        0x0080
#define BIT8        0x0100
#define BIT9        0x0200
#define BIT10       0x0400
#define BIT11       0x0800
#define BIT12       0x1000
#define BIT13       0x2000
#define BIT14       0x4000
#define BIT15       0x8000

#define CI_SysTypOS2    1
#define CI_SysTypVMS    2
#define CI_SysTypMIPS   3
#define CI_SysTypDOS    4
#define CI_SysTypALPHA  5


/*
--------------------------------------------------------------------
- Define wierd stuff for platforms here:
-
- MHUGE:
-   use this keyword when declaring a pointer to an object which
-   could be larger then 65K bytes (i.e., spectral data arrays).
-   It will generate the "huge" keyword on I86XXX platforms and
-   nothing on the others.
-
- FAR:
-   use when declaring "far" pointers and functions in medium model.
-
- PASCAL:
-   use when declaring non-C convention for function call stack setup
--------------------------------------------------------------------
*/

#if defined(M_I86)

#define MHUGE      huge
#define FAR        far
#define PASCAL     pascal
#endif


/*
-------------------------------------------------
- OS/2 Definitions:
-   Don't redefine those aready in <os2.h>
-   Echo the defn's that os2.h, stdio.h, etc. use
-------------------------------------------------
*/

/* Faramarz */

#if defined(WIN32)

#define CI_OwnSysTyp        CI_SysTypOS2

/*#if !defined(OS2_INCLUDED)                                              SM$:O*/

#define VOID        void                    /* void                         */
#define CHAR        char                    /*  8 bit signed int            */
#define SHORT       short                   /* 16 bit signed int            */
#define INT         int                     /* "natural" length signed int  */
#define LONG        long                    /* 32 bit signed int            */
typedef unsigned    char    BYTE;           /*  8 bit unsigned int          */
typedef unsigned    char    UCHAR;          /*  8 bit unsigned int          */
typedef unsigned    short   USHORT;         /* 16 bit unsigned int          */
typedef unsigned    int     UINT;           /* "natural" length unsigned int*/
typedef unsigned    long    ULONG;          /* 32 bit unsigned int          */
/*typedef unsigned    int     BOOL;*/           /* "natural" length    (boolean)*/
/* #endif*/ /* !OS2_INCLUDED */

typedef unsigned    char    UBYTE;          /*  8 bit unsigned int          */
#define REAL        float                   /* 32 bit float (IEEE format)   */
#define DOUBLE      double                  /* 64 bit float (IEEE format)   */
typedef unsigned    short   FLAG;           /* "natural" length    (boolean)*/
typedef unsigned    char    FLAGB;          /*  8 bit unsigned int (bitmask)*/
typedef unsigned    short   FLAGS;          /* 16 bit unsigned int (bitmask)*/
typedef unsigned    long    FLAGL;          /* 32 bit unsigned int (bitmask)*/

/*#if !defined(OS2_INCLUDED)                                              SM$:O*/

#if (!defined(__IBMC__) && !defined(__IBMCPP__))
#if (defined(M_I86SM) || defined(M_I86MM))
#define NULL                0
#else
#if (defined(M_I86L) || defined(M_I86CM) || defined(M_I86LM) || defined(M_I86HM))
#define NULL                0L
#else
/*#define NULL                0*/
#endif
#endif
/*#endif*/

#define TRUE                1
#define FALSE               0
/* typedef unsigned    short   SEL;                                        SM$:O*/
typedef unsigned    short   USHORT;

#ifdef COM
#if (!(defined(_AFXDLL) || defined(_USRDLL)))
typedef void  *          HWND;
#endif
#endif
/*typedef unsigned char * PSZ;*/

/*#endif*/ /* !OS2_INCLUDED */

/* #define HMEM                SEL                                         SM$:O*/
/*#define HMEM                USHORT           Redefined in crackers as a void */

#endif /* OS2 */

#endif /* WIN32 */


/*
------------------
- VAX Definitions:
-   VMS and ULTRIX
------------------
*/
#if defined(VAX)

#define CI_OwnSysTyp        CI_SysTypVMS

#define VOID        void                    /* void                         */
typedef char                CHAR;           /*  8 bit signed int            */
typedef short       int     SHORT;          /* 16 bit signed int            */
typedef int                 INT;            /* "natural" length signed int  */
typedef int                 LONG;           /* 32 bit signed int            */
typedef unsigned    char    UCHAR;          /*  8 bit unsigned int          */
typedef unsigned    char    BYTE;           /*  8 bit unsigned int          */
typedef unsigned    char    UBYTE;          /*  8 bit unsigned int          */
typedef unsigned  short int USHORT;         /* 16 bit unsigned int          */
typedef unsigned    int     UINT;           /* "natural" length unsigned int*/
typedef unsigned    int     ULONG;          /* 32 bit unsigned int          */
typedef float               REAL;           /* 32 bit float (DEC format)    */
typedef double              DOUBLE;         /* 64 bit float (IEEE format)   */
typedef unsigned    int     BOOL;           /* "natural" length    (boolean)*/
typedef unsigned    int     FLAG;           /* "natural" length    (boolean)*/
typedef unsigned    char    FLAGB;          /*  8 bit unsigned int (bitmask)*/
typedef unsigned    short   FLAGS;          /* 16 bit unsigned int (bitmask)*/
typedef unsigned    long    FLAGL;          /* 32 bit unsigned int (bitmask)*/
#define HMEM        long
typedef void  *          HWND;
typedef unsigned char * PSZ;
#define TRUE                1
#define FALSE               0
#ifndef NULL
#define NULL            0
#endif

#endif /* VAX */


/*
-------------------
- MIPS Definitions:
-------------------
*/
#if defined(mips) || defined(ultrix) || defined(RISC)

#if (!defined (CI_OwnSysTyp))
#define CI_OwnSysTyp        CI_SysTypMIPS

#define VOID        void                    /* void                         */
typedef char                CHAR;           /*  8 bit signed int            */
typedef short       int     SHORT;          /* 16 bit signed int            */
typedef int                 INT;            /* "natural" length signed int  */
typedef int                 LONG;           /* 32 bit signed int            */
typedef unsigned    char    UCHAR;          /*  8 bit unsigned int          */
typedef unsigned    char    BYTE;           /*  8 bit unsigned int          */
typedef unsigned    char    UBYTE;          /*  8 bit unsigned int          */
typedef unsigned  short int USHORT;         /* 16 bit unsigned int          */
typedef unsigned    int     UINT;           /* "natural" length unsigned int*/
typedef unsigned    int     ULONG;          /* 32 bit unsigned int          */
typedef float               REAL;           /* 32 bit float (DEC format)    */
typedef double              DOUBLE;         /* 64 bit float (IEEE format)   */
typedef unsigned    int     BOOL;           /* "natural" length    (boolean)*/
typedef unsigned    int     FLAG;           /* "natural" length    (boolean)*/
typedef unsigned    char    FLAGB;          /*  8 bit unsigned int (bitmask)*/
typedef unsigned    short   FLAGS;          /* 16 bit unsigned int (bitmask)*/
typedef unsigned    long    FLAGL;          /* 32 bit unsigned int (bitmask)*/
#define HMEM        long
typedef void  *          HWND;
typedef unsigned char * PSZ;
#define TRUE                1
#define FALSE               0
#define NULL                0

#define FAR
#define PASCAL

#endif /* !defined (CI_OwnSysTpe) */

#endif /* MIPS */


/*
------------------
- ALPHA Definitions:
-   OpenVMS and OSF
------------------
*/
#if defined(__ALPHA)

#define CI_OwnSysTyp        CI_SysTypALPHA

#define VOID        void            /* void             */
typedef char            CHAR;       /*  8 bit signed int        */
typedef short       int     SHORT;      /* 16 bit signed int        */
typedef int         INT;        /* "natural" length signed int  */
typedef int         LONG;       /* 32 bit signed int        */
typedef unsigned    char    UCHAR;      /*  8 bit unsigned int      */
typedef unsigned    char    BYTE;       /*  8 bit unsigned int      */
typedef unsigned    char    UBYTE;      /*  8 bit unsigned int      */
typedef unsigned  short int USHORT;     /* 16 bit unsigned int      */
typedef unsigned    int     UINT;       /* "natural" length unsigned int*/
typedef unsigned    int     ULONG;      /* 32 bit unsigned int      */
typedef float           REAL;       /* 32 bit float (DEC format)    */
typedef double          DOUBLE;     /* 64 bit float (IEEE format)   */
typedef unsigned    int     BOOL;       /* "natural" length    (boolean)*/
typedef unsigned    int     FLAG;       /* "natural" length    (boolean)*/
typedef unsigned    char    FLAGB;      /*  8 bit unsigned int (bitmask)*/
typedef unsigned    short   FLAGS;      /* 16 bit unsigned int (bitmask)*/
typedef unsigned    long    FLAGL;      /* 32 bit unsigned int (bitmask)*/
#define HMEM        long
typedef void *      HWND;
typedef unsigned char * PSZ;
#define TRUE            1
#define FALSE           0
#ifndef NULL
#define NULL            0
#endif

#endif /* __ALPHA */

