// SM$:FO  F:\CANBERRA\GENIE\INCLUDE\CI_FILES.H - 08/14/96 16:04:32        
/* ************************** CI$FILES.H ******************************** *
 * Author: L.Stone                                      Origin: 19-Jan-90 *
 * ---------------------------------------------------------------------- *
 * Purpose:                                                               *
 *  - Define the type-codes to be stored in the standard header of the CI *
 *  files - with their associated default extensions, AND the environment *
 *  variables used to define their default locations at the server.       *
 *                                                                        *
 *  - As a natural extension, define type-codes and extensions for        *
 *  the 'foreign' files we expect to support.  (These will also be used   *
 *  as 'usFileType' in the CSI messages to the VDM server.)               *
 * ---------------------------------------------------------------------- *
 * Notes:                                                                 *
 *  - Used by : The VDM & CSI, the Nuclide Editor and the Input           *
 *    Configurator.                                                       *
 * ---------------------------------------------------------------------- *
 * History:                                                               *
 *  24-Jan-90, LES:  Add support for temp files (at the client !).        *
 *  21-Feb-90, LES:  Add CIF_Hardware, CIF_McaAssoc, CIF_NucUnits.        *
 *  06-Jul-90, LES:  Change the names / extension for MID files.          *
 *                   (Most of the 'native' types should go away.)         *
 *  30-Nov-90, LES:  Add 'file' object types for 'run-time-DB'.           *
 *                   'Access-List' has gone away.                         *
 *  21-Dec-90, dsr:  Add AEF definitions                                  *
 *  22-Jan-91, LES:  Name an EV_VDM_MAXFH -- as a 'reminder'.             *
 *                   Changes / deletions based on a recent RLS memo.      *
 *  13-Feb-91, LES:  A 'hook' for the VDM 'workspace' file.               *
 *  04-Mar-91, LES:  CIX_InputWork (there's only one -- why bother ?).    *
 *   5-Mar-91, dsr:  Add ASEQFILES, RPTFILES, CALFILES, most per RLS memo *
 *  14-Mar-91, LES:  (Merging the last three, plus) Rid of some obsoletes.*
 *  16-may-91, dsr:  changed AEFGE, AEFNAI, to GAMMAAEF.  Added GAMMAPL   *
 *  21-may-91, dsr:  deleted GAMMAPL - we decided no PL in Auto Cal       *
 *                   put quotes (") around strings for ASEQFILES, etc.    *
 *  15-Oct-91, LES:  Add literals *.NLB and *.CTF.                        *
 *  25-May-93, dsr:  added EV_MCAPREFS defn                               *
 *   7-apr-94, dsr:  added EV_ALPHAAEF defn                               *
 *  15-aug-94, dsr:  added EV_ALPHASEQ defn                               *
 * ********************************************************************** */

// #define EV_LOGON     "DS_LOGON"  // (Declared in GLOBALS.H.)
    /*  A datasource thread at the VDM will wait only this long for a
     *  'logon' message, before disconnecting.  (Default is 30==3.0 secs.)
     */
#define  EV_VDM_MAXFH   "MAX$FILE$HANDLES"
    // The VDM will use 255 as MaxFH unless this. 

#define  CIF_Hardware       0
    /*  The 'object type' for inputs and counters, in the data-source
     *  'context' (at both ends) - also used as 'not a file'.
     */

#define  EV_CAMFILES        "CAMFILES"
#define  CIF_NativeSpect    1
#define  CIX_NativeSpect        "*.CNF"


#define  CIF_InputDefn      3
#define  CIX_InputWork          "*.MIX"
#define  CIX_InputDefn          "*.MID"
    //  Note that the above extension is fixed.
#define  EV_INPUT_DEFN   "MCA$DEFINES"

#define  VDM_WSP                "VDM"
    //  This is the (root) NAME of the VDM's 'workspace' file (the
    //  list of loaded .MID files).  It is WITH the .MID files.

#define  CIX_WorkSpace          "*.WSP"
    // (Used by the PM 'shell')

#define  EV_MCAPREFS        "MVCPREFS"
    // used by mca_pref.c & others

/* ------------- Temporary --------------- */

#define  EV_Temporary  "VDM$TEMPS"
    // (The directory to be used for 'temp' files at the VDM.)


/* ------------- Client ------------------ */

#define  CIX_ROIFILES       "*.ROI"
#define  CIX_AEFFILES       "*.AEF"
#define  EV_GAMMAAEF    "GAMMAAEF"
#define  EV_ALPHAAEF    "ALPHAAEF"
    //  Analysis Engine (AEF) Files -- full path/name.
    //  Used for all: Ge, NaI, Alpha, etc.

#define  CIX_ASEQFILES      "*.ASF"
#define  EV_ASEQFILES   "ASEQFILES"
#define  EV_ALPHASEQ    "ALPHASEQ"
    //  Auto sequence files (gamma & alpha) -- full directory path.

#define  CIX_CALFILES       "*.CAL"
#define  EV_CALFILES    "CALFILES"
    //  Calibration files -- full directory path.
    //  (.ASF & .CAL files are 'special' .CNF files.)
    //  (That is: .CNF files saved for special purposes.)

#define  CIX_RptTemplate        "*.TPL"
#define  EV_RTPLFILES   "RTPLFILES"
    //  Input files to the report engine; EV has full path.

#define  CIX_ReportFile         "*.RPT"
#define  EV_RPTFILES    "REPFILES"
    //  Report Files -- full directory path.
    //  (The output OF the report engine.)
#define  CIX_CAMDirectFile      ".TEM"


/* -- These next two have no default locations, but do have extensions. */

#define  CIX_NuclideLib         "*.NLB"
    //  Default extension for files saved by Nuclide-Lib Editor.

#define  CIX_Certificate        "*.CTF"
#define  CIX_CertifPartial      "*.CTP"
#define  CIX_CertifAll          "*.CT?"
#define  CIX_CertExt            ".CTF"
#define  CIX_CertPartExt        ".CTP"

    //  Default extension for files saved by Certificate Editor.

/* --------------- 'Other' --------------- */
/*  For the record - values are not used.  */
/* (All but 'drivers' are ASCII text. )    */

#define  EV_NETWORK_FG   "CINETCFG"
        // (Hard coded in IPC - GetConfig - today, Jan-91.)
        // (The EV has full path name of the network config file.)

#define  CIF_BatchFiles     0x203
#define  CIX_BatchFiles         "*.JOB"

#define  CIF_McaDriver      0x205
#define  CIX_McaDriver          "*.DRV"
#define  EV_MCADRIVERS   "MCA$DRIVERS"
    //  This location is almost certainly fixed.
    //  Our other drivers - protocol, front-end, ..

#define CIF_McaAssoc        0x206
#define CIX_McaAssoc            "*.DRD"
    //  The 'Driver Definition' files.
    //  By definition - same root and path as the associated .DRV.

#define  CIF_NucUnits       0x207
#define  EV_NUCLIBUNITS  "NUCLIBUNITS"
    //  The EV has the full path and name of the file.
    //  Used by the Nuclide Editor to name user's units, and
    //  the conversion factors to internal units.


/* --------------- 'R-T-D-B'-------------- */

#define  CIF_Detector   0x301
#define  CIF_Counter    0x302
    //  The open 'object' is one of the above.
    //  (There is an associated 'native' file also !)
#define  CIF_Member     0x303

/* *************************** End of File ****************************** */
