/* ******************************< CAMINFO.H >************************* *
 * Editor: L.Stone                                    Origin: 20-Mar-91 *
 * -------------------------------------------------------------------- *
 * Purpose:                                                             *
 *  Describe the structure returned by MID's fQueryCAM.                 *
 *  Also used by SAD's QueryCAM.                                        *
 * -------------------------------------------------------------------- *
 * Notes:                                                               *
 * - 25-Apr-91 - RType is 24 ('via descriptor') for strings, contrary   *
 *  to expectations.                                                    *
 * -------------------------------------------------------------------- *
 * History:                                                             *
 *  03-May-91, LES:  Define the 'bit' return-type, with note.           *
 *  26-Feb-94, LES:  Change to 'own' names, for cleanup.                *
 *  09-Jul-94, LES:  Rid of //'s.                                       *
 *  08-Apr-98, LES:  Add the struct returned by SadQueryExCAM().        *
 * ******************************************************************** */

typedef
struct InfoCAM_S {

    ULONG  ulParam; /* The actual (CAMPDEF.H) parameter number. */
    USHORT usRType; /* The CAM 'return type' - see below.       */
    USHORT usSize;  /* Bytes IN value (4 or 8 except strings).  */
    char   acName[13];  /* The name OF the param, from the schema.  */
    char   acDesc[33];  /* Its description, likewise.           */

    } InfoCAM_T;

/* -- The values expected in usRType --
*/
#define CAM_DTYPE_L   8     /* longword */
#define CAM_DTYPE_F   10    /* float */
#define CAM_DTYPE_DSC 24    /* text string via descriptor */
#define CAM_DTYPE_G   27    /* double float (IEEE format) */
#define CAM_DTYPE_ADT 35    /* absolute date-time */
#define CAM_DTYPE_DT  192   /* delta date-time (not a DEC definition) */

#define CAM_DTYPE_BIT  1
    /* - 3-May-91, for compatibility with BDTDEF.H.
    **  If the _L param represents a boolean, that is, its flag-word
    **  contains the BDT_M_BIT bit -- QueryCAM will show this as
    **  usRType; the actual return value is the expected LONG.
    */

/* -------
**  The following are NOT expected in Genie-PC -
**  but are included for completeness. (Some of
**  our code expects _T as well as _DSC.)
*/
#define CAM_DTYPE_BU  2     /* unsigned byte */
#define CAM_DTYPE_WU  3     /* unsigned word */
#define CAM_DTYPE_B   6     /* byte */
#define CAM_DTYPE_W   7     /* word */
#define CAM_DTYPE_Q   9     /* quadword */
#define CAM_DTYPE_T   14    /* text string */

/* ============================================== */

typedef
struct ExInfoCAM_S {

    ULONG  ulParam;
    USHORT usRType;
    USHORT usSize;
    char   acName[13];
    char   acDesc[33];

    USHORT usPType;     /* See BDTDEF.h, BDT_C_, Param-type codes. */
    USHORT usBType;     /* See BDTDEF.h, BDT_C_, Block-type codes. */
    USHORT usCType;     /* See BDTDEF.h, BDT_C_, Conversion codes. */
    USHORT fsFlags;     /* See BDTDEF.h, BDT_M_, Flag bits.        */
    ULONG  flDirty;     /* 'Advice' bit[s] for this param.         */
    ULONG  ulOffer;

    } ExInfoCAM_T;

/* *************************** End of File **************************** */
