/*
* ==========================================================================
* Name:         anadefs.h
* Project:      OS/2 Analysis Functions
* System:       OS/2 v1.2
* Compiler:     MSC v5.1
*
* Purpose:      Various defintions for ALL Analysis functions
*
* Invocation:   #include "anadefs.h"
*
* Edits:         3/22/90  dsr   first edition
*                6/21/90  dsr   moved HMEM def to spasst.h
*                9/10/90  dsr   added efcal codes
*                9/14/90  dsr   moved encal eq defs here from get_put
*               11/13/90  dsr   del MAX_EQTYPE.
*                               Use CAM_N_ECALTYPE or CAM_N_TYPICAL.
*                5/31/91  dsr   Added bad file codes
*                6/17/91  dsr   Took out ANA_PoorFit - a CAM bit, instead
*                8/28/91  dsr   . added bad sample data code
*                               . added no fwcal, no efcor, etc. codes
*                8/30/91  dsr   added background error codes
*                3/23/92  dsr   made "portable"
*                6/15/93  dsr   added codes for engine rc2 values via pv1
*                7/29/93  dsr   added BadPLSort - see panolin.c
*                1/13/94  LES   Add e-c-des for the RefPeak engine.
*                1/19/94  dsr   reserved blocks for attenuation correction
*                               and for acquisition phases
*                4/11/94  sew   add ACQENG message
*                6/03/94  dsr   add several codes for Alpha engines
*                7/05/94  LES   Add the 'pv2' hook - see PV2_xxx.
*                8/12/94  LES   Change report 'pv2'; compiled conditionally.
*                9/27/95  LES   Change report 'pv2'.
*                4/17/96  dsr   added codes for ASD (Andrew Werger)
*                7/17/96  drd   added codes for Control Recovery
*                9/10/96  tda   added codes for CNUCS
*                11/22/96 tda   added codes for fitting
* ==========================================================================
*/

#define ANA_OK              0x00000000L /* can count on 0 to be okay    */

/*
---------------------------
- General Errors / Warnings
---------------------------
*/
#define ANA_NoSupport       0x00610001L /* not supported by this engine */
#define ANA_RoiTooSmall     0x00610002L /* roi too small to solve for   */
                                        /* User spec'd ROI for encal,   */
                                        /* or calc'd by 'caller' in PA  */
#define ANA_TooFewPts       0x00610003L /* too few pts. for calculation */
#define ANA_TooManyNucLines 0x00610004L /* too many lines for arrays    */
#define ANA_BadEqType       0x00610005L /* unsupported equation type    */
#define ANA_NoEncal         0x00610006L /* no encal results to use      */
#define ANA_NoEfcal         0x00610007L /* no efcal results to use      */
#define ANA_NoFwcal         0x00610008L /* no fwhm cal results to use   */
#define ANA_NoT1cal         0x00610009L /* no tail1 cal results to use  */
#define ANA_NoT2cal         0x0061000AL /* no tail2 cal results to use  */
#define ANA_NoPL            0x0061000BL /* no Pk Locate results to use  */
#define ANA_NoPA            0x0061000CL /* no Pk Area results to use    */
#define ANA_NoPLPA          0x0061000DL /* no Pk Search results to use  */
#define ANA_NoNuclib        0x0061000EL /* no Nuclide Library info      */
#define ANA_TooManyNuclides 0x0061000FL /* too many nuclides for arrays */
#define ANA_NoEfcalDual     0x00610010L /* no DUAL efcal results to use */
#define ANA_BadSetupData    0x00610011L /* setup data invalid for engine*/
#define ANA_BadExpData      0x00610012L /* expected data invalid (other */
                                        /* than from setup (e.g. ELIVE) */
#define ANA_BadSmpData      0x00610013L /* sample data invalid for eng  */
#define ANA_NoEC            0x00610014L /* no Efcor results to use      */
#define ANA_Cps0            0x00610015L /* CPS (i.e. area) of 0         */
#define ANA_Eff0            0x00610016L /* efficiency of 0              */
#define ANA_NoNID           0x00610017L /* no NID info                  */
#define ANA_EncalSetupMiss  0x00610018L /* no energy cal info           */
#define ANA_BadFileBack     0x00610020L /* !found or open err - backgnd */
#define ANA_BadFileLib      0x00610021L /* !found or open err - library */
#define ANA_BadFileInt      0x00610022L /* !found or open err - interf  */
#define ANA_BadFileCert     0x00610023L /* !found or open err - certif  */
#define ANA_BadContinParams 0x00610024L /* bad params to rContin()      */
#define ANA_TooManyPksInRoi 0x00610025L /* too many pks in ROI          */
#define ANA_NoMpletsAllowed 0x00610026L /* no mplets allowed in dsource */

/*
--------------------------
- reserved for Acquisition
-     x610050 - 610099
--------------------------
*/
#define ANA_InputBusy       0x00610050L /* input busy                   */

/*
---------------------------
- Energy Calibration Errors
---------------------------
*/
#define ANA_SingleMatrix    0x00610100L /* singular - no solution       */
#define ANA_EncalUnused     0x00610101L /*                              */
#define ANA_CantFindPeak    0x00610102L /* couldn't find a peak         */
#define ANA_CantFitPeak     0x00610103L /* couldn't fit a peak w/gaufit */
#define ANA_InsufData       0x00610104L /* insuf data for req'd calcs   */
#define ANA_InsufMem        0x00610105L /* insuf memory for dynamic vars*/

/*
-------------------------------
- Efficiency Calibration Errors
-------------------------------
*/
#define ANA_EmptyEFlist     0x00610200L /* no peaks in efficiency list  */

/*
--------------------
- Peak Locate Errors
--------------------
*/
#define ANA_EmptyLib        0x00610300L /* no nuclides/lines in lib     */
#define ANA_LibCorrupt      0x00610301L /* missmatch in lib entries     */

/*
------------------
- Peak Area Errors
------------------
*/
#define ANA_CantDoMplet     0x00610400L /* can't resolve multiplet      */
#define ANA_TooManyPeaks    0x00610401L /* too many peaks from pk locate*/
#define ANA_BadPLSort       0x00610402L /* PL centroids out of order    */

/*
-------------------------------------
- reserved for Attenuation Correction
-         x610500 - 610550
-------------------------------------
*/

/*
------------------------
- Area Correction Errors
------------------------
*/
#define ANA_NoBkgPA         0x00610600L /* no Pk Area results to use    */
#define ANA_NoBkgPLPA       0x00610601L /* no Pk Search results to use  */
#define ANA_NoMatchPeak     0x00610602L /* No peak matches ref/tracer pk*/
    /* - These => last 2 could be ANA_Bad 'secondaries', if not
     *  for an MJK batch requirement.                       */
#define ANA_SetHalfLife     0x00610603L /* Setup half-life is zero  */
#define ANA_ExpPeakArea     0x00610604L /* Peak has zero net counts */

/*
------------
- NID Errors
------------
*/
#define ANA_NoIDs           0x00610650L /* none of the nuclides id'd    */
#define ANA_NoEfcalOrTracer 0x00610651L /* No efcal or tracer info      */

/*
----------------------------
- Activity Correction Errors
----------------------------
*/
#define ANA_UnexpIntrfErr   0x00610700L /* unexpected return from INTRF */
#define ANA_IncompatAC      0x00610701L /* incompat prev AC - rej'd nuc */
                                        /* or line - !IDENT or !NLPEAK  */

/*
----------------------------
- Control Recovery Errors
----------------------------
*/
#define ANA_NuclNotPresent  0x00610800L /* unexpected return from INTRF */

/*
------------------------
- reserved for ASD Codes
-   x611000 - x611FFF
------------------------
*/
#define ANA_ErrOpenHigh     0x00611000L /* Error opening high energy file */
#define ANA_MGABadStart     0x00611001L /* Improper functioning of MGAPC */
#define ANA_MGANoCalPk      0x00611002L /* 129 or 208 keV peak too small in low energy spectrum */
#define ANA_MGALowCount     0x00611003L /* Number of counts in low energy spectrum too low */
#define ANA_MGASngMatrix    0x00611004L /* Matrix is singular */
#define ANA_MGANegativePu   0x00611005L /* Negative result for Pu-239, Pu-240, or Pu-241 */
#define ANA_MGALow100Count  0x00611006L /* Insufficient counts in 100 keV region */
#define ANA_MGAOtherError   0x00611007L /* MGA Analysis Error */
#define ANA_MGAUBadStart    0x00611008L /* Improper functioning of MGAUPC */
#define ANA_MGAUNoCalPk     0x00611009L /* 98 or 185 keV peak not found or too small */
#define ANA_MGAULowCount    0x0061100AL /* Number of counts too low */
#define ANA_MGAUPuFound     0x0061100BL /* Pu is detected: use MGA */
#define ANA_MGAUOtherError  0x0061100CL /* MGAU Analysis Error */
#define ANA_CNUCSInvBounds  0x0061100DL	/* CNUCS library attenuation E-limits are not equal */
#define ANA_CNUCSNoLines    0x0061100EL	/* CNUCS there are no lines to analyze */
#define ANA_CNUCSDetDist0   0x0061100FL	/* CNUCS detector distance is zero */
#define ANA_CNUCSTransLT0   0x00611010L	/* CNUCS transmission ratio <= 0.0 */
#define ANA_CNUCSNoBasicF   0x00611011L	/* CNUCS there is no basic feasible solution */
#define ANA_CNUCSNumSegLT0  0x00611012L   /* CNUCS number of segments <= 0 */
#define ANA_CNUCSBadSmpFile 0x00611013L   /* CNUCS nonexistent sample file */
#define ANA_CNUCSSegNoTrans 0x00611014L   /* CNUCS segment has no transmission data */
#define ANA_CNUCSNoAbsRes   0x00611015L   /* CNUCS segment has no absorption correction results */
#define ANA_CNUCSBadAbsRes  0x00611016L   /* CNUCS segment has invalid absorption correction results */
#define ANA_CNUCSNoEffCal   0x00611017L   /* CNUCS efficiency calib not done for segment */
#define ANA_CNUCSNoPeakSrch 0x00611018L   /* CNUCS peak search not done for segment */
#define ANA_CNUCSBadMSSSetup 0x00611019L  /* CNUCS MSS setup parameters invalid */
#define ANA_CNUCSBadNumSect 0x0061101AL   /* CNUCS invalid number of sectors */
#define ANA_CNUCSBadRPData  0x0061101BL   /* CNUCS invalid reference peak (for DT corr) data */
#define ANA_CNUCSBadEffCal  0x0061101CL   /* CNUCS invalid efficiency calibration */
#define ANA_CNUCSGetEffCal  0x0061101DL   /* CNUCS error getting efficiency calibration */
#define ANA_CNUCSGetErgCal  0x0061101EL   /* CNUCS error getting energy calibration */
#define ANA_CNUCSCalcROILim 0x0061101FL   /* CNUCS error calculating ROI limits */
#define ANA_CNUCSROIEffLE0  0x00611020L   /* CNUCS ROI Efficiency <= 0 */
#define ANA_CNUCSROIPALE0   0x00611021L   /* CNUCS ROI Peak Area <= 0 */
#define ANA_CNUCSFPIROI2Big 0x00611022L   /* CNUCS ROI region too big in FindPeakArea */
#define ANA_CNUCSNoEffLib	0x00611023L   /* CNUCS the lines source effic library does not exist */
#define ANA_CNUCSNoRefE     0x00611024L   /* CNUCS there is not reference energy within limits */
#define ANA_MATHNoOptSol    0x00611025L   /* No optimal solution */
#define ANA_MATHMaxIter		0x00611026L   /* Max iterations reached */
#define ANA_CNUCSCThick0	0x00611027L   /* Container thickness is 0 */
#define ANA_CNUCSNoGeomPath 0x00611028L   /* Geometry file path undefined */
#define ANA_CNUCSGeomMissM	0x00611029L	  /* Geometry file does not match analysis file */
#define ANA_MATHAbortFit	0x0061102AL	  /* Fitting process aborted */

/*
--------------------------------------------------------------------------
-                       rc2 values via pv1                               -
-                                                                        -
- These values are returned from engines via the pv1 argument under the  -
- "primary rc" conditions listed below.  These values should continue to -
- be in ascending order to match the list of string IDs in GSA.          -
-                                                                        -
- ANA_BadSetupData   >>>    ANA_Set...  setup data invalid for engine    -
- ANA_BadExpData     >>>    ANA_Exp...  expected data invalid - other    -
-                                       than from setup (e.g. ELIVE)     -
- ANA_BadSmpData     >>>    ANA_Smp...  sample data invalid for eng      -
-                                                                        -
--------------------------------------------------------------------------
*/
#define ANA_SetStartStop    0x00000000L /* start/stop channels invalid  */
#define ANA_SetSignif       0x00000001L /* significance level <= 0      */
#define ANA_SetProcClsMiss  0x00000002L /* CAM_MISSING on WST_CommonPA  */
#define ANA_SetContinChans  0x00000003L /* Number of contin chans <= 0  */
#define ANA_SetTolerance    0x00000004L /* energy or varfwhm tol is <0  */
#define ANA_SetBkgFile      0x00000005L /* expback is null for bks sub  */
#define ANA_SetNIDFile      0x00000006L /* explib  is null for NID      */
#define ANA_SetEITime_Vol   0x00000007L /* expos | irrad < 0, or Vol<= 0*/
#define ANA_SetConfMDAConf  0x00000008L /* NID/MDA Confid out of range  */
#define ANA_SetTracerData   0x00000009L /* <=0 Tracer rate, err, energy */
#define ANA_SetBadRefData   0x00000010L /* <=0 Ref date, hlife          */
#define ANA_SetControlData  0x00000011L /* <=0 Control rate, err, energy*/

#define ANA_ExpChans        0x00000016L /* Number of channels is <= 0   */
#define ANA_ExpElive        0x00000017L /* Elapsed Live Time is <= 0    */
#define ANA_ExpPlive        0x00000018L /* Pileup ELive Time is <= 0    */
#define ANA_ExpBkElive      0x00000019L /* Bkg Elapsed Live Time is <= 0*/
#define ANA_ExpCurPeak      0x00000020L /* spec'd peak <= 0 or missing  */
#define ANA_ExpRoiLoHi      0x00000021L /* ROI start/stop chans invalid */
#define ANA_ExpEncalCurves  0x00000022L /* spec'd encal curves not sup'd*/
#define ANA_ExpEncalTerms   0x00000023L /* spec'd order out of range    */
#define ANA_ExpEfcalCross   0x00000024L /* efcal crossover energy < 0   */  
#define ANA_ExpEfcalDTerms  0x00000025L /* DUAL      order out of range */
#define ANA_ExpEfcalETerms  0x00000026L /* EMPIRICAL order out of range */
#define ANA_ExpEfcalLTerms  0x00000027L /* LINEAR    order out of range */
#define ANA_ExpARL_Time     0x00000028L /* Acq, Real, or Live Time <= 0 */
#define ANA_ExpExpTime      0x00000029L /* Exposure (buildup) Time < 0  */

#define ANA_Smp             0x00000031L

/* ******************************* End of File ************************** */

