#include <stdio.h>
#include <windows.h>
#include "mmp.h"


char ID[256];
PHYSICAL_MEMORY_INFO pmi;
PVOID pPartyMem = NULL;
char *aInterfaceType[] =  {"Internal",
                           "Isa",
                           "Eisa",
                           "MicroChannel",
                           "TurboChannel" };


ULONG __stdcall Add(ULONG a, ULONG b)
  {
  return a+b;
  // outp(0x378,0x00);    // here outp() is allowed
  }
 

void main(void)
  {
  printf("This is a test of MMP driver\n");


  // OPEN

  printf("Try to open the driver...\n");
  if (MMPOpen())
    {
    printf("  ERROR: can't open!\n");
 	exit(1);
    }
  printf("  Open OK!\n");


  // GET ID

  printf("Try to get driver ID...\n");
  MMPGetID(ID);
  printf("  ID = %s\n", ID);


  // MAP MEMORY

  printf("Try to map some memory...\n");

  pmi.InterfaceType       = Isa;                // 1 = Isa, 2 = Eisa, 3 = Microchannel, 4 = TurboChannel
  pmi.BusNumber           = 0;                  // bus number, i.e. 0 for standard x86 ISA systems
  pmi.BusAddress.QuadPart = (LONGLONG)0xD0000;  // physical address to map
  pmi.AddressSpace        = 0;                  // 0 = memory, 1 = I/O
  pmi.Length              = 10;                 // length of section to map

  printf ("  InterfaceType = %s\n",   aInterfaceType[pmi.InterfaceType]);
  printf ("  BusNumber     = %d\n",   pmi.BusNumber);
  printf ("  BusAddress    = 0x%x\n", (int)pmi.BusAddress.QuadPart);
  printf ("  AddressSpace  = %d\n",   pmi.AddressSpace);
  printf ("  Length        = 0x%x\n", pmi.Length);
  printf ("  sizeof(pmi)     = %d\n", sizeof(pmi));
  printf ("  BusAddress.High = 0x%x\n", *((DWORD*)&pmi.BusAddress+1));
  printf ("  BusAddress.Low  = 0x%x\n", *((DWORD*)&pmi.BusAddress+0));

  if (MMPMapUserPhysicalMem(pmi, &pPartyMem))
    {
    printf("  Error: can't map memory!\n");
    }
  else
    {
	printf("  Memory mapping OK!\n");
    printf("    pPartyMem = 0x%x\n", (int)pPartyMem);
    printf("    *pPartyMem = 0x%x\n", *((int*)pPartyMem));
  
    MMPUnmapUserPhysicalMem(pPartyMem);
    }


  // IMP & OUTP

  printf("Try to access to IO bus...\n");
  printf("  outp(0x378, 0x00)\n");
  MMPOutp(0x378, 0x00);
  printf("  inp(0x378) = 0x%X\n", (int)MMPInp(0x378));
  printf("  outp(0x378, 0x5A)\n");
  MMPOutp(0x378, 0x5A);
  printf("  inp(0x378) = 0x%X\n", (int)MMPInp(0x378));


  // KERNEL MODE EXEC

  printf("Try to exec a function in kernel mode...\n");
  printf("  2 + 5 = %d\n", MMPKernelModeExec(Add, 2, 5));


  // GET BUS DATA
  printf("Try to get PCI bus informations...\n");
  for (int i=0; i<256; i++)
    {
    ULONG l;
    PCI_COMMON_CONFIG PCIConfig;

    l = MMPGetBusData(PCIConfiguration, 0, i, &PCIConfig, sizeof(PCI_COMMON_CONFIG));
    if (l <=2) continue;

    printf("  Slot =%3d ", i);
    printf("VendorID = 0x%4X ", (int)PCIConfig.VendorID);
    printf("DeviceID = 0x%4X\n", (int)PCIConfig.DeviceID);
    }

  
  // CLOSE

  MMPClose();
  printf("Close and end.\n");
  getchar();
  }