unit mmp;

interface

uses Windows;

TYPE
  MMPERROR = (
    MMP_OK,
    MMP_DEV_OPEN_ERR,
    MMP_DEV_CLOSE_ERR,
    MMP_DEV_IO_CTRL_ERR,
    MMP_MAP_ERR,
    MMP_PRIORITY_ERROR,
    MMP_SETUP_IRQ_ERROR,
    MMP_SETUP_THREAD_ERROR
  );

  INTERFACE_TYPE = (
    (* InterfaceTypeUndefined := -1, *)
    Internal,
    Isa,
    Eisa,
    MicroChannel,
    TurboChannel,
    PCIBus,
    VMEBus,
    NuBus,
    PCMCIABus,
    CBus,
    MPIBus,
    MPSABus,
    ProcessorInternal,
    InternalPowerBus,
    PNPISABus,
    MaximumInterfaceType
  );

  PHYSICAL_ADDRESS = LONGLONG;

  PHYSICAL_MEMORY_INFO = record
    InterfaceType: INTERFACE_TYPE;   (* Isa, Eisa, etc....                    *)
    BusNumber: ULONG;                (* Bus number, i.e. 0 for std x86 ISA    *)
    BusAddress: PHYSICAL_ADDRESS;    (* Bus-relative address (physical addr)  *)
    AddressSpace: ULONG;             (* 0 is memory, 1 is I/O                 *)
    Length: ULONG;                   (* Length of section to map              *)
  end;

  MMP_FUNC = function(Param1, Param2: ULONG): ULONG; stdcall;


function MMPLastError: MMPERROR; stdcall;

function MMPOpen: MMPERROR; stdcall;
function MMPClose: MMPERROR; stdcall;

function MMPMapUserPhysicalMem(pmi: PHYSICAL_MEMORY_INFO; var pPartyMem: POINTER): MMPERROR; stdcall;
function MMPUnmapUserPhysicalMem(pPartyMem: POINTER): MMPERROR; stdcall;

function MMPGetID(ID: PChar): MMPERROR; stdcall;

function MMPInp(IOAddr: ULONG): ULONG; stdcall;
procedure MMPOutp(IOAddr: ULONG; Data: ULONG); stdcall;
function MMPInpw(IOAddr: ULONG): ULONG; stdcall;
procedure MMPOutpw(IOAddr: ULONG; Data: ULONG); stdcall;

function MMPKernelModeExec(Func: MMP_FUNC; Param1, Param2: ULONG): ULONG; stdcall;


(*---------------------------------------------------------------------------*)
implementation

function MMPLastError: MMPERROR; stdcall; external 'mmp.dll' name 'MMPLastError';

function MMPOpen: MMPERROR; stdcall; external 'mmp.dll' name 'MMPOpen';
function MMPClose: MMPERROR; stdcall; external 'mmp.dll' name 'MMPClose';

function MMPMapUserPhysicalMem(pmi: PHYSICAL_MEMORY_INFO; var pPartyMem: POINTER): MMPERROR; stdcall; external 'mmp.dll' name 'MMPMapUserPhysicalMem';
function MMPUnmapUserPhysicalMem(pPartyMem: POINTER): MMPERROR; stdcall; external 'mmp.dll' name 'MMPUnmapUserPhysicalMem';

function MMPGetID(ID: PChar): MMPERROR; stdcall; external 'mmp.dll' name 'MMPGetID';

function MMPInp(IOAddr: ULONG): ULONG; stdcall; external 'mmp.dll' name 'MMPInp';
procedure MMPOutp(IOAddr: ULONG; Data: ULONG); stdcall; external 'mmp.dll' name 'MMPOutp';
function MMPInpw(IOAddr: ULONG): ULONG; stdcall; external 'mmp.dll' name 'MMPInpw';
procedure MMPOutpw(IOAddr: ULONG; Data: ULONG); stdcall; external 'mmp.dll' name 'MMPOutpw';

function MMPKernelModeExec(Func: MMP_FUNC; Param1, Param2: ULONG): ULONG; stdcall; external 'mmp.dll' name 'MMPKernelModeExec';

end.
