unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  mmp, Menus, StdCtrls;

type
  TMainForm = class(TForm)
    Memo: TMemo;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Go1: TMenuItem;
    Exit1: TMenuItem;
    N1: TMenuItem;
    procedure Exit1Click(Sender: TObject);
    procedure Go1Click(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  MainForm: TMainForm;
  ID : array[0..255] of Char;
  pmi : PHYSICAL_MEMORY_INFO;
  P: Pointer;

const
  pPartyMem: Pointer = NIL;
  aInterfaceType : array[0..4] of array[0..255] of char =
    ('Internal', 'Isa', 'Eisa', 'MicroChannel', 'TurboChannel');

implementation

{$R *.DFM}

function Add(a, b: ULONG): ULONG; stdcall;
begin
  Add := a + b;
end;

procedure TMainForm.Exit1Click(Sender: TObject);
begin
  Close();
end;

procedure TMainForm.Go1Click(Sender: TObject);
begin
  Memo.Lines.Add('This is a test of MMP driver');


  // OPEN

  Memo.Lines.Add('Try to open the driver...');
  if (MMPOpen() <> MMP_OK) then
    begin
    Memo.Lines.Add('  ERROR: can''t open!');
    Halt(1);
    end;
  Memo.Lines.Add('  Open OK!');


  // GET ID

  Memo.Lines.Add('Try to get driver ID...');
  MMPGetID(ID);
  Memo.Lines.Add('  ID = ' + ID);


  // MAP MEMORY

  Memo.Lines.Add('Try to map some memory...');

  pmi.InterfaceType   := Isa;        // 1 = Isa, 2 = Eisa, 3 = Microchannel, 4 = TurboChannel
  pmi.BusNumber       := 0;          // bus number, i.e. 0 for standard x86 ISA systems
  pmi.BusAddress      := $D0000;     // physical address to map
  pmi.AddressSpace    := 0;          // 0 = memory, 1 = I/O
  pmi.Length          := 10;         // length of section to map

  Memo.Lines.Add('  InterfaceType = ' + aInterfaceType[ord(pmi.InterfaceType)]);
  Memo.Lines.Add('  BusNumber     = ' + IntToStr(pmi.BusNumber));
  Memo.Lines.Add('  BusAddress    = 0x' + IntToHex(Trunc(pmi.BusAddress), 8));
  Memo.Lines.Add('  AddressSpace  = ' + IntToStr(pmi.AddressSpace));
  Memo.Lines.Add('  Length        = 0x' + IntToHex(pmi.Length, 8));
  Memo.Lines.Add('  sizeof(pmi)     = ' + IntToStr(sizeof(pmi)));
  Memo.Lines.Add('  BusAddress.High = 0x' + IntToHex(PULONG(ULONG(@pmi.BusAddress) + 4)^, 8));
  Memo.Lines.Add('  BusAddress.Low  = 0x' + IntToHex(PULONG(ULONG(@pmi.BusAddress) + 0)^, 8));

  if (MMPMapUserPhysicalMem(pmi, pPartyMem) <> MMP_OK) then
    Memo.Lines.Add('  Error: can''t map memory!')
  else
    begin
    Memo.Lines.Add('  Memory mapping OK!');
    Memo.Lines.Add('    pPartyMem = 0x' + IntToHex(ULONG(pPartyMem), 8));
    Memo.Lines.Add('    *pPartyMem = 0x' + IntToHex((PULONG(pPartyMem))^, 8));

    MMPUnmapUserPhysicalMem(pPartyMem);
    end;


  // IMP & OUTP

  Memo.Lines.Add('Try to access to IO bus...');
  Memo.Lines.Add('  outp(0x378, 0x00)');
  MMPOutp($378, $00);
  Memo.Lines.Add('  inp(0x378) = 0x' + IntToHex(MMPInp($378), 2));
  Memo.Lines.Add('  outp(0x378, 0x5A)');
  MMPOutp($378, $5A);
  Memo.Lines.Add('  inp(0x378) = 0x' + IntToHex(MMPInp($378), 2));


  // KERNEL MODE EXEC

  Memo.Lines.Add('Try to exec a function in kernel mode...');
  Memo.Lines.Add('  2 + 5 = ' + IntToStr(MMPKernelModeExec(Add, 2, 5)));


  // CLOSE

  MMPClose();
  Memo.Lines.Add('Close and end.');


end;

end.
