/*static char RcsId[] = "$Header: /segfs/dserver/classes/ccd/imagepro/src/RCS/startup.c,v 1.5 2001/10/24 08:01:26 goetz Exp $";*/

/*********************************************************************
 *
 * File:		startup.c
 *
 * Project:		Beamline Control
 *
 * Description:	Startup procedure for the ImagePro. 
 *
 * Author(s);	Andy Gotz
 *
 * Original:	24 April 1999
 *
 * $Log: startup.c,v $
 * Revision 1.5  2001/10/24 08:01:26  goetz
 * added commands for SPEC CCD compatibility; tested on Frelon1000 on ID11
 *
 * Revision 1.4  2001/10/18 10:24:53  goetz
 * changed message for V2.0
 *
 * 
 * Copyright (c) 1999 by European Synchrotron Radiation Facility, 
 *                       Grenoble, France
 *
 *
 *********************************************************************/

#include <Admin.h>
#include <API.h>
#include <DevServer.h>
#include <DevErrors.h>
#include <DevServerP.h>
#include <ImageProP.h>
#include <ImagePro.h>

#ifdef _NT
/* global pointer to text to be displayed in main window */
MainWndTextDisplay gMWndTxtDisplay;  
/*
 * Here is the place to define what to put into
 * the main window's backdrop.
 */
static char* info[]= {
		{"ImagePro 4 - image acquisition and analysis tool"},
		{"32 bit Version rev. 3.0 for Win95/NT October 2001"},
		{"Andy Gotz, ESRF, BP 220, 38043 Grenoble, France"}
		};
#endif
/*
 * pointer to list of devices returned by database.
 *
 */
static char 			**dev_list;
static unsigned int		n_devices;
static ImagePro			*ds_list;
/************************************************************************

Function   :	long startup()

Description:	create, initialise and export all of the objects
				associated with this server

Arg(s) In  :	svc_name

Arg(s) Out :	error:      error return code

Return(s)  :	minus one on failure, zero otherwise

*************************************************************************/
long startup(svr_name, error)
char *svr_name;
long *error;
{
   long		i, n_exported;
   short		iret;

   if (db_getdevlist(svr_name,&dev_list,&n_devices,error))
   {
      dprintf("startup(): db_getdevlist() failed: %s",dev_error_str(*error));
      return(-1);
   }
   dprintf("following devices found in static database: ");
   for (i=0;i<(long)n_devices;i++)
   {
      dprintf("%s",dev_list[i]);
   }

/*
 * create, initialise and export all devices served by this server
 ******************************************************************
 */
   ds_list=(ImagePro *)malloc(n_devices*sizeof(ImagePro*));
   if(ds_list==0)
   {
   	dprintf("can't allocate memory for object structures --> exit");
   	return(DS_NOTOK);
   }
   
   for (i=0, n_exported = 0; i < (long)n_devices; i++, n_exported++)
   {
      dprintf("Object %s is",dev_list[i]);
      fflush(stdout);

      if (ds__create(dev_list[i], imageProClass, &(ds_list[i]),error) != 0)
      {
   	  dprintf("create failed: %s", dev_error_str(*error));
   	  continue;
      }
      else dprintf("- Created");

      /* initialise the newly created sensicam
       *******************************************
       */
  
      if(ds__method_finder(ds_list[i],DevMethodInitialise)
			  (ds_list[i],error)!= 0)
      {
      	   dprintf("initialise failed: %s", dev_error_str(*error));
   	   continue;
      }
      else dprintf("- Initialised");

      /*  now export it to the outside world 
       *******************************************
       */
 
      if (ds__method_finder(ds_list[i],DevMethodDevExport)
			   (dev_list[i],ds_list[i],error) != 0)
      {
   	   dprintf("export failed: %s", dev_error_str(*error));
   	   continue;
      }
      else dprintf("- Exported");
   }

   switch(n_exported)
   {
      case 0:	
   	   dprintf("No devices exported - sensicam server exiting");
   	   *error = 0;
   	   iret = -1;
   	   break;

      case 1:	
   	   dprintf("ImagePro server running with 1 device exported");
   	   *error = 0;
   	   iret = 0;
   	   break;

      default:
   	   dprintf("ImagePro server running %d devices exported",n_exported);
   	   *error = 0;
   	   iret = 0;
   }
/*
 * initialise the main window's backdrop.
 */
   gMWndTxtDisplay.lines= 3;
   gMWndTxtDisplay.text= info;

   return(iret);
}
