/*static char RcsId[] = "$Header:$";*/

/*********************************************************************
 *
 * File:	ImageProP.h
 *
 * Project:	Beamline Control
 *
 * Description:	private include file for Imagepro class for the
 *		ImagePro xray camera.
 *
 * Author(s):	A.Gotz
 *
 * Original:	3 December 1997
 *
 * $Log:$
 * 
 * Copyright (c) 1997 by European Synchrotron Radiation Facility, 
 *                     Grenoble, France
 *
 *
 *********************************************************************/

#ifndef _ImageProP_H
#define _ImageProP_H


typedef struct _ImageProClassPart
{
   int		nada;
} ImageProClassPart;



typedef struct _ImageProPart
{
   long		board;
   long		size;
   long		mode;
   long		trigger;
   long		width,height;
   long		ccd_state;
   long		ccd_size;
   long		roix1,roix2,roiy1,roiy2;
   long		hbin,vbin;
   long		delay;
   long		exposure;
   long		cam_type;
   long		version;
   long		color;
   long		temp_regulation;
   long		temp_ccd;
   long		temp_electronic;
   long		bufcount,linadr;
   char		ccd_file_dir[256];
   char		ccd_file_prefix[256];
   char		ccd_file_suffix[256];
   long		ccd_file_no;
   char		ccd_file_no_fmt[256];
   char		ccd_file_overwrite[256];
} ImageProPart;



typedef struct _ImageProClassRec
{
   DevServerClassPart	devserver_class;
   ImageProClassPart	imagepro_class;
} ImageProClassRec;



extern ImageProClassRec imageProClassRec;


typedef struct _ImageProRec
{
   DevServerPart 	devserver;
   ImageProPart 	imagepro;
} ImageProRec;

#endif /*_ImageProP_H*/

