/*+*******************************************************************

 File:		DevCcdStates.h

 Project:	CCD Camera Server

 Description:	Public include CCD camera device server state definitions

 Author(s):	David Fernandez, Holger Witsch

 Original:	September 2000

 Copyright (c) 2000 by European Synchrotron Radiation Facility, 
                       Grenoble, France

********************************************************************-*/

#ifndef _CCDDEVSTATES_H
#define _CCDDEVSTATES_H

#include <DevStates.h>

/* 
 * Status values for the CCD camera device server
 */

#define DevCcdReady	DevCcdBase + 1
#define DevCcdTaking	DevCcdBase + 2
#define DevCcdFault	DevCcdBase + 3
#define DevCcdSaving	DevCcdBase + 4
#define DevCcdNotYetInitialised DevCcdBase + 5
#define DevCcdInitializing DevCcdBase + 5

/* 
 * And here are the strings coming with them
 */

#if !defined(FORTRAN)
static char *DevCcdStates[]={
  "What ... ??",		/* Should never happen */
  "DevCcdReady",		/* Ready for taking */
  "DevCcdTaking",		/* Acquiring an image */
  "DevCcdFault",		/* Faulty, check error */
  "DevCcdSaving",               /* Saving to disk*/
  "DevCcdNotYetInitialised",    /* initialisation needed */
  "DevCcdInitializing",    /* initialisation needed */
};
#endif /* FORTRAN */

#endif /* _CCDDEVSTATES_H */
