/*+*******************************************************************

 File:		DevCcdErrors.h

 Project:	CCD Camera Server

 Description:	Public include file for CCD camera device server error messages

 Author(s):	David Fernandez, Holger Witsch
 Original:	September 2000

 Copyright (c) 2000 by European Synchrotron Radiation Facility, 
                       Grenoble, France

********************************************************************-*/

#ifndef _CCDDEVERRORS_H
#define _CCDDEVERRORS_H

#include <DevErrors.h>

/* 
 * Error codes for CCD cameras
 */

#define DevErrCcdState         DevCcdBase + 1
#define DevErrCcdController    DevCcdBase + 2
#define DevErrCcdNotEnoughDisk	DevCcdBase+3
#define DevErrCcdNoDirPermission	DevCcdBase+4
#define DevErrCcdNoDirectory		DevCcdBase+5
#define DevErrCcdLongPath			DevCcdBase+6
#define DevErrCcdEmptyPath		DevCcdBase+7
#define DevErrCcdNotAccessible	DevCcdBase+8
#define DevErrCcdNoFilePermission	DevCcdBase+9
#define DevErrCcdFileExist		DevCcdBase+10
#define DevErrCcdnerCmdNotProc	DevCcdBase+11

#endif /* _CCDDEVERRORS_H */
